/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.particleLinking;

import ij.IJ;
import java.util.List;
import java.util.Vector;
import mosaic.core.detection.Particle;
import mosaic.core.particleLinking.LinkerOptions;
import org.apache.log4j.Logger;

public abstract class ParticleLinker {
    private static final Logger logger = Logger.getLogger(ParticleLinker.class);

    public boolean linkParticles(List<Vector<Particle>> aParticles, LinkerOptions aLinkOpts) {
        int currFrame;
        logger.info((Object)("Linking options: maxDisplacement: " + aLinkOpts.maxDisplacement + ", linkRange: " + aLinkOpts.linkRange + ", straightLine: " + aLinkOpts.straightLine + ", minSquaredDisplacementForAngleCalculation: " + aLinkOpts.minSquaredDisplacementForAngleCalculation + ", force: " + aLinkOpts.force + ", lSpace: " + aLinkOpts.lSpace + ", lFeature: " + aLinkOpts.lFeature + ", lDynamic: " + aLinkOpts.lDynamic));
        int NumOfFrames = aParticles.size();
        int LinkRange = aLinkOpts.linkRange;
        for (currFrame = 0; currFrame < NumOfFrames; ++currFrame) {
            for (Particle p : aParticles.get(currFrame)) {
                p.lz = 0.0f;
                p.ly = 0.0f;
                p.lx = 0.0f;
                p.lza = 0.0f;
                p.lya = 0.0f;
                p.lxa = 0.0f;
            }
        }
        for (currFrame = 0; currFrame < NumOfFrames; ++currFrame) {
            int currLinkRange = currFrame < NumOfFrames - LinkRange ? LinkRange : NumOfFrames - currFrame - 1;
            this.logInfo("----- Linking Frame " + (currFrame + 1) + "/" + NumOfFrames + " linkRange: " + currLinkRange + " ----------------------");
            Vector<Particle> p1 = aParticles.get(currFrame);
            int numOfParticles = p1.size();
            this.initParticlesLinkData(LinkRange, p1);
            for (int currLinkLevel = 1; currLinkLevel <= currLinkRange; ++currLinkLevel) {
                Vector<Particle> p2 = aParticles.get(currFrame + currLinkLevel);
                int numOfLinkParticles = aParticles.get(currFrame + currLinkLevel).size();
                float maxCost = (float)Math.pow((float)currLinkLevel * aLinkOpts.maxDisplacement, 2.0);
                this.link(p1, p2, aLinkOpts, currFrame, NumOfFrames, numOfParticles, numOfLinkParticles, currLinkLevel, maxCost);
            }
        }
        return true;
    }

    protected abstract void link(Vector<Particle> var1, Vector<Particle> var2, LinkerOptions var3, int var4, int var5, int var6, int var7, int var8, float var9);

    public float linkCost(Particle pA, Particle pB, LinkerOptions aLinkOpts, int aLinkLevel) {
        float dx = pB.iX - pA.iX;
        float dy = pB.iY - pA.iY;
        float dz = pB.iZ - pA.iZ;
        float distanceSq = dx * dx + dy * dy + dz * dz;
        float dm0 = pB.m0 - pA.m0;
        float dm2 = pB.m2 - pA.m2;
        float momentsDist = (float)Math.cbrt(dm0 * dm0 + dm2 * dm2);
        float linkCost = distanceSq * aLinkOpts.lSpace + momentsDist * aLinkOpts.lFeature;
        if (aLinkOpts.force && (double)pA.distance >= 0.0) {
            float lx = dx / (float)aLinkLevel - pA.lx;
            float ly = dy / (float)aLinkLevel - pA.ly;
            float lz = dz / (float)aLinkLevel - pA.lz;
            float dynamicCost = lx * lx + ly * ly + lz * lz;
            linkCost += aLinkOpts.lDynamic * dynamicCost;
        } else if (aLinkOpts.straightLine && (double)pA.distance >= 0.0) {
            float lx2 = dx + pA.lxa;
            float ly2 = dy + pA.lya;
            float lz2 = dz + pA.lza;
            float l2_m = (float)Math.sqrt(lx2 * lx2 + ly2 * ly2 + lz2 * lz2);
            float l1_m = (float)Math.sqrt(pA.lx * pA.lx + pA.ly * pA.ly + pA.lz * pA.lz);
            if (l2_m >= aLinkOpts.minSquaredDisplacementForAngleCalculation && l1_m > 0.0f) {
                float lx1 = pA.lx / l1_m;
                float ly1 = pA.ly / l1_m;
                float lz1 = pA.lz / l1_m;
                float cosPhi = lx1 * (lx2 /= l2_m) + ly1 * (ly2 /= l2_m) + lz1 * (lz2 /= l2_m);
                linkCost += (cosPhi - 1.0f) * (cosPhi - 1.0f) * aLinkOpts.maxDisplacement * aLinkOpts.maxDisplacement;
            }
        }
        return linkCost;
    }

    protected void handleCostFeatures(Particle pA, Particle pB, LinkerOptions aLinkOpts, int aLinkLevel) {
        float dx = pB.iX - pA.iX;
        float dy = pB.iY - pA.iY;
        float dz = pB.iZ - pA.iZ;
        if (aLinkOpts.force) {
            pB.lx = dx / (float)aLinkLevel;
            pB.ly = dy / (float)aLinkLevel;
            pB.lz = dz / (float)aLinkLevel;
            pB.distance = 1.0f;
        } else if (aLinkOpts.straightLine) {
            float distanceSq = dx * dx + dy * dy + dz * dz;
            if (distanceSq >= aLinkOpts.minSquaredDisplacementForAngleCalculation) {
                pB.lx = dx + pA.lxa;
                pB.ly = dy + pA.lya;
                pB.lz = dz + pA.lza;
            } else {
                pB.lx = pA.lx;
                pB.ly = pA.ly;
                pB.lz = pA.lz;
                pB.lxa += dx + pA.lxa;
                pB.lya += dy + pA.lya;
                pB.lza += dz + pA.lza;
                float lengthSq = pB.lxa * pB.lxa + pB.lya * pB.lya + pB.lza * pB.lza;
                if (lengthSq >= aLinkOpts.minSquaredDisplacementForAngleCalculation) {
                    pB.lx = pB.lxa;
                    pB.ly = pB.lya;
                    pB.lz = pB.lza;
                    pB.lxa = 0.0f;
                    pB.lya = 0.0f;
                    pB.lza = 0.0f;
                }
            }
            pB.distance = (float)Math.sqrt(distanceSq);
        }
    }

    protected void initParticlesLinkData(int aLinkRange, Vector<Particle> aParticles) {
        for (Particle p : aParticles) {
            p.special = false;
            p.next = new int[aLinkRange];
            for (int n = 0; n < aLinkRange; ++n) {
                p.next[n] = -1;
            }
        }
    }

    private void logInfo(String aLogStr) {
        IJ.showStatus((String)aLogStr);
        logger.info((Object)aLogStr);
    }
}

