/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.particleLinking;

import ij.IJ;
import java.util.Vector;
import mosaic.core.detection.Particle;
import mosaic.core.particleLinking.BipartiteMatcher;
import mosaic.core.particleLinking.LinkerOptions;
import mosaic.core.particleLinking.ParticleLinker;
import org.apache.log4j.Logger;

public class ParticleLinkerHungarian
extends ParticleLinker {
    private static final Logger logger = Logger.getLogger(ParticleLinkerHungarian.class);

    @Override
    protected void link(Vector<Particle> p1, Vector<Particle> p2, LinkerOptions aLinkOpts, int currFrame, int NumOfFrames, int numOfParticles, int numOfLinkParticles, int currLinkLevel, float maxCost) {
        this.logInfo("Initializing cost: " + (currFrame + 1) + "/" + NumOfFrames + " with frame: " + (currFrame + currLinkLevel + 1));
        int n = numOfParticles > numOfLinkParticles ? numOfParticles : numOfLinkParticles;
        BipartiteMatcher bm = new BipartiteMatcher(n += numOfParticles);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i < numOfParticles && j < numOfLinkParticles) {
                    double cost = this.linkCost(p1.elementAt(i), p2.elementAt(j), aLinkOpts, currLinkLevel);
                    bm.setWeight(i, j, -cost);
                    continue;
                }
                bm.setWeight(i, j, -maxCost);
            }
        }
        this.logInfo("Optimizing: " + (currFrame + 1) + "/" + NumOfFrames);
        int[] matchingResult = bm.getMatching();
        this.logInfo("Linking particles: " + (currFrame + 1) + "/" + NumOfFrames);
        for (int i = 0; i < numOfParticles; ++i) {
            if (matchingResult[i] >= numOfLinkParticles || matchingResult[i] < 0) continue;
            Particle pA = p1.elementAt(i);
            Particle pB = p2.elementAt(matchingResult[i]);
            pA.next[currLinkLevel - 1] = matchingResult[i];
            this.handleCostFeatures(pA, pB, aLinkOpts, currLinkLevel);
        }
    }

    private void logInfo(String aLogStr) {
        IJ.showStatus((String)aLogStr);
        logger.info((Object)aLogStr);
    }
}

