/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.utils;

import ij.IJ;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public class DilateImage {
    /*
     * WARNING - void declaration
     */
    public static ImageStack dilate(ImageStack ips, int radius, int number_of_threads) {
        void var7_12;
        FloatProcessor[] dilated_procs = new FloatProcessor[ips.getSize()];
        AtomicInteger z = new AtomicInteger(-1);
        Vector<DilateThread> threadsVector = new Vector<DilateThread>(number_of_threads);
        for (int thread_counter = 0; thread_counter < number_of_threads; ++thread_counter) {
            threadsVector.add(new DilateThread(ips, radius, (ImageProcessor[])dilated_procs, z));
        }
        for (Thread thread : threadsVector) {
            thread.start();
        }
        for (Thread thread : threadsVector) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                IJ.showMessage((String)("Calculation interrupted. An error occured in parallel dilation:\n" + ie.getMessage()));
            }
        }
        ImageStack dilated_ips = new ImageStack(ips.getWidth(), ips.getHeight());
        boolean bl = false;
        while (var7_12 < ips.getSize()) {
            dilated_ips.addSlice(null, (ImageProcessor)dilated_procs[var7_12]);
            ++var7_12;
        }
        return dilated_ips;
    }

    public static int[][] generateMask(int mask_radius) {
        int width = 2 * mask_radius + 1;
        int[][] mask = new int[width][width * width];
        for (int s = -mask_radius; s <= mask_radius; ++s) {
            for (int i = -mask_radius; i <= mask_radius; ++i) {
                for (int j = -mask_radius; j <= mask_radius; ++j) {
                    int index = (i + mask_radius) * width + (j + mask_radius);
                    mask[s + mask_radius][index] = i * i + j * j + s * s <= mask_radius * mask_radius ? 1 : 0;
                }
            }
        }
        return mask;
    }

    static class DilateThread
    extends Thread {
        private final ImageStack ips;
        private final ImageProcessor[] dilated_ips;
        private final AtomicInteger atomic_z;
        private final int kernel_width;
        private final int image_width;
        private final int image_height;
        private final int image_depth;
        private final int radius;
        private final int[][] mask;

        DilateThread(ImageStack is, int aRadius, ImageProcessor[] dilated_is, AtomicInteger z) {
            this.ips = is;
            this.dilated_ips = dilated_is;
            this.atomic_z = z;
            this.radius = aRadius;
            this.kernel_width = this.radius * 2 + 1;
            this.image_width = this.ips.getWidth();
            this.image_height = this.ips.getHeight();
            this.image_depth = this.ips.getSize();
            this.mask = DilateImage.generateMask(this.radius);
        }

        @Override
        public void run() {
            int z;
            while ((z = this.atomic_z.incrementAndGet()) < this.image_depth) {
                FloatProcessor out_p = new FloatProcessor(this.image_width, this.image_height);
                float[] output = (float[])out_p.getPixels();
                for (int y = 0; y < this.image_height; ++y) {
                    for (int x = 0; x < this.image_width; ++x) {
                        float max = Float.NEGATIVE_INFINITY;
                        for (int s = -this.radius; s <= this.radius; ++s) {
                            if (z + s < 0 || z + s >= this.image_depth) continue;
                            float[] current_processor_pixels = (float[])this.ips.getPixels(z + s + 1);
                            for (int b = -this.radius; b <= this.radius; ++b) {
                                if (y + b < 0 || y + b >= this.image_height) continue;
                                for (int a = -this.radius; a <= this.radius; ++a) {
                                    float f;
                                    if (x + a < 0 || x + a >= this.image_width || this.mask[s + this.radius][(a + this.radius) * this.kernel_width + (b + this.radius)] != 1) continue;
                                    float t = current_processor_pixels[(y + b) * this.image_width + (x + a)];
                                    if (!(f > max)) continue;
                                    max = t;
                                }
                            }
                        }
                        output[y * this.image_width + x] = max;
                    }
                }
                this.dilated_ips[z] = out_p;
            }
        }
    }
}

