/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.utils;

import ij.IJ;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import mosaic.core.GUI.ProgressBarWin;
import mosaic.core.cluster.ShellProcessOutput;

public class ShellCommand {
    private static String[] produceShell(String cmd) {
        if (IJ.isLinux() || IJ.isMacOSX()) {
            return new String[]{"bash", "-c", cmd};
        }
        return new String[]{"cmd /C", cmd};
    }

    public static void exeCmdNoPrint(String cmd) throws IOException, InterruptedException {
        String[] cmd_ = ShellCommand.produceShell(cmd);
        Process tProcess = Runtime.getRuntime().exec(cmd_);
        tProcess.waitFor();
    }

    public static String exeCmdString(String cmd) throws IOException, InterruptedException {
        String[] cmd_ = ShellCommand.produceShell(cmd);
        Process tProcess = Runtime.getRuntime().exec(cmd_);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(tProcess.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(tProcess.getErrorStream()));
        String out = new String();
        String s = null;
        while ((s = stdInput.readLine()) != null) {
            System.out.println(s);
            out = out + s;
        }
        while ((s = stdError.readLine()) != null) {
            System.out.println(s);
            out = out + s;
        }
        tProcess.waitFor();
        return out;
    }

    public static void exeCmd(String cmd) throws IOException, InterruptedException {
        String[] cmd_ = ShellCommand.produceShell(cmd);
        Process tProcess = Runtime.getRuntime().exec(cmd_);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(tProcess.getInputStream()));
        String s = null;
        while ((s = stdInput.readLine()) != null) {
            System.out.println(s);
        }
        tProcess.waitFor();
    }

    public static void exeCmd(String cmd, File wdir, String[] env) throws IOException, InterruptedException {
        Map<String, String> envi = System.getenv();
        if (env == null) {
            env = new String[]{};
        }
        String[] envi_p_env = new String[envi.size() + env.length];
        int i = 0;
        for (String envName : envi.keySet()) {
            envi_p_env[i] = new String(envName + "=" + envi.get(envName));
            ++i;
        }
        for (String envName : env) {
            envi_p_env[i] = new String(envName);
            ++i;
        }
        String[] cmd_ = ShellCommand.produceShell(cmd);
        Process tProcess = Runtime.getRuntime().exec(cmd_, envi_p_env, wdir);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(tProcess.getInputStream()));
        String s = null;
        while ((s = stdInput.readLine()) != null) {
            System.out.println(s);
        }
        tProcess.waitFor();
    }

    public static void exeCmd(String cmd, File wdir, String[] env, ShellProcessOutput out) throws IOException, InterruptedException {
        String s;
        Map<String, String> envi = System.getenv();
        if (env == null) {
            env = new String[]{};
        }
        String[] envi_p_env = new String[envi.size() + env.length];
        int i = 0;
        for (String envName : envi.keySet()) {
            envi_p_env[i] = new String(envName + "=" + envi.get(envName));
            ++i;
        }
        for (String envName : env) {
            envi_p_env[i] = new String(envName);
            ++i;
        }
        String[] cmd_ = ShellCommand.produceShell(cmd);
        Process tProcess = Runtime.getRuntime().exec(cmd_, envi_p_env, wdir);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(tProcess.getInputStream()));
        String s_full = new String();
        while ((s = stdInput.readLine()) != null) {
            s_full = s_full + s + "\n";
            if (out != null) {
                s_full = out.Process(s_full);
            }
            System.out.println(s);
        }
        tProcess.waitFor();
    }

    public static void copy(File from, File to, ProgressBarWin wn) {
        File[] f = from.listFiles();
        if (f == null) {
            return;
        }
        int cnt = 0;
        for (File t : f) {
            if (wn != null) {
                if (t != null) {
                    wn.SetStatusMessage("Copy: " + t.getName());
                }
                wn.SetProgress(cnt / f.length);
            }
            try {
                if (t != null) {
                    ShellCommand.exeCmd("cp -R " + t.getAbsoluteFile() + " " + to.getAbsolutePath());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++cnt;
        }
    }
}

