/*
 * Decompiled with CFR 0.152.
 */
package mosaic.noise_sample;

import java.util.Random;
import java.util.Vector;
import mosaic.noise_sample.NoiseSample;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;

public class GenericNoiseSampler<T extends RealType<T>>
implements NoiseSample<T> {
    private final Random iRandomGenerator = new Random();
    private Class<T> iClazzOfPixel;
    private final Vector<Ihist> iHistograms = new Vector();

    public GenericNoiseSampler(Class<T> cls_) {
        this.iClazzOfPixel = cls_;
    }

    public void setHistogram(T intensity, Histogram1d<T> hist) {
        Ihist tmp = new Ihist();
        tmp.intensity = intensity;
        tmp.hist = hist;
        for (int i = 0; i < this.iHistograms.size(); ++i) {
            if (!(this.iHistograms.get((int)i).intensity.getRealDouble() < intensity.getRealDouble())) continue;
            this.iHistograms.insertElementAt(tmp, i);
            return;
        }
        this.iHistograms.add(tmp);
    }

    @Override
    public void sample(T x, T out) {
        int i = 0;
        for (i = 0; i < this.iHistograms.size() && !(x.getRealDouble() > this.iHistograms.get((int)i).intensity.getRealDouble()); ++i) {
        }
        InterpolateHistogram Ih = new InterpolateHistogram(this.iHistograms.get(i), this.iHistograms.get(i + 1));
        long integral = Ih.integral(x);
        long gen = (long)(this.iRandomGenerator.nextDouble() * (double)integral);
        long tot = 0L;
        i = 0;
        while ((long)i < this.iHistograms.get((int)0).hist.getBinCount() && (tot += (long)Ih.get(x, this.iClazzOfPixel)) < gen) {
            ++i;
        }
        this.iHistograms.get((int)0).hist.getCenterValue((long)i, out);
    }

    private class InterpolateHistogram {
        Ihist h1;
        Ihist h2;

        InterpolateHistogram(Ihist h1_, Ihist h2_) {
            if (h2_.intensity.getRealDouble() > h1_.intensity.getRealDouble()) {
                this.h1 = h1_;
                this.h2 = h2_;
            } else {
                this.h1 = h2_;
                this.h2 = h1_;
            }
        }

        int get(T inte, Class<T> cls) {
            double h1dist = this.h1.intensity.getRealDouble() - inte.getRealDouble();
            double h2dist = this.h2.intensity.getRealDouble() - inte.getRealDouble();
            double h2h1dist = this.h2.intensity.getRealDouble() - this.h1.intensity.getRealDouble();
            double r1dist = h1dist / h2h1dist;
            double r2dist = h2dist / h2h1dist;
            long och1 = 0L;
            long och2 = 0L;
            try {
                RealType binsh1 = (RealType)cls.newInstance();
                binsh1.setReal(this.h1.intensity.getRealDouble() + h1dist);
                RealType binsh2 = (RealType)cls.newInstance();
                binsh2.setReal(this.h2.intensity.getRealDouble() + h2dist);
                och1 = this.h1.hist.frequency((Object)binsh1);
                och2 = this.h2.hist.frequency((Object)binsh2);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return (int)((double)och1 * r1dist + (double)och2 * r2dist);
        }

        long integral(T inte) {
            double h1dist = this.h1.intensity.getRealDouble() - inte.getRealDouble();
            double h2dist = this.h2.intensity.getRealDouble() - inte.getRealDouble();
            double h2h1dist = this.h2.intensity.getRealDouble() - this.h1.intensity.getRealDouble();
            double r1dist = h1dist / h2h1dist;
            double r2dist = h2dist / h2h1dist;
            return (int)((double)this.h1.integral * r1dist + (double)this.h2.integral * r2dist);
        }
    }

    private class Ihist {
        T intensity;
        Histogram1d<T> hist;
        long integral;

        protected Ihist() {
        }
    }
}

