/*
 * Decompiled with CFR 0.152.
 */
package mosaic.particleTracker;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import mosaic.core.GUI.HelpGUI;

public class ParticleTrackerHelp
extends HelpGUI {
    private final JFrame frame = new JFrame("Particle Tracker Help");
    private final JPanel panel;

    public ParticleTrackerHelp(int x, int y) {
        this.frame.setSize(555, 780);
        this.frame.setLocation(x + 500, y - 50);
        this.panel = new JPanel(new FlowLayout(0, 10, 5));
        this.panel.setPreferredSize(new Dimension(575, 720));
        JPanel pref = new JPanel(new GridBagLayout());
        this.setPanel(pref);
        this.setHelpTitle("Particle Tracker");
        this.createTutorial("http://mosaic.mpi-cbg.de/ParticleTracker/tutorial.html");
        this.createArticle("http://mosaic.mpi-cbg.de/docs/Sbalzarini2005a.pdf#page=1&zoom=100");
        this.createSection("Detection", null);
        String desc = new String("Approximate radius of the particles in the images in units of pixels.The value should be slightly larger than the visible particle radius,but smaller than the smallest inter-particle separation. ");
        this.createField("Radius (w)", desc, "http://mosaic.mpi-cbg.de/docs/Sbalzarini2005a.pdf#page=2&zoom=150,0,-310");
        desc = new String("The score cut-off for the non-particle discrimination");
        this.createField("Cutoff (T_s)", desc, "http://mosaic.mpi-cbg.de/docs/Sbalzarini2005a.pdf#page=3&zoom=150,0,-270");
        desc = new String("The percentile (r) that determines which bright pixels are accepted as Particles. All local maxima in the upper rth percentile of the image intensity distribution are considered candidate Particles.");
        this.createField("Percentile", desc, "http://mosaic.mpi-cbg.de/docs/Sbalzarini2005a.pdf#page=2&zoom=150,0,-370");
        this.createSection("Linking", null);
        desc = new String("The maximum number of pixels a particle is allowed to move between twosucceeding frames");
        this.createField("Displacement (L)", desc, "http://mosaic.mpi-cbg.de/docs/Sbalzarini2005a.pdf#page=4&zoom=150,0,-350");
        desc = new String("How many future frame are considered for the linking stage");
        this.createField("Link Range (R)", desc, "http://mosaic.mpi-cbg.de/docs/Sbalzarini2005a.pdf#page=4&zoom=150,0,-350");
        this.panel.add(pref);
        this.frame.add(this.panel);
        this.frame.setVisible(true);
    }
}

