/*
 * Decompiled with CFR 0.152.
 */
package mosaic.particleTracker;

import ij.ImagePlus;
import ij.gui.Roi;
import java.awt.Color;
import mosaic.core.detection.Particle;

public class Trajectory {
    public final Particle[] iParticles;
    public int iSerialNumber;
    private final ImagePlus original_imp;
    public boolean to_display = true;
    public boolean showParticles = true;
    public Color color;
    Roi mouse_selection_area;
    public Roi focus_area;

    public Trajectory(Particle[] particles, int aSerialNum, ImagePlus originalImp) {
        this.original_imp = originalImp;
        this.iParticles = particles;
        this.iSerialNumber = aSerialNum;
        this.color = Color.red;
        this.setFocusAndSelectionArea();
    }

    public boolean toDisplay() {
        return this.to_display;
    }

    public boolean drawParticle() {
        return this.showParticles;
    }

    public int getStartFrame() {
        return this.iParticles[0].getFrame();
    }

    public int getStopFrame() {
        return this.iParticles[this.iParticles.length - 1].getFrame();
    }

    public int getLength() {
        return this.getStopFrame() - this.getStartFrame() + 1;
    }

    private void setFocusAndSelectionArea() {
        if (this.original_imp == null) {
            return;
        }
        float min_x = Float.MAX_VALUE;
        float min_y = Float.MAX_VALUE;
        float max_x = -3.4028235E38f;
        float max_y = -3.4028235E38f;
        for (Particle p : this.iParticles) {
            min_x = Math.min(p.iX, min_x);
            min_y = Math.min(p.iY, min_y);
            max_x = Math.max(p.iX, max_x);
            max_y = Math.max(p.iY, max_y);
        }
        int focus_x = Math.max((int)min_x - 8, 0);
        int focus_y = Math.max((int)min_y - 8, 0);
        int focus_height = (int)max_y - focus_y + 8;
        int focus_width = (int)max_x - focus_x + 8;
        if (focus_x + focus_width > this.original_imp.getWidth()) {
            focus_width = this.original_imp.getWidth() - focus_x;
        }
        if (focus_y + focus_height > this.original_imp.getHeight()) {
            focus_height = this.original_imp.getHeight() - focus_y;
        }
        this.focus_area = new Roi(focus_x, focus_y, focus_width, focus_height);
        focus_x = (int)min_x - 1;
        focus_y = (int)min_y - 1;
        focus_height = (int)max_x - focus_x + 1;
        focus_width = (int)max_y - focus_y + 1;
        this.mouse_selection_area = new Roi(focus_x, focus_y, focus_height, focus_width);
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }

    public StringBuffer toStringBuffer() {
        StringBuffer s = new StringBuffer();
        for (Particle p : this.iParticles) {
            s.append(p.toStringBuffer());
        }
        return s.append("\n");
    }
}

