/*
 * Decompiled with CFR 0.152.
 */
package mosaic.particleTracker;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.measure.ResultsTable;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import mosaic.core.detection.Particle;
import mosaic.particleTracker.Trajectory;
import mosaic.particleTracker.TrajectoryAnalysis;
import mosaic.utils.ArrayOps;

class TrajectoryAnalysisPlot
extends ImageWindow
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final Button iMssButton = new Button(" MSS ");
    private final Button iMsdButton;
    private final Button iGetDataButton;
    private final Checkbox iLogScale;
    private final TrajectoryAnalysis iTrajectoryAnalysis;
    private double[] iX;
    private double[] iY;
    private String iXname;
    private String iYname;
    private ResultsTable iTable = null;
    private static final int WIN_WIDTH = 800;
    private static final int WIN_HEIGHT = 600;

    TrajectoryAnalysisPlot(Trajectory aTrajectory, double aPixelDim, double aTimeInterval) {
        this(aTrajectory.iParticles, aPixelDim, aTimeInterval);
    }

    private TrajectoryAnalysisPlot(Particle[] aParticles, double aPixelDim, double aTimeInterval) {
        super(new ImagePlus("Trajectory Analysis", (ImageProcessor)new ByteProcessor(800, 600, new byte[480000], null)));
        this.iMssButton.addActionListener(this);
        this.iMsdButton = new Button(" MSD ");
        this.iMsdButton.addActionListener(this);
        this.iGetDataButton = new Button("Get Data");
        this.iGetDataButton.addActionListener(this);
        this.iLogScale = new Checkbox("logarithmic scale", true);
        Panel panel = new Panel(new GridLayout(4, 1));
        panel.add(this.iMssButton);
        panel.add(this.iMsdButton);
        panel.add(this.iLogScale);
        panel.add(this.iGetDataButton);
        this.add(panel);
        this.iTrajectoryAnalysis = new TrajectoryAnalysis(aParticles);
        this.iTrajectoryAnalysis.setLengthOfAPixel(aPixelDim);
        this.iTrajectoryAnalysis.setTimeInterval(aTimeInterval);
        if (!this.iTrajectoryAnalysis.calculateAll()) {
            this.close();
            IJ.error((String)"It is impossible to calculate MSS/MSD for this trajectory!");
            return;
        }
        this.plotMss();
        this.pack();
    }

    private void updatePlot(double[] aX, double[] aY, double aSlope, double aY0, Double aDiffusionCoefficient, String aXlabel, String aYlabel, String aWindowLabel) {
        double[] slopeLine = new double[aX.length];
        for (int i = 0; i < aX.length; ++i) {
            slopeLine[i] = aSlope * aX[i] + aY0;
        }
        double minX = aX[0];
        double maxX = aX[aX.length - 1];
        ArrayOps.MinMax<Double> mmY = ArrayOps.findMinMax(aY);
        double minY = mmY.getMin();
        double maxY = mmY.getMax();
        ArrayOps.MinMax<Double> mmSlopeLine = ArrayOps.findMinMax(slopeLine);
        minY = Math.min(minY, mmSlopeLine.getMin());
        maxY = Math.max(maxY, mmSlopeLine.getMax());
        PlotWindow.noGridLines = false;
        Plot plot = new Plot("", aXlabel, aYlabel, aX, slopeLine);
        plot.setSize(800, 600);
        this.setTitle(aWindowLabel);
        plot.setLimits(minX, maxX, minY, maxY);
        plot.setLineWidth(2);
        plot.setColor(Color.red);
        plot.addPoints(aX, aY, 1);
        plot.setColor(Color.DARK_GRAY);
        plot.changeFont(new Font("Helvetica", 1, 14));
        plot.addLabel(0.05, 0.1, String.format("slope = %4.8f", aSlope));
        plot.addLabel(0.05, 0.15, String.format("y0 intercept = %5.8f", aY0));
        if (aDiffusionCoefficient != null) {
            plot.addLabel(0.05, 0.2, String.format("diffusion coefficient D2 = %5.8e", aDiffusionCoefficient));
        }
        plot.setColor(Color.blue);
        this.setImage(plot.getImagePlus());
    }

    private void plotMss() {
        if (this.iLogScale.getState()) {
            this.iX = this.iTrajectoryAnalysis.toLogScale(this.iTrajectoryAnalysis.getMomentOrders());
            this.iY = this.iTrajectoryAnalysis.toLogScale(this.iTrajectoryAnalysis.getGammasLogarithmic());
            this.iXname = "log(moment order \u03bd)";
            this.iYname = "log(scaling coefficient \u213d)";
            this.updatePlot(this.iX, this.iY, this.iTrajectoryAnalysis.getMSSlogarithmic(), this.iTrajectoryAnalysis.getMSSlogarithmicY0(), null, this.iXname, this.iYname, "MSS (log)");
        } else {
            this.iX = this.iTrajectoryAnalysis.toDouble(this.iTrajectoryAnalysis.getMomentOrders());
            this.iY = this.iTrajectoryAnalysis.getGammasLogarithmic();
            this.iXname = "moment order \u03bd";
            this.iYname = "scaling coefficient \u213d";
            this.updatePlot(this.iX, this.iY, this.iTrajectoryAnalysis.getMSSlinear(), this.iTrajectoryAnalysis.getMSSlinearY0(), null, this.iXname, this.iYname, "MSS");
        }
    }

    private void plotMsd() {
        boolean order = true;
        int size = this.iTrajectoryAnalysis.getFrameShifts().length;
        double[] timeSteps = new double[size];
        for (int i = 0; i < size; ++i) {
            timeSteps[i] = (double)this.iTrajectoryAnalysis.getFrameShifts()[i] * this.iTrajectoryAnalysis.getTimeInterval();
        }
        if (this.iLogScale.getState()) {
            this.iX = this.iTrajectoryAnalysis.toLogScale(timeSteps);
            this.iY = this.iTrajectoryAnalysis.toLogScale(this.iTrajectoryAnalysis.getMSDforMomentIdx(1));
            this.iXname = "log(\u03b4t)";
            this.iYname = "log(\u03bc(\u03b4t))";
            this.updatePlot(this.iX, this.iY, this.iTrajectoryAnalysis.getGammasLogarithmic()[1], this.iTrajectoryAnalysis.getGammasLogarithmicY0()[1], this.iTrajectoryAnalysis.getDiffusionCoefficients()[1], this.iXname, this.iYname, "MSD (log)");
        } else {
            this.iX = timeSteps;
            this.iY = this.iTrajectoryAnalysis.getMSDforMomentIdx(1);
            this.iXname = "\u03b4t";
            this.iYname = "\u03bc(\u03b4t)";
            this.updatePlot(this.iX, this.iY, this.iTrajectoryAnalysis.getGammasLinear()[1], this.iTrajectoryAnalysis.getGammasLinearY0()[1], null, this.iXname, this.iYname, "MSD");
        }
    }

    private ResultsTable getResultsTable() {
        if (this.iTable == null) {
            this.iTable = new ResultsTable();
        }
        this.iTable.reset();
        return this.iTable;
    }

    private void getData() {
        ResultsTable rt = this.getResultsTable();
        if (rt != null) {
            int i;
            for (i = 1; i < 3; ++i) {
                rt.setDecimalPlaces(i, 8);
            }
            for (i = 0; i < this.iX.length; ++i) {
                rt.incrementCounter();
                rt.setValue(this.iXname, rt.getCounter() - 1, this.iX[i]);
                rt.setValue(this.iYname, rt.getCounter() - 1, this.iY[i]);
            }
            rt.show("MSS/MSD plot data");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.iMssButton) {
            this.plotMss();
        } else if (o == this.iMsdButton) {
            this.plotMsd();
        } else if (o == this.iGetDataButton) {
            this.getData();
        }
    }
}

