/*
 * Decompiled with CFR 0.152.
 */
package mosaic.particleTracker;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import mosaic.core.detection.MyFrame;
import mosaic.particleTracker.Trajectory;
import mosaic.plugins.ParticleTracker3DModular_;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.ARGBType;

public class TrajectoryStackWin
extends StackWindow
implements MouseListener {
    private final ParticleTracker3DModular_ particleTracker3DModular;
    private static final long serialVersionUID = 1L;
    private Button filter_length;
    private Button drawParticles;
    int lastState;
    private final Label numberOfParticlesLabel;
    private Img<ARGBType> out;
    private static final String HideParticles = "Hide particles";
    private static final String ShowParticles = "Show particles";

    public TrajectoryStackWin(ParticleTracker3DModular_ particleTracker3DModular_, ImagePlus aimp, ImageCanvas icanvas, Img<ARGBType> out_) {
        super(aimp, icanvas);
        this.particleTracker3DModular = particleTracker3DModular_;
        this.numberOfParticlesLabel = new Label("");
        icanvas.addMouseListener((MouseListener)this);
        this.addPanel();
        this.changeParticleNumberLabel();
        this.out = out_;
    }

    private void changeParticleNumberLabel() {
        int currentframe = this.getImagePlus().getSlice() - 1;
        int nslices = this.getImagePlus().getNSlices();
        int nframes = this.getImagePlus().getNFrames();
        if (nslices == 1) {
            currentframe = this.getImagePlus().getChannel();
        } else if (nframes == 1) {
            currentframe = this.getImagePlus().getSlice();
        }
        this.numberOfParticlesLabel.setText("Frame " + currentframe + ": " + this.particleTracker3DModular.iFrames[currentframe - 1].getParticles().size() + " particles");
    }

    public String createSubtitle() {
        this.changeParticleNumberLabel();
        return super.createSubtitle();
    }

    private void addPanel() {
        Panel panel = new Panel(new GridLayout(2, 1));
        this.filter_length = new Button(" Filter Options ");
        this.filter_length.addActionListener((ActionListener)((Object)this));
        panel.add(this.filter_length);
        panel.add(this.numberOfParticlesLabel);
        String drawString = ShowParticles;
        System.out.println("INIT STATE: " + this.particleTracker3DModular.iTrajectories.get(0).drawParticle());
        if (this.particleTracker3DModular.iTrajectories.get(0).drawParticle()) {
            drawString = HideParticles;
        }
        this.drawParticles = new Button(drawString);
        this.drawParticles.addActionListener((ActionListener)((Object)this));
        panel.add(this.drawParticles);
        this.add(panel);
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Point loc = this.getLocation();
        Dimension size = this.getSize();
        if (loc.y + size.height > screen.height) {
            this.getCanvas().zoomOut(0, 0);
        }
    }

    public synchronized void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.filter_length && !this.particleTracker3DModular.filterTrajectories()) {
            return;
        }
        if (b == this.drawParticles) {
            System.out.println("NAME: " + this.drawParticles.getLabel());
            if (this.drawParticles.getLabel().equals(ShowParticles)) {
                System.out.println("showing");
                this.drawParticles.setLabel(HideParticles);
                this.particleTracker3DModular.setDrawingParticle(true);
            } else {
                System.out.println("hiding");
                this.drawParticles.setLabel(ShowParticles);
                this.particleTracker3DModular.setDrawingParticle(false);
            }
        }
        System.out.println("SOURCE: " + e.getSource());
        this.out = this.particleTracker3DModular.createHyperStackFromFrames();
        this.particleTracker3DModular.generateView(this.imp, this.out);
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        if (this.particleTracker3DModular.chosen_traj != -1) {
            Vector<Trajectory> v = new Vector<Trajectory>();
            v.add(this.particleTracker3DModular.iTrajectories.get(this.particleTracker3DModular.chosen_traj));
            Calibration cal = this.particleTracker3DModular.iInputImage.getCalibration();
            MyFrame.updateImage(this.out, v, cal, MyFrame.DrawType.TRAJECTORY_HISTORY, this.particleTracker3DModular.getRadius());
            this.particleTracker3DModular.chosen_traj = -1;
        }
        int x = e.getX();
        int y = e.getY();
        int offscreenX = this.ic.offScreenX(x);
        int offscreenY = this.ic.offScreenY(y);
        boolean trajectory_clicked = false;
        Iterator<Trajectory> iter = this.particleTracker3DModular.iTrajectories.iterator();
        if (this.imp == null) {
            this.removeMouseListener(this);
            return;
        }
        int[] cl = this.imp.getPixel(offscreenX, offscreenY);
        int ct = 0;
        while (iter.hasNext()) {
            Trajectory curr_traj = iter.next();
            if (curr_traj.color.getRed() == cl[0] && curr_traj.color.getGreen() == cl[1] && curr_traj.color.getBlue() == cl[2]) {
                Vector<Trajectory> v = new Vector<Trajectory>();
                v.add(curr_traj);
                Calibration cal = this.particleTracker3DModular.iInputImage.getCalibration();
                MyFrame.updateImage(this.out, v, cal, MyFrame.DrawType.TRAJECTORY_HISTORY, this.particleTracker3DModular.getRadius());
                trajectory_clicked = true;
                this.particleTracker3DModular.chosen_traj = ct;
                break;
            }
            ++ct;
        }
        if (trajectory_clicked) {
            this.imp.killRoi();
            this.imp.updateImage();
            this.particleTracker3DModular.results_window.per_traj_label.setText("Trajectory " + (this.particleTracker3DModular.chosen_traj + 1));
            if (e.getClickCount() == 2) {
                IJ.getImage().setRoi(this.particleTracker3DModular.iTrajectories.elementAt((int)this.particleTracker3DModular.chosen_traj).focus_area);
                this.particleTracker3DModular.generateTrajFocusView(this.particleTracker3DModular.chosen_traj);
            } else {
                this.imp.setRoi(this.particleTracker3DModular.iTrajectories.elementAt((int)this.particleTracker3DModular.chosen_traj).mouse_selection_area);
            }
        } else {
            this.particleTracker3DModular.chosen_traj = -1;
            this.particleTracker3DModular.results_window.per_traj_label.setText("Trajectory (select from view)");
        }
        this.showSlice(this.imp.getCurrentSlice() + 1);
        this.showSlice(this.imp.getCurrentSlice() - 1);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

