/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.gui.StackWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Button;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import mosaic.core.utils.MosaicUtils;
import org.apache.log4j.Logger;

public class BackgroundSubtractor2_
implements PlugInFilter,
ActionListener {
    private static final Logger logger = Logger.getLogger(BackgroundSubtractor2_.class);
    private int mLength = 20;
    private final int mBins = 255;
    private int mStepSize = this.mLength / 2;
    private float mBinSize = 0.0f;
    private float mGaussBlurRadius = this.mStepSize;
    private boolean mShowBackgroundImage = true;
    private boolean mDoAll = false;
    private static final int BYTE = 0;
    private static final int SHORT = 1;
    private static final int FLOAT = 2;
    private ImageStack mBackgroundImageStack = null;
    private ImagePlus mOriginalImagePlus = null;
    private int mHeight = 0;
    private int mWidth = 0;
    private boolean mAPICall = false;
    private boolean mSkipOnFailure = false;
    private Button mAutoParamButton;
    private boolean mProposeButtonClicked = false;
    private GenericDialog mParameterDialog = null;

    public int setup(String aArgs, ImagePlus aImagePlus) {
        int vReturnValue;
        String options = Macro.getOptions();
        logger.info((Object)("Macro Options: [" + options + "]"));
        if (options != null && MosaicUtils.parseCheckbox("skipOnFailure", options)) {
            logger.info((Object)"SkipOnFailure = true");
            this.mSkipOnFailure = true;
        }
        this.mOriginalImagePlus = aImagePlus;
        this.mHeight = this.mOriginalImagePlus.getHeight();
        this.mWidth = this.mOriginalImagePlus.getWidth();
        try {
            this.mLength = Integer.parseInt(aArgs);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int vWhatToDo = 2;
        while (vWhatToDo == 2) {
            vWhatToDo = this.showDialog();
            if (vWhatToDo == 0) {
                logger.debug((Object)"Plugin canceled.");
                return 4096;
            }
            if (vWhatToDo != 1) continue;
            logger.debug((Object)"Plugin OKed.");
            break;
        }
        if (this.mShowBackgroundImage) {
            this.mBackgroundImageStack = new ImageStack(aImagePlus.getWidth(), aImagePlus.getHeight());
        }
        if (((vReturnValue = IJ.setupDialog((ImagePlus)aImagePlus, (int)13)) & 0x20) != 0) {
            this.mDoAll = true;
            vReturnValue -= 32;
        }
        return vReturnValue;
    }

    public void run(ImageProcessor aImageProcessor) {
        int vType;
        if (aImageProcessor instanceof ByteProcessor) {
            vType = 0;
        } else if (aImageProcessor instanceof ShortProcessor) {
            vType = 1;
        } else if (aImageProcessor instanceof FloatProcessor) {
            vType = 2;
        } else {
            IJ.showMessage((String)"Wrong image type");
            return;
        }
        if (!this.mAPICall && (double)this.mLength >= 0.5 * (double)Math.min(this.mWidth, this.mHeight) && !IJ.showMessageWithCancel((String)"Unsure parameter", (String)"Your square length parameter seems to be too big. \n The background image will be dominated by the edge of your image.\nClick cancel to abort.")) {
            return;
        }
        logger.debug((Object)("Running with mOriginalImagePlus=" + this.mOriginalImagePlus.getTitle() + " lenght=" + this.mLength + " bins=" + 255 + " api=" + this.mAPICall + " doAll=" + this.mDoAll));
        int vStartSlice = 0;
        int vStopSlice = 0;
        if (!this.mAPICall) {
            vStartSlice = 1;
            vStopSlice = this.mOriginalImagePlus.getStackSize();
            if (!this.mDoAll) {
                vStopSlice = vStartSlice = this.mOriginalImagePlus.getCurrentSlice();
            }
        } else {
            vStartSlice = 1;
            vStopSlice = 1;
        }
        block5: for (int vS = vStartSlice; vS <= vStopSlice; ++vS) {
            int vX;
            int vBottomPixelIndex;
            int vB;
            float vShadedIntensity;
            int vX2;
            int vY;
            ImageProcessor vImageProcessor = null;
            ImageProcessor vOrigImageProcessor = null;
            if (!this.mAPICall) {
                IJ.showProgress((int)(vS - vStartSlice + 1), (int)(vStopSlice - vStartSlice + 1));
                vImageProcessor = vOrigImageProcessor = this.mOriginalImagePlus.getStack().getProcessor(vS);
            } else {
                vOrigImageProcessor = aImageProcessor;
                vImageProcessor = aImageProcessor;
            }
            vImageProcessor = vImageProcessor.convertToFloat();
            int vWidth = vImageProcessor.getWidth();
            int vHeight = vImageProcessor.getHeight();
            FloatProcessor vBackgroundProcessor = new FloatProcessor(vWidth, vHeight);
            vImageProcessor.resetMinAndMax();
            this.mBinSize = (float)(vImageProcessor.getMax() - vImageProcessor.getMin()) / 255.0f;
            if (this.mBinSize == 0.0f) {
                this.mBinSize = 1.0f;
            }
            for (vY = 0; vY < vHeight; vY += this.mStepSize) {
                for (vX2 = 0; vX2 < vWidth; vX2 += this.mStepSize) {
                    vBackgroundProcessor.setf(vX2, vY, this.GetBackgroundIntensityAt(vX2, vY, vImageProcessor));
                }
            }
            for (int vX3 = 0; vX3 < vWidth; vX3 += this.mStepSize) {
                vBackgroundProcessor.setf(vX3, this.mHeight - 1, this.GetBackgroundIntensityAt(vX3, this.mHeight - 1, vImageProcessor));
            }
            for (vY = 0; vY < this.mHeight; vY += this.mStepSize) {
                vBackgroundProcessor.setf(this.mWidth - 1, vY, this.GetBackgroundIntensityAt(this.mWidth - 1, vY, vImageProcessor));
            }
            vBackgroundProcessor.setf(this.mWidth - 1, this.mHeight - 1, this.GetBackgroundIntensityAt(this.mWidth - 1, this.mHeight - 1, vImageProcessor));
            for (vY = 0; vY < vHeight + this.mStepSize - 1; vY += this.mStepSize) {
                if (vY >= vHeight) {
                    vY = vHeight - 1;
                }
                for (vX2 = 0; vX2 < vWidth; ++vX2) {
                    int vA = vX2 % this.mStepSize;
                    if (vA == 0) continue;
                    int vRightPixelIndex = vX2 - vA + this.mStepSize < vWidth ? vX2 - vA + this.mStepSize : vWidth - 1;
                    vShadedIntensity = (float)(this.mStepSize - vA) / (float)this.mStepSize * vBackgroundProcessor.getPixelValue(vX2 - vA, vY) + (float)vA / (float)this.mStepSize * vBackgroundProcessor.getPixelValue(vRightPixelIndex, vY);
                    vBackgroundProcessor.setf(vX2, vY, vShadedIntensity);
                }
            }
            for (vY = 0; vY < vHeight; ++vY) {
                vB = vY % this.mStepSize;
                if (vB == 0) continue;
                vBottomPixelIndex = vY - vB + this.mStepSize < vHeight ? vY - vB + this.mStepSize : vHeight - 1;
                for (vX = 0; vX < vWidth + this.mStepSize - 1; vX += this.mStepSize) {
                    if (vX >= this.mWidth) {
                        vX = this.mWidth - 1;
                    }
                    vShadedIntensity = (float)(this.mStepSize - vB) / (float)this.mStepSize * vBackgroundProcessor.getPixelValue(vX, vY - vB) + (float)vB / (float)this.mStepSize * vBackgroundProcessor.getPixelValue(vX, vBottomPixelIndex);
                    vBackgroundProcessor.setf(vX, vY, vShadedIntensity);
                }
            }
            for (vY = 0; vY < vHeight; ++vY) {
                vB = vY % this.mStepSize;
                if (vB == 0) continue;
                vBottomPixelIndex = vY - vB + this.mStepSize < vHeight ? vY - vB + this.mStepSize : vHeight - 1;
                for (vX = 0; vX < vWidth; ++vX) {
                    int vA = vX % this.mStepSize;
                    if (vA == 0) continue;
                    int vRightPixelIndex = vX - vA + this.mStepSize < vWidth ? vX - vA + this.mStepSize : vWidth - 1;
                    float vShadedIntensityInX = (float)(this.mStepSize - vA) / (float)this.mStepSize * vBackgroundProcessor.getPixelValue(vX - vA, vY) + (float)vA / (float)this.mStepSize * vBackgroundProcessor.getPixelValue(vRightPixelIndex, vY);
                    float vShadedIntensityInY = (float)(this.mStepSize - vB) / (float)this.mStepSize * vBackgroundProcessor.getPixelValue(vX, vY - vB) + (float)vB / (float)this.mStepSize * vBackgroundProcessor.getPixelValue(vX, vBottomPixelIndex);
                    vBackgroundProcessor.setf(vX, vY, (vShadedIntensityInX + vShadedIntensityInY) / 2.0f);
                }
            }
            float[] vKernel = this.GenerateGaussKernel(this.mGaussBlurRadius);
            vBackgroundProcessor.convolve(vKernel, vKernel.length, 1);
            vBackgroundProcessor.convolve(vKernel, 1, vKernel.length);
            if (this.mShowBackgroundImage) {
                this.mBackgroundImageStack.addSlice("", (ImageProcessor)vBackgroundProcessor);
            }
            float[] vPixels = (float[])vImageProcessor.getPixels();
            float[] vBackgroundPixels = (float[])vBackgroundProcessor.getPixels();
            for (int vI = 0; vI < vPixels.length; ++vI) {
                int n = vI;
                vPixels[n] = vPixels[n] - vBackgroundPixels[vI];
                if (!(vPixels[vI] < 0.0f)) continue;
                vPixels[vI] = 0.0f;
            }
            switch (vType) {
                case 0: {
                    vImageProcessor = vImageProcessor.convertToByte(false);
                    vOrigImageProcessor.insert(vImageProcessor, 0, 0);
                    logger.debug((Object)"Putting back BYTE processor");
                    continue block5;
                }
                case 1: {
                    vImageProcessor = vImageProcessor.convertToShort(false);
                    vOrigImageProcessor.insert(vImageProcessor, 0, 0);
                    logger.debug((Object)"Putting back SHORT processor");
                    continue block5;
                }
                case 2: {
                    vOrigImageProcessor.insert(vImageProcessor, 0, 0);
                    logger.debug((Object)"Putting back FLOAT processor");
                    continue block5;
                }
                default: {
                    IJ.showMessage((String)"Wrong image type");
                    return;
                }
            }
        }
        if (this.mShowBackgroundImage) {
            new StackWindow(new ImagePlus("BG of " + this.mOriginalImagePlus.getTitle(), this.mBackgroundImageStack));
        }
    }

    public void SubtractBackground(ImageProcessor aImageProcessor, int aSideLength) {
        this.mAPICall = true;
        this.mHeight = aImageProcessor.getHeight();
        this.mWidth = aImageProcessor.getWidth();
        this.mDoAll = false;
        this.mShowBackgroundImage = false;
        this.mLength = aSideLength;
        this.mStepSize = this.mLength / 2;
        this.mGaussBlurRadius = this.mStepSize;
        this.run(aImageProcessor);
    }

    private float GetBackgroundIntensityAt(int aX, int aY, ImageProcessor aImageProcessor) {
        int[] vHistogramm = new int[256];
        int vPointerOnMax = 0;
        float vHistoStartIntensity = (float)aImageProcessor.getMin();
        for (int vSliderIndY = aY - this.mLength; vSliderIndY <= aY + this.mLength; ++vSliderIndY) {
            for (int vSliderIndX = aX - this.mLength; vSliderIndX <= aX + this.mLength; ++vSliderIndX) {
                int vPX = vSliderIndX;
                int vPY = vSliderIndY;
                if (vSliderIndX < 0) {
                    vPX = 0;
                }
                if (vSliderIndY < 0) {
                    vPY = 0;
                }
                if (vSliderIndX >= this.mWidth) {
                    vPX = this.mWidth - 1;
                }
                if (vSliderIndY >= this.mHeight) {
                    vPY = this.mHeight - 1;
                }
                float vV = aImageProcessor.getPixelValue(vPX, vPY);
                if (vPointerOnMax == 334) {
                    System.out.println("Stop");
                }
                int n = (int)((vV - vHistoStartIntensity) / this.mBinSize);
                vHistogramm[n] = vHistogramm[n] + 1;
                if (vHistogramm[n] <= vHistogramm[vPointerOnMax]) continue;
                vPointerOnMax = (int)((vV - vHistoStartIntensity) / this.mBinSize);
            }
        }
        return (float)vPointerOnMax * this.mBinSize + vHistoStartIntensity;
    }

    private float[] GenerateGaussKernel(float aRadius) {
        float[] vKernel = new float[3 * (int)aRadius * 2 + 1];
        int vM = vKernel.length / 2;
        for (int vI = 0; vI < vM; ++vI) {
            vKernel[vI] = (float)(1.0 / (Math.PI * 2 * (double)aRadius * (double)aRadius) * Math.exp(-((float)((vM - vI) * (vM - vI))) / (2.0f * aRadius * aRadius)));
            vKernel[vKernel.length - vI - 1] = vKernel[vI];
        }
        vKernel[vM] = (float)(1.0 / (Math.PI * 2 * (double)aRadius * (double)aRadius));
        return vKernel;
    }

    private int showDialog() {
        this.mParameterDialog = new GenericDialog("Background subtractor...");
        this.mParameterDialog.addNumericField("Length of sliding window (pixel)", (double)this.mLength, 0);
        this.mAutoParamButton = new Button("Propose length parameter");
        this.mAutoParamButton.addActionListener(this);
        Panel vLengthParamPanel = new Panel();
        vLengthParamPanel.setLayout(new GridBagLayout());
        vLengthParamPanel.add(this.mAutoParamButton);
        this.mParameterDialog.addPanel(vLengthParamPanel);
        this.mParameterDialog.addCheckbox("Show Background picture", false);
        this.mParameterDialog.showDialog();
        if (this.mParameterDialog.wasCanceled()) {
            return 0;
        }
        if (this.mProposeButtonClicked) {
            this.mProposeButtonClicked = false;
            return 2;
        }
        this.mLength = (int)this.mParameterDialog.getNextNumber();
        if (this.mLength < 0) {
            this.mAPICall = true;
            this.mLength = this.AutoDetectParameters(this.mOriginalImagePlus.getProcessor());
            logger.info((Object)("Auto-detected length for image " + this.mOriginalImagePlus.getTitle() + "=" + this.mLength));
            if (this.mLength < 0) {
                return 0;
            }
        }
        this.mShowBackgroundImage = this.mParameterDialog.getNextBoolean();
        this.mStepSize = this.mLength / 2;
        this.mGaussBlurRadius = this.mStepSize;
        return 1;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        Object vSource = e.getSource();
        if (vSource == this.mAutoParamButton) {
            this.mLength = this.AutoDetectParameters(this.mOriginalImagePlus.getProcessor());
            this.mParameterDialog.dispose();
            this.mProposeButtonClicked = true;
        }
    }

    private int AutoDetectParameters(ImageProcessor aImageProcessor) {
        ImageProcessor vInitProcessor = aImageProcessor.convertToFloat();
        float vThreshold = (float)aImageProcessor.getMinThreshold();
        float[] vPixels = (float[])vInitProcessor.getPixels();
        if (aImageProcessor.getMinThreshold() == -808080.0) {
            ImageStatistics vStats = ImageStatistics.getStatistics((ImageProcessor)vInitProcessor, (int)16, null);
            vThreshold = vInitProcessor.getAutoThreshold(vStats.histogram);
            vThreshold = (float)(vInitProcessor.getMin() + (double)vThreshold / 255.0 * (vInitProcessor.getMax() - vInitProcessor.getMin()));
        }
        if (aImageProcessor.getCalibrationTable() != null) {
            vThreshold = aImageProcessor.getCalibrationTable()[(int)vThreshold];
        }
        vInitProcessor.resetMinAndMax();
        int vMaxPointer = 0;
        boolean[] vBitmap = null;
        vBitmap = new boolean[vPixels.length];
        for (int vP = 0; vP < vPixels.length; ++vP) {
            vBitmap[vP] = vPixels[vP] > vThreshold;
        }
        Vector<Vector<Integer>> vAreas = null;
        try {
            vAreas = this.SearchAreasInBitmap(vBitmap);
        }
        catch (StackOverflowError aSOE) {
            if (!this.mSkipOnFailure) {
                IJ.showMessage((String)"The parameter detection failed.\nTry again with the minimum threshold set.\n(Menu Image\\Adjust\\Threshold)");
            }
            return this.mLength;
        }
        for (int vI = 1; vI < vAreas.size(); ++vI) {
            if (vAreas.elementAt(vI).size() <= vAreas.elementAt(vMaxPointer).size()) continue;
            vMaxPointer = vI;
        }
        Vector<Integer> vBoundary = this.SearchBoundary(vBitmap, vAreas.elementAt(vMaxPointer));
        float vMaxDist = 0.0f;
        for (int vI = 0; vI < vBoundary.size(); ++vI) {
            for (int vJ = vI + 1; vJ < vBoundary.size(); ++vJ) {
                int vY2;
                int vX1 = vBoundary.elementAt(vI) % this.mWidth;
                int vY1 = vBoundary.elementAt(vI) / this.mWidth;
                int vX2 = vBoundary.elementAt(vJ) % this.mWidth;
                float vD = (vX1 - vX2) * (vX1 - vX2) + (vY1 - (vY2 = vBoundary.elementAt(vJ) / this.mWidth)) * (vY1 - vY2);
                if (!(vD > vMaxDist)) continue;
                vMaxDist = vD;
            }
        }
        vMaxDist = (float)Math.sqrt(vMaxDist);
        return (int)(vMaxDist * 2.0f + 1.0f) + 1;
    }

    private Vector<Vector<Integer>> SearchAreasInBitmap(boolean[] aBitmap) {
        Vector<Vector<Integer>> vAreas = new Vector<Vector<Integer>>();
        boolean[] vAlreadyVisited = new boolean[aBitmap.length];
        for (int vP = 0; vP < aBitmap.length; ++vP) {
            IJ.showProgress((int)vP, (int)aBitmap.length);
            if (!aBitmap[vP] || vAlreadyVisited[vP]) continue;
            vAreas.add(this.SearchArea(aBitmap, vAlreadyVisited, vP));
        }
        return vAreas;
    }

    private Vector<Integer> SearchArea(boolean[] aBitmap, boolean[] aAlreadyVisitedMask, int aPixel) {
        if (!aBitmap[aPixel] || aAlreadyVisitedMask[aPixel]) {
            return new Vector<Integer>();
        }
        int vWidth = this.mOriginalImagePlus.getWidth();
        int vHeight = this.mOriginalImagePlus.getHeight();
        Vector<Integer> vArea = new Vector<Integer>();
        vArea.add(aPixel);
        aAlreadyVisitedMask[aPixel] = true;
        if (aPixel % vWidth != vWidth - 1 && aBitmap[aPixel + 1] && !aAlreadyVisitedMask[aPixel + 1]) {
            vArea.addAll(this.SearchArea(aBitmap, aAlreadyVisitedMask, aPixel + 1));
        }
        if (aPixel % vWidth != vWidth - 1 && aPixel > vWidth && aBitmap[aPixel - vWidth + 1] && !aAlreadyVisitedMask[aPixel - vWidth + 1]) {
            vArea.addAll(this.SearchArea(aBitmap, aAlreadyVisitedMask, aPixel - vWidth + 1));
        }
        if (aPixel > vWidth && aBitmap[aPixel - vWidth] && !aAlreadyVisitedMask[aPixel - vWidth]) {
            vArea.addAll(this.SearchArea(aBitmap, aAlreadyVisitedMask, aPixel - vWidth));
        }
        if (aPixel % vWidth != 0 && aPixel > vWidth && aBitmap[aPixel - vWidth - 1] && !aAlreadyVisitedMask[aPixel - vWidth - 1]) {
            vArea.addAll(this.SearchArea(aBitmap, aAlreadyVisitedMask, aPixel - vWidth - 1));
        }
        if (aPixel % vWidth != 0 && aBitmap[aPixel - 1] && !aAlreadyVisitedMask[aPixel - 1]) {
            vArea.addAll(this.SearchArea(aBitmap, aAlreadyVisitedMask, aPixel - 1));
        }
        if (aPixel % vWidth != 0 && aPixel < (vHeight - 1) * vWidth && aBitmap[aPixel + vWidth - 1] && !aAlreadyVisitedMask[aPixel + vWidth - 1]) {
            vArea.addAll(this.SearchArea(aBitmap, aAlreadyVisitedMask, aPixel + vWidth - 1));
        }
        if (aPixel < (vHeight - 1) * vWidth && aBitmap[aPixel + vWidth] && !aAlreadyVisitedMask[aPixel + vWidth]) {
            vArea.addAll(this.SearchArea(aBitmap, aAlreadyVisitedMask, aPixel + vWidth));
        }
        if (aPixel % vWidth != vWidth - 1 && aPixel < (vHeight - 1) * vWidth && aBitmap[aPixel + vWidth + 1] && !aAlreadyVisitedMask[aPixel + vWidth + 1]) {
            vArea.addAll(this.SearchArea(aBitmap, aAlreadyVisitedMask, aPixel + vWidth + 1));
        }
        return vArea;
    }

    private Vector<Integer> SearchBoundary(boolean[] aBitmap, Vector<Integer> aArea) {
        Vector<Integer> vB = new Vector<Integer>();
        int vWidth = this.mOriginalImagePlus.getWidth();
        int vHeight = this.mOriginalImagePlus.getHeight();
        for (int vP : aArea) {
            if (vP == 0 || vP == vWidth - 1 || vP == (vHeight - 1) * vWidth || vP == (vHeight - 1) * vWidth + vWidth - 1) {
                vB.add(vP);
                continue;
            }
            if (vP % vWidth == vWidth - 1) {
                if (aBitmap[vP - vWidth] && aBitmap[vP + vWidth]) continue;
                vB.add(vP);
                continue;
            }
            if (vP < vWidth) {
                if (aBitmap[vP - 1] && aBitmap[vP + 1]) continue;
                vB.add(vP);
                continue;
            }
            if (vP % vWidth == 0) {
                if (aBitmap[vP - vWidth] && aBitmap[vP + vWidth]) continue;
                vB.add(vP);
                continue;
            }
            if (vP > (vHeight - 1) * vWidth) {
                if (aBitmap[vP - 1] && aBitmap[vP + 1]) continue;
                vB.add(vP);
                continue;
            }
            int vNeighbourCode = 0;
            if (!aBitmap[vP + 1]) {
                ++vNeighbourCode;
            }
            if (!aBitmap[vP + 1 - vWidth]) {
                vNeighbourCode += 2;
            }
            if (!aBitmap[vP - vWidth]) {
                vNeighbourCode += 4;
            }
            if (!aBitmap[vP - 1 - vWidth]) {
                vNeighbourCode += 8;
            }
            if (!aBitmap[vP - 1]) {
                vNeighbourCode += 16;
            }
            if (!aBitmap[vP - 1 + vWidth]) {
                vNeighbourCode += 32;
            }
            if (!aBitmap[vP + vWidth]) {
                vNeighbourCode += 64;
            }
            if (!aBitmap[vP + vWidth + 1]) {
                vNeighbourCode += 128;
            }
            if ((vNeighbourCode & 0xF) != 15 && (vNeighbourCode & 0x1E) != 30 && (vNeighbourCode & 0x3C) != 60 && (vNeighbourCode & 0x78) != 120 && (vNeighbourCode & 0xF0) != 240 && (vNeighbourCode & 0xE1) != 225 && (vNeighbourCode & 0xC3) != 195 && (vNeighbourCode & 0x87) != 135) continue;
            vB.add(vP);
        }
        return vB;
    }
}

