/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.process.FloatProcessor;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import mosaic.plugins.utils.PlugInFloat3DBase;
import mosaic.utils.ImgUtils;
import mosaic.variationalCurvatureFilters.FilterKernelGc3D;
import mosaic.variationalCurvatureFilters.NoSplitFilter3D;

public class GaussianCurvature3D
extends PlugInFloat3DBase {
    private int iNumberOfIterations;
    private final String PropNoOfIterations = "GaussianCuvature3D.noOfIterations";

    @Override
    protected void processImg(FloatProcessor[] aOutputImg, FloatProcessor[] aOrigImg, int aChannelNumber) {
        int originalWidth = aOrigImg[0].getWidth();
        int originalHeight = aOrigImg[0].getHeight();
        int noOfSlices = aOrigImg.length;
        float[][][] img = new float[noOfSlices][originalHeight][originalWidth];
        for (int slice = 0; slice < noOfSlices; ++slice) {
            ImgUtils.ImgToYX2Darray(aOrigImg[slice], img[slice], 1.0f);
        }
        NoSplitFilter3D filter = new NoSplitFilter3D(new FilterKernelGc3D());
        for (int iteration = 0; iteration < this.iNumberOfIterations; ++iteration) {
            IJ.showProgress((double)((double)iteration / (double)this.iNumberOfIterations));
            IJ.showStatus((String)("Running iteration: " + (iteration + 1) + "/" + this.iNumberOfIterations));
            filter.runFilter(img, 1);
        }
        for (int slice = 0; slice < noOfSlices; ++slice) {
            ImgUtils.YX2DarrayToImg(img[slice], aOutputImg[slice], 1.0f);
        }
    }

    @Override
    protected boolean showDialog() {
        GenericDialog gd = new GenericDialog("Curvature Filter 3D");
        gd.addNumericField("Number_of_iterations: ", (double)((int)Prefs.get((String)"GaussianCuvature3D.noOfIterations", (double)100.0)), 0);
        gd.addMessage("\n");
        String referenceInfo = "\n@phdthesis{gong:phd, \n  title={Spectrally regularized surfaces}, \n  author={Gong, Yuanhao}, \n  year={2015}, \n  school={ETH Zurich, Nr. 22616},\n  note={http://dx.doi.org/10.3929/ethz-a-010438292}}\n\n";
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        TextArea ta = new TextArea("\n@phdthesis{gong:phd, \n  title={Spectrally regularized surfaces}, \n  author={Gong, Yuanhao}, \n  year={2015}, \n  school={ETH Zurich, Nr. 22616},\n  note={http://dx.doi.org/10.3929/ethz-a-010438292}}\n\n", 8, 50, 3);
        ta.setBackground(SystemColor.control);
        ta.setEditable(false);
        ta.setFocusable(true);
        panel.add(ta);
        gd.addPanel(panel);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        int iterations = (int)gd.getNextNumber();
        Prefs.set((String)"GaussianCuvature3D.noOfIterations", (int)iterations);
        this.iNumberOfIterations = iterations;
        return true;
    }

    @Override
    protected boolean setup(String aArgs) {
        this.setFilePrefix("filtered_");
        return true;
    }
}

