/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.macro.Interpreter;
import ij.measure.ResultsTable;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import mosaic.plugins.utils.PlugIn8bitBase;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class Naturalization
extends PlugIn8bitBase {
    private static final float EPS = 1.0E-4f;
    private static final float T1_pr = 0.3754f;
    private static final int N_Lap = 2041;
    private static final int Lap_Offset = 1020;
    private static final int N_Grad = 512;
    private static final int Grad_Offset = 256;
    private final float[] T2_pr = new float[]{0.2421f, 0.255f, 0.2474f, 0.24816667f};
    private final Map<Integer, Map<Integer, Float>> iPsnrOutput = new TreeMap<Integer, Map<Integer, Float>>();

    private synchronized void addPsnr(int aSlice, int aChannel, float aValue) {
        Map<Integer, Float> map = this.iPsnrOutput.get(aSlice);
        boolean isNewMap = false;
        if (map == null) {
            map = new TreeMap<Integer, Float>();
            isNewMap = true;
        }
        map.put(aChannel, Float.valueOf(aValue));
        if (isNewMap) {
            this.iPsnrOutput.put(aSlice, map);
        }
    }

    @Override
    protected void processImg(ByteProcessor aOutputImg, ByteProcessor aOrigImg, int aChannelNumber) {
        ImagePlus naturalizedImg = this.naturalize8bitImage(aOrigImg, aChannelNumber);
        aOutputImg.setPixels(naturalizedImg.getProcessor().getPixels());
    }

    @Override
    protected void postprocessBeforeShow() {
        ResultsTable rs = new ResultsTable();
        for (Map.Entry<Integer, Map<Integer, Float>> e : this.iPsnrOutput.entrySet()) {
            rs.incrementCounter();
            for (Map.Entry<Integer, Float> m : e.getValue().entrySet()) {
                switch (m.getKey()) {
                    case 0: {
                        rs.addValue("Naturalization R", (double)m.getValue().floatValue());
                        rs.addValue("Estimated R PSNR", this.calculate_PSNR(m.getValue().floatValue()));
                        break;
                    }
                    case 1: {
                        rs.addValue("Naturalization G", (double)m.getValue().floatValue());
                        rs.addValue("Estimated G PSNR", this.calculate_PSNR(m.getValue().floatValue()));
                        break;
                    }
                    case 2: {
                        rs.addValue("Naturalization B", (double)m.getValue().floatValue());
                        rs.addValue("Estimated B PSNR", this.calculate_PSNR(m.getValue().floatValue()));
                        break;
                    }
                    case 3: {
                        rs.addValue("Naturalization", (double)m.getValue().floatValue());
                        rs.addValue("Estimated PSNR", this.calculate_PSNR(m.getValue().floatValue()));
                        break;
                    }
                }
            }
        }
        if (!Interpreter.isBatchMode()) {
            rs.show("Naturalization and PSNR");
            this.showMessage();
        }
    }

    private ImagePlus naturalize8bitImage(ByteProcessor imp, int aChannelNumber) {
        Img<UnsignedByteType> TChannel = ImagePlusAdapter.wrap((ImagePlus)new ImagePlus("", (ImageProcessor)imp));
        float T2_prior = this.T2_pr[aChannelNumber <= 2 ? 2 - aChannelNumber : 3];
        float[] result = new float[]{0.0f};
        TChannel = this.performNaturalization(TChannel, T2_prior, result);
        this.addPsnr(imp.getSliceNumber(), aChannelNumber, result[0]);
        return ImageJFunctions.wrap(TChannel, (String)"temporaryName");
    }

    private <T extends NumericType<T> & NativeType<T>, S extends RealType<S>> Img<T> doNaturalization(Img<T> image_orig, S Theta, Class<T> cls_t, float T2_prior, float[] result) throws InstantiationException, IllegalAccessException {
        float Nf;
        if (image_orig == null) {
            return null;
        }
        NumericType image_check = (NumericType)cls_t.newInstance();
        NumericType obj = image_check;
        if (!(obj instanceof UnsignedByteType)) {
            IJ.error((String)"Error it work only with 8-bit type");
            return null;
        }
        result[0] = Nf = this.findNaturalizationFactor(image_orig, Theta, T2_prior);
        Img<T> image_result = this.naturalizeImage(image_orig, Nf, cls_t);
        return image_result;
    }

    private <S extends RealType<S>, T extends NumericType<T> & NativeType<T>> Img<T> naturalizeImage(Img<T> image_orig, float Nf, Class<T> cls_t) throws InstantiationException, IllegalAccessException {
        float mean_original = 0.0f;
        Cursor c2 = image_orig.cursor();
        float count = 0.0f;
        while (c2.hasNext()) {
            c2.next();
            mean_original += ((ComplexType)((NumericType)c2.get())).getRealFloat();
            count += 1.0f;
        }
        mean_original /= count;
        long[] origImgDimensions = new long[2];
        image_orig.dimensions(origImgDimensions);
        Img image_result = image_orig.factory().create(origImgDimensions, cls_t.newInstance());
        Cursor cur_orig = image_orig.cursor();
        Cursor cur_ir = image_result.cursor();
        while (cur_orig.hasNext()) {
            cur_orig.next();
            cur_ir.next();
            float tmp = ((ComplexType)((NumericType)cur_orig.get())).getRealFloat();
            float Nat = (int)((double)((tmp - mean_original) * Nf + mean_original) + 0.5);
            if (Nat < 0.0f) {
                Nat = 0.0f;
            } else if (Nat > 255.0f) {
                Nat = 255.0f;
            }
            ((ComplexType)((NumericType)cur_ir.get())).setReal(Nat);
        }
        return image_result;
    }

    private <S extends RealType<S>, T extends NumericType<T> & NativeType<T>> float findNaturalizationFactor(Img<T> image_orig, S Theta, float T2prior) {
        ArrayImgFactory imgFactoryF = new ArrayImgFactory();
        Img LapCDF = imgFactoryF.create(new long[]{2041L}, (Object)new FloatType());
        Img GradCDF = imgFactoryF.create(new long[]{512L, 2L}, (Object)new FloatType());
        Img<FloatType> GradD = this.create2DGradientField();
        this.calculateLaplaceFieldAndGradient(image_orig, (Img<FloatType>)LapCDF, GradD);
        this.convertGrad2dToCDF(GradD);
        this.calculateGradCDF((Img<FloatType>)GradCDF, GradD);
        this.calculateLapCDF((Img<FloatType>)LapCDF);
        float T_tmp = (float)this.FindT((IterableInterval<FloatType>)Views.iterable((RandomAccessibleInterval)Views.hyperSlice((RandomAccessibleInterval)GradCDF, (int)(GradCDF.numDimensions() - 1), (long)0L)), 512, 256, 1.0E-4f);
        T_tmp = (float)((double)T_tmp + this.FindT((IterableInterval<FloatType>)Views.iterable((RandomAccessibleInterval)Views.hyperSlice((RandomAccessibleInterval)GradCDF, (int)(GradCDF.numDimensions() - 1), (long)1L)), 512, 256, 1.0E-4f));
        float T1 = T_tmp / 0.7508f;
        float T2 = (float)this.FindT((IterableInterval<FloatType>)LapCDF, 2041, 1020, 1.0E-4f) / T2prior;
        float Nf = (float)((1.0 - Theta.getRealDouble()) * (double)T1 + Theta.getRealDouble() * (double)T2);
        return Nf;
    }

    String calculate_PSNR(double x) {
        if (x >= 0.0 && x <= 0.934) {
            return String.format("%.2f", new Float(23.65 * Math.exp(0.6 * x) - 20.0 * Math.exp(-7.508 * x)));
        }
        if (x > 0.934 && x < 1.07) {
            return new String("> 40");
        }
        if (x >= 1.07 && x < 1.9) {
            return String.format("%.2f", new Float(-11.566 * x + 52.776));
        }
        return String.format("%.2f", new Float(13.06 * x * x * x * x - 121.4 * x * x * x + 408.5 * x * x - 595.5 * x + 349.0));
    }

    private Img<UnsignedByteType> performNaturalization(Img<UnsignedByteType> channel, float T2_prior, float[] result) {
        FloatType Theta = new FloatType(0.5f);
        try {
            channel = this.doNaturalization(channel, Theta, UnsignedByteType.class, T2_prior, result);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return channel;
    }

    private double FindT_Evalue(float[] p_d, int N, int offset, float T) {
        double error = 0.0;
        for (int i = -offset; i < N - offset; ++i) {
            double tmp = Math.atan(T * (float)i) - (double)p_d[i + offset];
            error += tmp * tmp;
        }
        return error;
    }

    private double FindT(IterableInterval<FloatType> data, int N, int OffSet, float eps) {
        float left = 0.0f;
        float right = 1.0f;
        float m1 = 0.0f;
        float m2 = 0.0f;
        float[] p_t = new float[N];
        Cursor cur_data = data.cursor();
        for (int i = 0; i < N; ++i) {
            cur_data.next();
            p_t[i] = (float)(((double)((FloatType)cur_data.get()).getRealFloat() - 0.5) * Math.PI);
        }
        while (right - left >= eps) {
            m1 = left + (right - left) / 3.0f;
            m2 = right - (right - left) / 3.0f;
            if (this.FindT_Evalue(p_t, N, OffSet, m1) <= this.FindT_Evalue(p_t, N, OffSet, m2)) {
                right = m2;
                continue;
            }
            left = m1;
        }
        return (m1 + m2) / 2.0f;
    }

    private Img<FloatType> create2DGradientField() {
        long[] dims = new long[]{512L, 512L};
        ArrayImg GradD = new ArrayImgFactory().create(dims, (NativeType)new FloatType());
        return GradD;
    }

    private void calculateLapCDF(Img<FloatType> LapCDF) {
        RandomAccess Lap_hist2 = LapCDF.randomAccess();
        for (int i = 1; i < 2041; ++i) {
            Lap_hist2.setPosition(i - 1, 0);
            float prec = ((FloatType)Lap_hist2.get()).getRealFloat();
            Lap_hist2.move(1, 0);
            ((FloatType)Lap_hist2.get()).set(((FloatType)Lap_hist2.get()).getRealFloat() + prec);
        }
    }

    private void calculateGradCDF(Img<FloatType> GradCDF, Img<FloatType> GradD) {
        RandomAccess Grad_dist = GradD.randomAccess();
        IntervalView Gradx = Views.hyperSlice(GradCDF, (int)(GradCDF.numDimensions() - 1), (long)0L);
        IntervalView Grady = Views.hyperSlice(GradCDF, (int)(GradCDF.numDimensions() - 1), (long)1L);
        this.integrateOverRowAndCol((RandomAccess<FloatType>)Grad_dist, (IntervalView<FloatType>)Gradx, (IntervalView<FloatType>)Grady);
        this.scaleGradiens((IntervalView<FloatType>)Gradx, (IntervalView<FloatType>)Grady);
    }

    private void scaleGradiens(IntervalView<FloatType> Gradx, IntervalView<FloatType> Grady) {
        RandomAccess Gradx_r2 = Gradx.randomAccess();
        RandomAccess Grady_r2 = Grady.randomAccess();
        for (int i = 0; i < 512; ++i) {
            Gradx_r2.setPosition(i, 0);
            Grady_r2.setPosition(i, 0);
            ((FloatType)Gradx_r2.get()).set((float)((double)((FloatType)Gradx_r2.get()).getRealFloat() / 255.0));
            ((FloatType)Grady_r2.get()).set((float)((double)((FloatType)Grady_r2.get()).getRealFloat() / 255.0));
        }
    }

    private void integrateOverRowAndCol(RandomAccess<FloatType> Grad_dist, IntervalView<FloatType> Gradx, IntervalView<FloatType> Grady) {
        int[] loc = new int[2];
        RandomAccess Gradx_r = Gradx.randomAccess();
        for (int i = 0; i < 512; ++i) {
            loc[1] = i;
            Gradx_r.setPosition(i, 0);
            int j = 0;
            while (j < 512) {
                loc[0] = j++;
                Grad_dist.setPosition(loc);
                ((FloatType)Gradx_r.get()).set(((FloatType)Gradx_r.get()).getRealFloat() + ((FloatType)Grad_dist.get()).getRealFloat());
            }
        }
        RandomAccess Grady_r = Grady.randomAccess();
        for (int i = 0; i < 512; ++i) {
            loc[1] = i;
            Grady_r.setPosition(0, 0);
            int j = 0;
            while (j < 512) {
                loc[0] = j++;
                Grad_dist.setPosition(loc);
                ((FloatType)Grady_r.get()).set(((FloatType)Grady_r.get()).getRealFloat() + ((FloatType)Grad_dist.get()).getRealFloat());
                Grady_r.move(1, 0);
            }
        }
    }

    private <T extends RealType<T>> void calculateLaplaceFieldAndGradient(Img<T> image, Img<FloatType> LapCDF, Img<FloatType> GradD) {
        RandomAccess Grad_dist = GradD.randomAccess();
        long[] origImgDimensions = new long[2];
        image.dimensions(origImgDimensions);
        ArrayImg laplaceField = new ArrayImgFactory().create(origImgDimensions, (NativeType)new FloatType());
        int[] indexD = new int[2];
        int[] loc_p = new int[2];
        RandomAccess img_cur = image.randomAccess();
        RandomAccess Lap_f = laplaceField.randomAccess();
        RandomAccess Lap_hist = LapCDF.randomAccess();
        long n_pixel = 1L;
        for (int i = 0; i < laplaceField.numDimensions(); ++i) {
            n_pixel *= laplaceField.dimension(i) - 2L;
        }
        double f = 1.0 / (double)n_pixel;
        Cursor cur = laplaceField.cursor();
        while (cur.hasNext()) {
            cur.next();
            cur.localize(loc_p);
            boolean border = false;
            for (int i = 0; i < image.numDimensions(); ++i) {
                if (loc_p[i] == 0) {
                    border = true;
                    continue;
                }
                if ((long)loc_p[i] != image.dimension(i) - 1L) continue;
                border = true;
            }
            if (border) continue;
            img_cur.setPosition(loc_p);
            float L = -4.0f * ((RealType)img_cur.get()).getRealFloat();
            for (int i = 0; i < 2; ++i) {
                img_cur.move(1, i);
                float G_p = ((RealType)img_cur.get()).getRealFloat();
                img_cur.move(-1, i);
                float G_m = ((RealType)img_cur.get()).getRealFloat();
                img_cur.move(-1, i);
                float L_m = ((RealType)img_cur.get()).getRealFloat();
                img_cur.setPosition(loc_p);
                L += G_p + L_m;
                indexD[1 - i] = (int)(256.0f + G_p - G_m);
            }
            Lap_f.setPosition(loc_p);
            ((FloatType)Lap_f.get()).setReal(L);
            Lap_hist.setPosition((int)(L += 1020.0f), 0);
            ((FloatType)Lap_hist.get()).setReal((double)((FloatType)Lap_hist.get()).getRealFloat() + f);
            Grad_dist.setPosition(indexD);
            ((FloatType)Grad_dist.get()).setReal((double)((FloatType)Grad_dist.get()).getRealFloat() + f);
        }
    }

    private void convertGrad2dToCDF(Img<FloatType> GradD) {
        float prec;
        int i;
        RandomAccess Grad_dist = GradD.randomAccess();
        int[] loc = new int[GradD.numDimensions()];
        int j = 0;
        while ((long)j < GradD.dimension(1)) {
            loc[1] = j;
            i = 1;
            while ((long)i < GradD.dimension(0)) {
                loc[0] = i - 1;
                Grad_dist.setPosition(loc);
                prec = ((FloatType)Grad_dist.get()).getRealFloat();
                Grad_dist.move(1, 0);
                ((FloatType)Grad_dist.get()).set(((FloatType)Grad_dist.get()).getRealFloat() + prec);
                ++i;
            }
            ++j;
        }
        j = 1;
        while ((long)j < GradD.dimension(1)) {
            loc[1] = j - 1;
            i = 0;
            while ((long)i < GradD.dimension(0)) {
                loc[0] = i++;
                Grad_dist.setPosition(loc);
                prec = ((FloatType)Grad_dist.get()).getRealFloat();
                Grad_dist.move(1, 1);
                ((FloatType)Grad_dist.get()).set(((FloatType)Grad_dist.get()).getRealFloat() + prec);
            }
            ++j;
        }
    }

    private void showMessage() {
        final JDialog win = new JDialog((Dialog)null, "Naturalization", true);
        JPanel msg = new JPanel();
        msg.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JTextPane text = new JTextPane();
        text.setContentType("text/html");
        text.setText("<html>Y. Gong and I. F. Sbalzarini. Image enhancement by gradient distribution specification. In Proc. ACCV, <br>12th Asian Conference on Computer Vision, Workshop on Emerging Topics in Image Enhancement and Restoration,<br>pages w7\u2013p3, Singapore, November 2014.<br><br>Y. Gong and I. F. Sbalzarini, Gradient Distributions Priors for Biomedical Image Processing, 2014<br><a href=\"http://arxiv.org/abs/1408.3300\">http://arxiv.org/abs/1408.3300</a><br><br>Y. Gong and I. F. Sbalzarini. A Natural-Scene Gradient Distribution Prior and its Application in Light-Microscopy Image Processing.<br>IEEE Journal of Selected Topics in Signal Processing, Vol.10, No.1, February 2016, pages 99-114<br>ISSN: 1932-4553, DOI: 10.1109/JSTSP.2015.2506122<br><br></html>");
        text.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        text.setEditable(false);
        msg.add(text);
        JButton button = new JButton("Close");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                win.dispose();
            }
        });
        msg.add(button);
        win.add(msg);
        win.pack();
        win.setDefaultCloseOperation(2);
        win.setVisible(true);
    }

    @Override
    protected boolean showDialog() {
        return true;
    }

    @Override
    protected boolean setup(String aArgs) {
        this.setFilePrefix("naturalized_");
        return true;
    }
}

