/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import mosaic.core.cluster.BatchList;
import mosaic.core.cluster.ClusterGUI;
import mosaic.core.cluster.ClusterProfile;
import mosaic.core.cluster.DataCompression;
import mosaic.core.cluster.FileClusterProfile;
import mosaic.core.cluster.QueueProfile;

public class NewClusterProfile
implements PlugInFilter {
    FileClusterProfile fcp;
    Choice cpa;

    public void run(ImageProcessor arg0) {
    }

    void popupClusterProfile(ClusterProfile cp) {
        final Vector<QueueProfile> cq = new Vector<QueueProfile>();
        this.fcp = new FileClusterProfile(null);
        GenericDialog gd = new GenericDialog("New cluster profile");
        gd.setTitle("New cluster profile");
        if (cp != null) {
            gd.addStringField("profile", cp.getProfileName());
            gd.addStringField("address", cp.getAccessAddress());
            gd.addChoice("Batch", BatchList.getList(), BatchList.getList()[0]);
            gd.addStringField("run_dir", ((FileClusterProfile)cp).getRunningDirRaw());
            int totalq = 0;
            for (ClusterProfile.hw hd : ClusterProfile.hw.values()) {
                QueueProfile[] qp = cp.getQueues(hd);
                for (int i = 0; i < qp.length; ++i) {
                    cq.add(qp[i]);
                }
                totalq += qp.length;
            }
            String[] qs = new String[totalq];
            int cnt = 0;
            for (ClusterProfile.hw hd : ClusterProfile.hw.values()) {
                QueueProfile[] qp = cp.getQueues(hd);
                for (int i = 0; i < qp.length; ++i) {
                    qs[cnt] = qp[i].getqueue() + " " + qp[i].gethardware() + " " + qp[i].getlimit();
                    ++cnt;
                }
            }
            gd.addChoice("Queues", qs, qs[0]);
            gd.addChoice("compression", new String[]{""}, new String(""));
        } else {
            gd.addStringField("profile", "");
            gd.addStringField("address", "");
            gd.addChoice("Batch", BatchList.getList(), BatchList.getList()[0]);
            gd.addStringField("run_dir", "");
            gd.addChoice("queues", new String[]{""}, new String(""));
            gd.addChoice("compression", new String[]{""}, new String(""));
        }
        final Vector cc = gd.getChoices();
        Button optionButton = new Button("Add");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 4;
        c.anchor = 13;
        gd.add((Component)optionButton, (Object)c);
        optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericDialog gd = new GenericDialog("Set queue");
                gd.addStringField("name", "");
                gd.addNumericField("limit", 0.0, 2);
                gd.addStringField("hardware", "CPU");
                gd.showDialog();
                if (gd.wasOKed()) {
                    QueueProfile q = new QueueProfile();
                    q.setqueue(gd.getNextString());
                    q.setlimit(gd.getNextNumber());
                    q.sethardware(gd.getNextString());
                    cq.add(q);
                    ((Choice)cc.get(1)).removeAll();
                    for (int i = 0; i < cq.size(); ++i) {
                        ((Choice)cc.get(1)).add(((QueueProfile)cq.get(i)).getqueue() + " " + ((QueueProfile)cq.get(i)).gethardware() + " " + ((QueueProfile)cq.get(i)).getlimit());
                    }
                    ((Choice)cc.get(1)).select(0);
                }
            }
        });
        optionButton = new Button("Edit");
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 4;
        c.anchor = 13;
        gd.add((Component)optionButton, (Object)c);
        optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int id = ((Choice)cc.get(1)).getSelectedIndex();
                QueueProfile q = (QueueProfile)cq.get(id);
                GenericDialog gd = new GenericDialog("Set queue");
                gd.addStringField("name", q.getqueue());
                gd.addNumericField("limit", q.getlimit(), 2);
                gd.addStringField("hardware", q.gethardware());
                gd.showDialog();
                if (gd.wasOKed()) {
                    q.setqueue(gd.getNextString());
                    q.setlimit(gd.getNextNumber());
                    q.sethardware(gd.getNextString());
                    cq.set(id, q);
                    ((Choice)cc.get(1)).removeAll();
                    for (int i = 0; i < cq.size(); ++i) {
                        ((Choice)cc.get(1)).add(((QueueProfile)cq.get(i)).getqueue() + " " + ((QueueProfile)cq.get(i)).gethardware() + " " + ((QueueProfile)cq.get(i)).getlimit());
                    }
                    ((Choice)cc.get(1)).select(0);
                }
            }
        });
        optionButton = new Button("Delete");
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 4;
        c.anchor = 13;
        gd.add((Component)optionButton, (Object)c);
        optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int id = ((Choice)cc.get(1)).getSelectedIndex();
                cq.remove(id);
                ((Choice)cc.get(1)).removeAll();
                for (int i = 0; i < cq.size(); ++i) {
                    ((Choice)cc.get(1)).add(((QueueProfile)cq.get(i)).getqueue() + " " + ((QueueProfile)cq.get(i)).gethardware() + " " + ((QueueProfile)cq.get(i)).getlimit());
                }
                ((Choice)cc.get(1)).select(0);
            }
        });
        optionButton = new Button("Add");
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 5;
        c.anchor = 13;
        gd.add((Component)optionButton, (Object)c);
        optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericDialog gd = new GenericDialog("Compression");
                DataCompression dc = new DataCompression();
                Vector<DataCompression.Algorithm> cl = dc.getCompressorList();
                String[] compressors = new String[cl.size()];
                for (int i = 0; i < cl.size(); ++i) {
                    compressors[i] = cl.get((int)i).name;
                }
                gd.addChoice("Compression", compressors, compressors[0]);
                gd.showDialog();
                if (gd.wasOKed()) {
                    String cmp = gd.getNextChoice();
                    NewClusterProfile.this.fcp.setCompressorString(cmp);
                    ((Choice)cc.get(2)).removeAll();
                    for (int i = 0; i < cl.size(); ++i) {
                        if (!NewClusterProfile.this.fcp.isActiveCompressorString(cl.get((int)i).name)) continue;
                        ((Choice)cc.get(2)).add(cl.get((int)i).name);
                    }
                }
            }
        });
        optionButton = new Button("Delete");
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 5;
        c.anchor = 13;
        gd.add((Component)optionButton, (Object)c);
        optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataCompression dc = new DataCompression();
                Vector<DataCompression.Algorithm> cl = dc.getCompressorList();
                NewClusterProfile.this.fcp.removeCompressorString(((Choice)cc.get(2)).getSelectedItem());
                ((Choice)cc.get(2)).removeAll();
                for (int i = 0; i < cl.size(); ++i) {
                    if (!NewClusterProfile.this.fcp.isActiveCompressorString(cl.get((int)i).name)) continue;
                    ((Choice)cc.get(2)).add(cl.get((int)i).name);
                }
            }
        });
        gd.showDialog();
        if (gd.wasOKed()) {
            this.fcp.setProfileName(gd.getNextString());
            this.fcp.setAccessAddress(gd.getNextString());
            this.fcp.setRunningDir(gd.getNextString());
            this.fcp.setBatchSystemString(gd.getNextChoice());
            for (int i = 0; i < cq.size(); ++i) {
                this.fcp.setAcc(ClusterProfile.hw.valueOf(((QueueProfile)cq.get(i)).gethardware()));
                this.fcp.setQueue(((QueueProfile)cq.get(i)).getlimit(), ((QueueProfile)cq.get(i)).getqueue());
            }
            ClusterGUI.createClusterProfileDir();
            String dir = ClusterGUI.getClusterProfileDir() + File.separator + this.fcp.getProfileName() + ".csv";
            this.fcp.writeConfigFile(new File(dir));
        }
        ClusterProfile[] cpA = ClusterGUI.getClusterProfiles();
        this.cpa.removeAll();
        for (int i = 0; i < cpA.length; ++i) {
            this.cpa.add(cpA[i].getProfileName());
        }
    }

    public int setup(String arg0, ImagePlus arg1) {
        GenericDialog gd = new GenericDialog("New/edit cluster profile");
        final ClusterProfile[] cp = ClusterGUI.getClusterProfiles();
        String[] cp_names = new String[cp.length];
        for (int i = 0; i < cp.length; ++i) {
            cp_names[i] = cp[i].getProfileName();
        }
        if (cp_names.length != 0) {
            gd.addChoice("Cluster profiles", cp_names, cp_names[0]);
        } else {
            gd.addChoice("Cluster profiles", new String[]{""}, "");
        }
        this.cpa = (Choice)gd.getChoices().get(0);
        Button optionButton = new Button("New");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 13;
        gd.add((Component)optionButton, (Object)c);
        optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewClusterProfile.this.popupClusterProfile(null);
            }
        });
        optionButton = new Button("Edit");
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 0;
        c.anchor = 13;
        gd.add((Component)optionButton, (Object)c);
        optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int id = NewClusterProfile.this.cpa.getSelectedIndex();
                NewClusterProfile.this.popupClusterProfile(cp[id]);
            }
        });
        gd.showDialog();
        return 4096;
    }
}

