/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.macro.Interpreter;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.GraphicsEnvironment;
import mosaic.core.imageUtils.images.IntensityImage;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.core.utils.MosaicUtils;
import mosaic.regions.GUI.Controller;
import mosaic.regions.GUI.GuiRC;
import mosaic.regions.GUI.SegmentationProcessWindow;
import mosaic.regions.GUI.StatisticsTable;
import mosaic.regions.RC.AlgorithmRC;
import mosaic.regions.RC.ClusterModeRC;
import mosaic.regions.RC.PluginSettingsRC;
import mosaic.regions.RC.SettingsRC;
import mosaic.regions.RegionsUtils;
import mosaic.regions.energies.ImageModel;
import mosaic.utils.Debug;
import mosaic.utils.ImgUtils;
import mosaic.utils.SysOps;
import mosaic.utils.io.serialize.DataFile;
import mosaic.utils.io.serialize.JsonDataFile;
import org.apache.log4j.Logger;

public class RegionCompetition
implements PlugInFilter {
    private static final Logger logger = Logger.getLogger(RegionCompetition.class);
    private static final String[] iOutputFileNamesSuffixes = new String[]{"*_ObjectsData_c1.csv", "*_seg_c1.tif"};
    private PluginSettingsRC iSettings = null;
    private boolean iNormalizeInputImg = true;
    private boolean iShowGui = true;
    private boolean iUseCluster = false;
    private boolean iShowAndSaveStatistics;
    private boolean iShowAllSteps;
    private int iPadSize = 1;
    private String iOutputSegmentedImageLabelFilename = null;
    private ImagePlus iInputImageChosenByUser;
    private ImagePlus iInputLabelImageChosenByUser;
    private GuiRC iUserGui;
    private LabelImage iLabelImage;
    private SegmentationProcessWindow iLabelImageStack;

    public int setup(String arg, ImagePlus originalInputImage) {
        logger.info((Object)"Starting RegionCompetition");
        this.initSettingsAndParseMacroOptions();
        this.iUserGui = new GuiRC(this.iSettings, originalInputImage);
        this.iUserGui.showDialog();
        if (!this.iUserGui.configurationValid()) {
            return 4096;
        }
        this.iShowGui = !IJ.isMacro() && !Interpreter.batchMode;
        this.iShowAndSaveStatistics = this.iUserGui.showAndSaveStatistics();
        this.iShowAllSteps = this.iUserGui.showAllFrames();
        this.iInputLabelImageChosenByUser = this.iUserGui.getInputLabelImage();
        this.iInputImageChosenByUser = this.iUserGui.getInputImage();
        this.iUseCluster = this.iUserGui.useCluster();
        this.iNormalizeInputImg = this.iUserGui.getNormalize();
        logger.info((Object)("Input image [" + (this.iInputImageChosenByUser != null ? this.iInputImageChosenByUser.getTitle() : "<no file>") + "]"));
        if (this.iInputImageChosenByUser != null) {
            logger.info((Object)ImgUtils.getImageInfo(this.iInputImageChosenByUser));
        }
        logger.info((Object)("Label image [" + (this.iInputLabelImageChosenByUser != null ? this.iInputLabelImageChosenByUser.getTitle() : "<no file>") + "]"));
        logger.info((Object)("showAndSaveStatistics: " + this.iShowAndSaveStatistics + ", showAllFrames: " + this.iShowAllSteps + ", useCluster: " + this.iUseCluster + ", showGui: " + this.iShowGui + ", normalize: " + this.iNormalizeInputImg));
        logger.debug((Object)("Settings:\n" + Debug.getJsonString(this.iSettings)));
        RegionCompetition.getConfigHandler().SaveToFile(this.configFilePath(), this.iSettings);
        return this.iInputImageChosenByUser != null && originalInputImage == null ? 512 : 159;
    }

    public void run(ImageProcessor aIp) {
        if (this.iUseCluster) {
            ClusterModeRC.runClusterMode(this.iInputImageChosenByUser, this.iInputLabelImageChosenByUser, this.iSettings, iOutputFileNamesSuffixes);
            return;
        }
        this.runSegmentation();
        this.saveSegmentedImage();
    }

    private void initSettingsAndParseMacroOptions() {
        this.iSettings = null;
        String options = Macro.getOptions();
        logger.info((Object)("Macro Options: [" + options + "]"));
        if (options != null) {
            String path;
            String normalizeString = MosaicUtils.parseString("normalize", options);
            if (normalizeString != null) {
                this.iNormalizeInputImg = Boolean.parseBoolean(normalizeString);
            }
            if ((path = MosaicUtils.parseString("config", options)) != null) {
                this.iSettings = RegionCompetition.getConfigHandler().LoadFromFile(path, PluginSettingsRC.class);
            }
            this.iOutputSegmentedImageLabelFilename = MosaicUtils.parseString("output", options);
        }
        if (this.iSettings == null) {
            this.iSettings = RegionCompetition.getConfigHandler().LoadFromFile(this.configFilePath(), PluginSettingsRC.class, new PluginSettingsRC());
        }
    }

    private void initStack() {
        int width = this.iLabelImage.getWidth();
        int height = this.iLabelImage.getHeight();
        this.iLabelImageStack = new SegmentationProcessWindow(width, height, this.iShowAllSteps);
        this.iLabelImageStack.setImageTitle("Stack_" + (this.iInputImageChosenByUser.getTitle() == null ? "DRS" : this.iInputImageChosenByUser.getTitle()));
        this.iLabelImageStack.addSliceToStack(this.iLabelImage, "init without contours", 0, true);
        this.iLabelImage.initBorder();
        this.iLabelImageStack.addSliceToStack(this.iLabelImage, "init with contours", 0, true);
    }

    private void saveStatistics(AlgorithmRC algorithm) {
        String absoluteFileNameNoExt;
        algorithm.calculateRegionsCenterOfMass();
        StatisticsTable statisticsTable = new StatisticsTable(algorithm.getLabelStatistics().values(), this.iPadSize);
        if (this.iShowGui || IJ.isMacro()) {
            statisticsTable.show("statistics");
        }
        if ((absoluteFileNameNoExt = ImgUtils.getImageAbsolutePath(this.iInputImageChosenByUser, true)) == null) {
            logger.error((Object)"Cannot save segmentation statistics. Filename for saving not available!");
            return;
        }
        String absoluteFileName = absoluteFileNameNoExt + iOutputFileNamesSuffixes[0].replace("*", "");
        logger.info((Object)("Saving segmentation statistics [" + absoluteFileName + "]"));
        statisticsTable.save(absoluteFileName);
    }

    public static DataFile<PluginSettingsRC> getConfigHandler() {
        return new JsonDataFile<PluginSettingsRC>();
    }

    private String configFilePath() {
        return SysOps.getTmpPath() + "rc_settings.dat";
    }

    private void runSegmentation() {
        IntensityImage intensityImage = RegionsUtils.initInputImage(this.iInputImageChosenByUser, this.iNormalizeInputImg, this.iPadSize);
        this.iLabelImage = RegionsUtils.initLabelImage(intensityImage, this.iInputImageChosenByUser, this.iInputLabelImageChosenByUser, this.iPadSize, this.iSettings.initType, this.iSettings.initBoxRatio, this.iSettings.initBubblesRadius, this.iSettings.initBubblesDisplacement, this.iSettings.initLocalMaxGaussBlurSigma, this.iSettings.initLocalMaxTolerance, this.iSettings.initLocalMaxBubblesRadius, this.iSettings.initLocalMaxMinimumRegionSize);
        ImageModel imageModel = RegionsUtils.initEnergies(intensityImage, this.iLabelImage, this.iInputImageChosenByUser.getCalibration(), this.iSettings.energyFunctional, this.iSettings.energyRegionMergingThreshold, this.iSettings.energyPsGaussEnergyRadius, this.iSettings.energyPsBalloonForceCoeff, this.iSettings.regularizationType, this.iSettings.energyCurvatureMaskRadius, this.iSettings.energyContourLengthCoeff);
        this.initStack();
        Controller iController = new Controller(this.iShowGui);
        SettingsRC rcSettings = new SettingsRC(this.iSettings.allowFusion, this.iSettings.allowFission, this.iSettings.allowHandles, this.iSettings.maxNumOfIterations, this.iSettings.oscillationThreshold, this.iSettings.energyFunctional == RegionsUtils.EnergyFunctionalType.e_DeconvolutionPC);
        AlgorithmRC algorithm = new AlgorithmRC(intensityImage, this.iLabelImage, imageModel, rcSettings);
        boolean isDone = false;
        int iteration = 0;
        while (iteration < this.iSettings.maxNumOfIterations && !isDone) {
            IJ.showStatus((String)("Iteration: " + ++iteration + "/" + this.iSettings.maxNumOfIterations));
            IJ.showProgress((int)iteration, (int)this.iSettings.maxNumOfIterations);
            isDone = algorithm.performIteration();
            isDone = iController.hasAborted() ? true : isDone;
            this.iLabelImageStack.addSliceToStack(this.iLabelImage, "iteration " + iteration, algorithm.getBiggestLabel(), true);
        }
        IJ.showProgress((int)this.iSettings.maxNumOfIterations, (int)this.iSettings.maxNumOfIterations);
        this.iLabelImageStack.addSliceToStack(this.iLabelImage, "final image iteration " + iteration, algorithm.getBiggestLabel(), true);
        ImagePlus show = this.iLabelImage.show("LabelRC");
        show.setStack(ImgUtils.crop(show.getStack(), this.iPadSize, this.iLabelImage.getNumOfDimensions() > 2));
        iController.close();
        if (this.iShowAndSaveStatistics) {
            this.saveStatistics(algorithm);
        }
    }

    private void saveSegmentedImage() {
        String absoluteFileNameNoExt = ImgUtils.getImageAbsolutePath(this.iInputImageChosenByUser, true);
        logger.debug((Object)("Absolute file name with dir: " + absoluteFileNameNoExt));
        if (this.iOutputSegmentedImageLabelFilename == null && absoluteFileNameNoExt != null) {
            this.iOutputSegmentedImageLabelFilename = absoluteFileNameNoExt + iOutputFileNamesSuffixes[1].replace("*", "");
        }
        if (this.iOutputSegmentedImageLabelFilename != null) {
            logger.info((Object)("Saving segmented image [" + this.iOutputSegmentedImageLabelFilename + "]"));
            ImagePlus outImg = this.iLabelImage.convertToImg("ResultWindow");
            outImg.setStack(ImgUtils.crop(outImg.getStack(), this.iPadSize, this.iLabelImage.getNumOfDimensions() > 2));
            IJ.save((ImagePlus)outImg, (String)this.iOutputSegmentedImageLabelFilename);
        } else {
            logger.error((Object)"Cannot save segmentation result. Filename for saving not available!");
        }
        if (!GraphicsEnvironment.isHeadless()) {
            String directory = ImgUtils.getImageDirectory(this.iInputImageChosenByUser);
            String fileNameNoExt = SysOps.removeExtension(this.iInputImageChosenByUser.getTitle());
            MosaicUtils.reorganize(iOutputFileNamesSuffixes, fileNameNoExt, directory, 1);
        }
    }

    public static void main(String[] args) {
        Class<RegionCompetition> clazz = RegionCompetition.class;
        String url = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class").toString();
        String pluginsDir = url.substring("file:".length(), url.length() - clazz.getName().length() - ".class".length());
        System.setProperty("plugins.dir", pluginsDir);
        new ImageJ();
        IJ.runPlugIn((String)clazz.getName(), (String)"");
    }
}

