/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;
import java.util.Vector;
import mosaic.core.detection.FeaturePointDetector;
import mosaic.core.detection.GUIhelper;
import mosaic.core.detection.MyFrame;
import mosaic.core.detection.Particle;
import mosaic.core.utils.MosaicUtils;
import mosaic.utils.ImgUtils;
import mosaic.utils.io.csv.CSV;
import mosaic.utils.io.csv.CsvColumnConfig;

public class Spot_detection
implements PlugInFilter {
    ImagePlus iOriginalImp;
    FeaturePointDetector iDetector;

    public void run(ImageProcessor aArgs) {
        int numOfSlices = this.iOriginalImp.getNSlices();
        int numOfFrames = this.iOriginalImp.getNFrames();
        MyFrame[] frames = new MyFrame[numOfFrames];
        for (int frameIdx = 0; frameIdx < numOfFrames; ++frameIdx) {
            ImageStack subStack = MosaicUtils.getSubStackInFloat(this.iOriginalImp.getStack(), frameIdx * numOfSlices + 1, (frameIdx + 1) * numOfSlices, false);
            MyFrame frame = new MyFrame(frameIdx);
            IJ.showStatus((String)("Detecting Particles in Frame " + (frameIdx + 1) + "/" + numOfFrames));
            Vector<Particle> detectedParticles = this.iDetector.featurePointDetection(subStack);
            frame.setParticles(detectedParticles);
            frames[frame.iFrameNumber] = frame;
        }
        Vector<Particle> particles = new Vector<Particle>();
        for (int i = 0; i < numOfFrames; ++i) {
            int currentFrameFromIdx = particles.size();
            particles.addAll(frames[i].getParticles());
            int currentFrameToIdx = particles.size();
            for (int j = currentFrameFromIdx; j < currentFrameToIdx; ++j) {
                ((Particle)particles.get((int)j)).m0 = this.iDetector.getRadius();
            }
        }
        String dir = ImgUtils.getImageDirectory(this.iOriginalImp);
        if (dir == null) {
            dir = IJ.getDirectory((String)"Choose output directory for CSV file");
        }
        CsvColumnConfig columnConfig = new CsvColumnConfig(Particle.ParticleDetection_map, Particle.ParticleDetectionCellProcessor);
        CSV<Particle> csv = new CSV<Particle>(Particle.class);
        csv.Write(dir + this.iOriginalImp.getTitle() + "det.csv", particles, columnConfig, false);
    }

    public int setup(String aArgs, ImagePlus aInputImp) {
        if (aInputImp == null) {
            IJ.error((String)"There is no image");
            return 4096;
        }
        this.iOriginalImp = aInputImp;
        StackStatistics stack_stats = new StackStatistics(this.iOriginalImp);
        float global_max = (float)stack_stats.max;
        float global_min = (float)stack_stats.min;
        this.iDetector = new FeaturePointDetector(global_max, global_min);
        GenericDialog gd = new GenericDialog("Spot detection...");
        GUIhelper.addUserDefinedParametersDialog(gd, this.iDetector);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        GUIhelper.getUserDefinedParameters(gd, this.iDetector);
        return 31;
    }
}

