/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins.utils;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import mosaic.plugins.utils.PlugInBase;

public abstract class PlugIn8bitBase
extends PlugInBase {
    private int iFlags = 98353;
    protected static final int CHANNEL_R = 0;
    protected static final int CHANNEL_G = 1;
    protected static final int CHANNEL_B = 2;
    protected static final int CHANNEL_8G = 3;

    protected abstract void processImg(ByteProcessor var1, ByteProcessor var2, int var3);

    @Override
    protected int getFlags() {
        return this.iFlags;
    }

    @Override
    protected void updateFlags(int aFlag) {
        this.iFlags |= aFlag;
    }

    public void run(ImageProcessor aIp) {
        IJ.showStatus((String)"In progress...");
        if (aIp instanceof ColorProcessor) {
            int i;
            int noOfChannels = aIp.getNChannels();
            ArrayList<Thread> th = new ArrayList<Thread>(noOfChannels);
            ArrayList<ProcessOneChannel> poc = new ArrayList<ProcessOneChannel>(noOfChannels);
            for (i = 0; i < noOfChannels; ++i) {
                ColorProcessor processedProcessor = null;
                ByteProcessor result = null;
                int channelNumber = i + 1;
                if (this.iResultOutput != PlugInBase.ResultOutput.NONE) {
                    processedProcessor = (ColorProcessor)this.iProcessedImg.getStack().getProcessor(aIp.getSliceNumber());
                    result = processedProcessor.getChannel(channelNumber, null);
                }
                ByteProcessor original = ((ColorProcessor)aIp).getChannel(channelNumber, null);
                original.setSliceNumber(aIp.getSliceNumber());
                ProcessOneChannel p = new ProcessOneChannel(processedProcessor, result, original, channelNumber);
                Thread t = new Thread(p);
                t.start();
                th.add(t);
                poc.add(p);
            }
            for (i = 0; i < noOfChannels; ++i) {
                try {
                    ((Thread)th.get(i)).join();
                    ((ProcessOneChannel)poc.get(i)).update();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } else if (aIp instanceof ByteProcessor) {
            int slice = aIp.getSliceNumber();
            ByteProcessor res = (ByteProcessor)this.iProcessedImg.getStack().getProcessor(slice);
            ByteProcessor orig = (ByteProcessor)aIp;
            orig.setSliceNumber(aIp.getSliceNumber());
            this.processImg(res, orig, 3);
            this.iProcessedImg.setSlice(slice);
            this.iProcessedImg.getProcessor().setPixels(res.getPixels());
        } else {
            throw new RuntimeException("This image type cannot be processed!");
        }
        IJ.showStatus((String)"Done.");
    }

    private class ProcessOneChannel
    implements Runnable {
        int channelNumber;
        ColorProcessor processedProcessor;
        ByteProcessor result;
        ByteProcessor original;

        ProcessOneChannel(ColorProcessor aProcessedProcessor, ByteProcessor aResult, ByteProcessor aOriginal, int aChannelNumber) {
            this.channelNumber = aChannelNumber;
            this.processedProcessor = aProcessedProcessor;
            this.result = aResult;
            this.original = aOriginal;
        }

        @Override
        public void run() {
            PlugIn8bitBase.this.processImg(this.result, this.original, this.channelNumber - 1);
        }

        public void update() {
            if (PlugIn8bitBase.this.iResultOutput != PlugInBase.ResultOutput.NONE) {
                this.processedProcessor.setChannel(this.channelNumber, this.result);
            }
        }
    }
}

