/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins.utils;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import mosaic.utils.ImgUtils;

abstract class PlugInBase
implements ExtendedPlugInFilter {
    protected ImagePlus iInputImg;
    protected ImagePlus iProcessedImg;
    private String iInputArgs;
    private String iFilePrefix = "processed_";
    private double iScaleX = 1.0;
    private double iScaleY = 1.0;
    ResultOutput iResultOutput = ResultOutput.GENERATE_NEW;

    PlugInBase() {
    }

    protected abstract boolean setup(String var1);

    protected abstract boolean showDialog();

    protected abstract int getFlags();

    protected abstract void updateFlags(int var1);

    protected void postprocessBeforeShow() {
    }

    protected void postprocessFinal() {
    }

    public final int setup(String aArgs, ImagePlus aImp) {
        if (aImp == null) {
            IJ.noImage();
            return 4096;
        }
        if (aArgs.equals("final")) {
            this.postprocessBeforeShow();
            this.iProcessedImg.setSlice(1);
            this.iProcessedImg.show();
            this.postprocessFinal();
        } else {
            this.iInputImg = aImp;
            this.iInputArgs = aArgs;
            if (!this.setup(this.iInputArgs)) {
                return 4096;
            }
            if (this.iResultOutput == ResultOutput.UPDATE_ORIGINAL) {
                this.iProcessedImg = this.iInputImg;
            } else if (this.iResultOutput == ResultOutput.GENERATE_NEW) {
                this.iProcessedImg = ImgUtils.createNewEmptyImgPlus(this.iInputImg, this.iFilePrefix + this.iInputImg.getTitle(), this.iScaleX, this.iScaleY, ImgUtils.OutputType.ORIGINAL);
                this.updateFlags(128);
            } else {
                this.updateFlags(128);
            }
        }
        return this.getFlags();
    }

    public final void setNPasses(int arg0) {
    }

    public final int showDialog(ImagePlus arg0, String arg1, PlugInFilterRunner arg2) {
        if (!this.showDialog()) {
            return 4096;
        }
        return this.getFlags();
    }

    protected void setScaleX(double aScaleX) {
        this.iScaleX = aScaleX;
    }

    protected void setScaleY(double aScaleY) {
        this.iScaleY = aScaleY;
    }

    protected void setResultDestination(ResultOutput aResultOutput) {
        this.iResultOutput = aResultOutput;
    }

    protected void setFilePrefix(String aFilePrefix) {
        this.iFilePrefix = aFilePrefix;
    }

    protected static enum ResultOutput {
        UPDATE_ORIGINAL,
        GENERATE_NEW,
        NEW_BY_PLUGIN,
        NONE;

    }
}

