/*
 * Decompiled with CFR 0.152.
 */
package mosaic.psf2d;

import ij.plugin.filter.Convolver;
import ij.process.ImageProcessor;
import mosaic.psf2d.PsfSourcePosition;

public class PsfRefinement {
    private final int radius;
    private int[] mask;
    private final int lambda_n = 1;
    private float[] kernel;
    private final PsfSourcePosition particle;
    private final ImageProcessor original_ip;
    private ImageProcessor original_fp;
    private ImageProcessor restored_fp;

    public PsfRefinement(ImageProcessor ip, int rad, PsfSourcePosition pat) {
        this.radius = rad;
        this.original_ip = ip;
        this.particle = pat;
        this.makeKernel(this.radius);
        this.generateMask(this.radius);
    }

    public void refineParticlePosition() {
        this.original_fp = this.original_ip.convertToFloat();
        this.restored_fp = this.imageRestoration(this.original_fp);
        this.pointLocationsRefinement(this.restored_fp);
    }

    private ImageProcessor imageRestoration(ImageProcessor ip) {
        ImageProcessor restored = ip.duplicate();
        int kernel_radius = this.radius;
        int kernel_width = kernel_radius * 2 + 1;
        Convolver convolver = new Convolver();
        convolver.setNormalize(false);
        convolver.convolve(restored, this.kernel, kernel_width, kernel_width);
        return restored;
    }

    private void pointLocationsRefinement(ImageProcessor ip) {
        int mask_width = 2 * this.radius + 1;
        for (int i = 0; i < ip.getHeight(); ++i) {
            for (int j = 0; j < ip.getWidth(); ++j) {
                if (!((double)ip.getPixelValue(j, i) < 0.0)) continue;
                ip.putPixelValue(j, i, 0.0);
            }
        }
        float epsy = 1.0f;
        float epsx = 1.0f;
        while ((double)epsy > 0.5 || (double)epsy < -0.5 || (double)epsx > 0.5 || (double)epsx < -0.5) {
            float m0 = 0.0f;
            epsx = 0.0f;
            epsy = 0.0f;
            for (int k = -this.radius; k <= this.radius; ++k) {
                if ((int)this.particle.iY + k < 0 || (int)this.particle.iY + k >= ip.getHeight()) continue;
                int y = (int)this.particle.iY + k;
                for (int l = -this.radius; l <= this.radius; ++l) {
                    if ((int)this.particle.iX + l < 0 || (int)this.particle.iX + l >= ip.getWidth()) continue;
                    int x = (int)this.particle.iX + l;
                    float c = ip.getPixelValue(x, y) * (float)this.mask[this.coord(k + this.radius, l + this.radius, mask_width)];
                    m0 += c;
                    epsy += (float)k * c;
                    epsx += (float)l * c;
                }
            }
            epsy /= m0;
            int tx = (int)(10.0 * (double)(epsx /= m0));
            int ty = (int)(10.0 * (double)epsy);
            if ((double)ty / 10.0 > 0.5) {
                if ((int)this.particle.iY + 1 < ip.getHeight()) {
                    this.particle.iY += 1.0f;
                }
            } else if ((double)ty / 10.0 < -0.5 && (int)this.particle.iY - 1 >= 0) {
                this.particle.iY -= 1.0f;
            }
            if ((double)tx / 10.0 > 0.5) {
                if ((int)this.particle.iX + 1 < ip.getWidth()) {
                    this.particle.iX += 1.0f;
                }
            } else if ((double)tx / 10.0 < -0.5 && (int)this.particle.iX - 1 >= 0) {
                this.particle.iX -= 1.0f;
            }
            if (!((double)ty / 10.0 <= 0.5) || !((double)ty / 10.0 >= -0.5) || !((double)tx / 10.0 <= 0.5) || !((double)tx / 10.0 >= -0.5)) continue;
            break;
        }
        this.particle.iX += epsx;
        this.particle.iY += epsy;
    }

    private void generateMask(int mask_radius) {
        int width = 2 * mask_radius + 1;
        this.mask = new int[width * width];
        for (int i = -mask_radius; i <= mask_radius; ++i) {
            for (int j = -mask_radius; j <= mask_radius; ++j) {
                int index = this.coord(i + mask_radius, j + mask_radius, width);
                this.mask[index] = i * i + j * j <= mask_radius * mask_radius ? 1 : 0;
            }
        }
    }

    private void makeKernel(int kernel_radius) {
        int kernel_width = kernel_radius * 2 + 1;
        this.kernel = new float[kernel_width * kernel_width];
        double b = this.calculateB(kernel_radius, 1);
        double norm_cons = this.calculateNormalizationConstant(b, kernel_radius, 1);
        for (int i = -kernel_radius; i <= kernel_radius; ++i) {
            for (int j = -kernel_radius; j <= kernel_radius; ++j) {
                int index = (i + kernel_radius) * kernel_width + j + kernel_radius;
                this.kernel[index] = (float)(1.0 / b * Math.exp(-((double)(i * i + j * j) / 4.0)));
                this.kernel[index] = this.kernel[index] - (float)(1.0 / (double)(kernel_width * kernel_width));
                this.kernel[index] = (float)((double)this.kernel[index] / norm_cons);
            }
        }
    }

    private double calculateB(int kernel_radius, int lambda) {
        double b = 0.0;
        for (int i = -kernel_radius; i <= kernel_radius; ++i) {
            b += Math.exp(-((double)(i * i) / (4.0 * (double)(lambda * lambda))));
        }
        b *= b;
        return b;
    }

    private double calculateNormalizationConstant(double b, int kernel_radius, int lambda) {
        double constant = 0.0;
        int kernel_width = kernel_radius * 2 + 1;
        for (int i = -kernel_radius; i <= kernel_radius; ++i) {
            constant += Math.exp(-((double)(i * i) / (2.0 * (double)(lambda * lambda))));
        }
        constant = constant * constant / b - b / (double)(kernel_width * kernel_width);
        return constant;
    }

    private int coord(int a, int b, int c) {
        return a * c + b;
    }

    public PsfSourcePosition getRefinedParticle() {
        return this.particle;
    }
}

