/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.GUI;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import mosaic.regions.GUI.Controller;

public class ControllerWindow
extends JFrame {
    private static final long serialVersionUID = -2978938221002810146L;
    protected final Controller iController;

    public ControllerWindow(final Controller aController) {
        this.iController = aController;
        this.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        panel.add(this.addPauseResumeButton());
        panel.add(this.addStopButton());
        this.add(panel);
        this.pack();
        this.setLocationByPlatform(true);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                aController.stop();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                aController.stop();
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
    }

    private JButton addStopButton() {
        JButton stopButton = new JButton("Stop");
        stopButton.setToolTipText("Stops algorithm after current iteration");
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControllerWindow.this.iController.stop();
                ControllerWindow.this.dispose();
            }
        });
        return stopButton;
    }

    private JButton addPauseResumeButton() {
        final JButton resumeButton = new JButton("Pause");
        resumeButton.setToolTipText("Pauses/Resumes algorithm after current iteration");
        resumeButton.addActionListener(new ActionListener(){
            private boolean isPaused = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!this.isPaused) {
                    this.isPaused = true;
                    resumeButton.setText("Resume");
                    ControllerWindow.this.iController.pause();
                } else {
                    this.isPaused = false;
                    resumeButton.setText("Pause");
                    ControllerWindow.this.iController.resume();
                }
                ControllerWindow.this.pack();
                ControllerWindow.this.validate();
            }
        });
        return resumeButton;
    }
}

