/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.GUI;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import mosaic.regions.DRS.PluginSettingsDRS;
import mosaic.regions.GUI.GuiDrsBase;
import mosaic.regions.RegionsUtils;
import mosaic.utils.ImgUtils;
import org.apache.log4j.Logger;

public class GuiDrs
extends GuiDrsBase {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(GuiDrs.class);
    static final ArrayList<RegionsUtils.EnergyFunctionalType> EnergyTypes = new ArrayList<RegionsUtils.EnergyFunctionalType>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(RegionsUtils.EnergyFunctionalType.e_PC_Gauss);
            this.add(RegionsUtils.EnergyFunctionalType.e_PC);
            this.add(RegionsUtils.EnergyFunctionalType.e_PS);
        }
    };
    final PluginSettingsDRS iSettings;
    final ImagePlus iImage;
    boolean iOkPressed = false;
    final Object iBlockingLock = new Object();

    private GuiDrs() {
        this(new PluginSettingsDRS(), null);
    }

    public static void main(String[] args) {
        GuiDrs dd = new GuiDrs();
        dd.showDialog();
    }

    public GuiDrs(PluginSettingsDRS aSettings, ImagePlus aImage) {
        super(EnergyTypes);
        logger.debug((Object)"DRS GUI created");
        this.iSettings = aSettings;
        this.iImage = aImage;
        this.setDefaultCloseOperation(2);
        this.setTitle("Discrete Region Sampling [" + (this.iImage != null ? this.iImage.getTitle() : "<no image provided>") + "]");
        this.pack();
        Dimension d = new Dimension(this.getWidth() * 105 / 100, this.getHeight() * 105 / 100);
        this.getContentPane().setPreferredSize(d);
        this.pack();
        this.setModal(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((dimension.getWidth() - (double)this.getWidth()) / 2.0);
        int y = (int)((dimension.getHeight() - (double)this.getHeight()) / 2.0);
        this.setLocation(x, y);
        this.transferDataToGui();
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent ev) {
                super.windowClosing(ev);
                Object object = GuiDrs.this.iBlockingLock;
                synchronized (object) {
                    GuiDrs.this.iBlockingLock.notify();
                }
            }
        });
    }

    void addFilesToInitFileChooser() {
        int[] ids = WindowManager.getIDList();
        if (ids != null) {
            Object[] names = new String[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                names[i] = WindowManager.getImage((int)ids[i]).getTitle();
            }
            this.fileInitList.setListData(names);
            if (this.iSettings.initFileName != null) {
                int idx = Arrays.binarySearch(names, this.iSettings.initFileName);
                if (idx < 0) {
                    this.iSettings.initFileName = null;
                } else {
                    this.fileInitList.setSelectedIndex(idx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showDialog() {
        this.setVisible(true);
        try {
            Object object = this.iBlockingLock;
            synchronized (object) {
                this.iBlockingLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean wasCanceled() {
        return !this.iOkPressed;
    }

    public boolean wasOKed() {
        return this.iOkPressed;
    }

    @Override
    protected void resetSettings() {
        logger.debug((Object)"Settings reseted.");
        this.iSettings.copy(new PluginSettingsDRS());
        this.transferDataToGui();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ok() {
        logger.debug((Object)"OK clicked");
        if (!this.getDataFromGui()) {
            return;
        }
        this.iOkPressed = true;
        this.dispose();
        Object object = this.iBlockingLock;
        synchronized (object) {
            this.iBlockingLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        logger.debug((Object)"Cancel clicked");
        this.dispose();
        Object object = this.iBlockingLock;
        synchronized (object) {
            this.iBlockingLock.notify();
        }
    }

    private void transferDataToGui() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiDrs.this.dataEnergyCombo.setSelectedIndex(EnergyTypes.indexOf((Object)GuiDrs.this.iSettings.energyFunctional));
                GuiDrs.this.psEenergyRadius.setText("" + GuiDrs.this.iSettings.energyPsGaussEnergyRadius);
                GuiDrs.this.psEnergyBetaBalloon.setText("" + GuiDrs.this.iSettings.energyPsBalloonForceCoeff);
                GuiDrs.this.lengthEnergyCombo.setSelectedIndex(GuiDrs.this.iSettings.regularizationType.ordinal());
                GuiDrs.this.lambdaRegularization.setText("" + GuiDrs.this.iSettings.energyContourLengthCoeff);
                GuiDrs.this.sphereRegularizationRadiusK.setText("" + GuiDrs.this.iSettings.energyCurvatureMaskRadius);
                GuiDrs.this.initializationCombo.setSelectedIndex(GuiDrs.this.iSettings.initType.ordinal());
                GuiDrs.this.rectangleInitBoxFillRatio.setText("" + GuiDrs.this.iSettings.initBoxRatio);
                GuiDrs.this.bubblesInitRadius.setText("" + GuiDrs.this.iSettings.initBubblesRadius);
                GuiDrs.this.bubblesInitPadding.setText("" + GuiDrs.this.iSettings.initBubblesDisplacement);
                GuiDrs.this.localMaxInitRadius.setText("" + GuiDrs.this.iSettings.initLocalMaxBubblesRadius);
                GuiDrs.this.localMaxInitSigma.setText("" + GuiDrs.this.iSettings.initLocalMaxGaussBlurSigma);
                GuiDrs.this.localMaxInitTolerance.setText("" + GuiDrs.this.iSettings.initLocalMaxTolerance);
                GuiDrs.this.localMaxInitMinRegionSize.setText("" + GuiDrs.this.iSettings.initLocalMaxMinimumRegionSize);
                GuiDrs.this.numOfIterations.setText("" + GuiDrs.this.iSettings.maxNumOfIterations);
                GuiDrs.this.chckbxFussion.setSelected(GuiDrs.this.iSettings.allowFusion);
                GuiDrs.this.chckbxFission.setSelected(GuiDrs.this.iSettings.allowFission);
                GuiDrs.this.chckbxHandles.setSelected(GuiDrs.this.iSettings.allowHandles);
                GuiDrs.this.offBoundaryProbability.setText("" + GuiDrs.this.iSettings.offBoundarySampleProbability);
                GuiDrs.this.burnInFactor.setText("" + GuiDrs.this.iSettings.burnInFactor);
                GuiDrs.this.chckbxPairProposal.setSelected(GuiDrs.this.iSettings.usePairProposal);
                GuiDrs.this.chckbxBiasedProposal.setSelected(GuiDrs.this.iSettings.useBiasedProposal);
                GuiDrs.this.chckbxShowLabelImage.setSelected(GuiDrs.this.iSettings.showLabelImage);
                GuiDrs.this.chckbxSaveLabelImage.setSelected(GuiDrs.this.iSettings.saveLabelImage);
                GuiDrs.this.chckbxShowProbabilityImage.setSelected(GuiDrs.this.iSettings.showProbabilityImage);
                GuiDrs.this.chckbxSaveProbabilityImage.setSelected(GuiDrs.this.iSettings.saveProbabilityImage);
                GuiDrs.this.lblStatus.setText("Have a nice day!");
                GuiDrs.this.addFilesToInitFileChooser();
            }
        });
    }

    private boolean getDataFromGui() {
        try {
            String directory;
            this.iSettings.energyFunctional = EnergyTypes.get(this.dataEnergyCombo.getSelectedIndex());
            this.iSettings.energyPsGaussEnergyRadius = (int)this.getValue(this.lblPsEnergyRadius.getText(), this.psEenergyRadius.getText(), 1.0, Double.POSITIVE_INFINITY, true);
            this.iSettings.energyPsBalloonForceCoeff = (float)this.getValue(this.lblPsEnergyBetaEBalloon.getText(), this.psEnergyBetaBalloon.getText(), 0.0, Double.POSITIVE_INFINITY, false);
            this.iSettings.regularizationType = RegionsUtils.RegularizationType.getEnum(this.lengthEnergyCombo.getSelectedItem().toString());
            this.iSettings.energyContourLengthCoeff = (float)this.getValue(this.lblLambdaRegularization.getText(), this.lambdaRegularization.getText(), 0.0, Double.POSITIVE_INFINITY, false);
            this.iSettings.energyCurvatureMaskRadius = (int)this.getValue(this.lblSphereReguralizationRK.getText(), this.sphereRegularizationRadiusK.getText(), 1.0, Double.POSITIVE_INFINITY, true);
            this.iSettings.initType = RegionsUtils.InitializationType.getEnum(this.initializationCombo.getSelectedItem().toString());
            this.iSettings.initBoxRatio = this.getValue(this.lblBoxFillRatio.getText(), this.rectangleInitBoxFillRatio.getText(), 0.0, 1.0, false);
            this.iSettings.initBubblesRadius = (int)this.getValue(this.lblBubbleRadius.getText(), this.bubblesInitRadius.getText(), 1.0, Double.POSITIVE_INFINITY, true);
            this.iSettings.initBubblesDisplacement = (int)this.getValue(this.lblBubblePadding.getText(), this.bubblesInitPadding.getText(), 1.0, Double.POSITIVE_INFINITY, true);
            this.iSettings.initLocalMaxBubblesRadius = (int)this.getValue(this.lblMaxInitRadius.getText(), this.localMaxInitRadius.getText(), 1.0, Double.POSITIVE_INFINITY, true);
            this.iSettings.initLocalMaxGaussBlurSigma = this.getValue(this.lblMaxInitSigma.getText(), this.localMaxInitSigma.getText(), 0.0, Double.POSITIVE_INFINITY, false);
            this.iSettings.initLocalMaxTolerance = this.getValue(this.lblMaxInitTolerance.getText(), this.localMaxInitTolerance.getText(), 0.0, 1.0, false);
            this.iSettings.initLocalMaxMinimumRegionSize = (int)this.getValue(this.lblMaxInitMinimumRegionSize.getText(), this.localMaxInitMinRegionSize.getText(), 1.0, Double.POSITIVE_INFINITY, true);
            this.iSettings.maxNumOfIterations = (int)this.getValue(this.lblNumberOfIterations.getText(), this.numOfIterations.getText(), 1.0, Double.POSITIVE_INFINITY, true);
            this.iSettings.allowFusion = this.chckbxFussion.isSelected();
            this.iSettings.allowFission = this.chckbxFission.isSelected();
            this.iSettings.allowHandles = this.chckbxHandles.isSelected();
            this.iSettings.offBoundarySampleProbability = (float)this.getValue(this.lblOffboundaryProbability.getText(), this.offBoundaryProbability.getText(), 0.0, 1.0, false);
            this.iSettings.burnInFactor = (float)this.getValue(this.lblBurninFactor.getText(), this.burnInFactor.getText(), 0.0, 1.0, false);
            this.iSettings.usePairProposal = this.chckbxPairProposal.isSelected();
            this.iSettings.useBiasedProposal = this.chckbxBiasedProposal.isSelected();
            this.iSettings.showLabelImage = this.chckbxShowLabelImage.isSelected();
            this.iSettings.saveLabelImage = this.chckbxSaveLabelImage.isSelected();
            if (this.iSettings.saveLabelImage && (directory = ImgUtils.getImageDirectory(this.iImage)) == null) {
                throw new IllegalArgumentException("\"" + this.chckbxSaveLabelImage.getText() + "\" - directory for saving is taken from input image, but it is not saved yet");
            }
            this.iSettings.showProbabilityImage = this.chckbxShowProbabilityImage.isSelected();
            this.iSettings.saveProbabilityImage = this.chckbxSaveProbabilityImage.isSelected();
            if (this.iSettings.saveProbabilityImage && (directory = ImgUtils.getImageDirectory(this.iImage)) == null) {
                throw new IllegalArgumentException("\"" + this.chckbxSaveProbabilityImage.getText() + "\" - directory for saving is taken from input image, but it is not saved yet");
            }
            this.checkRoi();
            this.checkFile();
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GuiDrs.this.lblStatus.setText(e.getMessage());
                }
            });
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiDrs.this.lblStatus.setText("Have a nice day!");
            }
        });
        return true;
    }

    private void checkRoi() throws IllegalArgumentException {
        if (this.iSettings.initType == RegionsUtils.InitializationType.ROI_2D) {
            Roi roi = null;
            ImagePlus iChosenInputImage = this.iImage;
            roi = iChosenInputImage.getRoi();
            if (roi == null) {
                iChosenInputImage.show();
                throw new IllegalArgumentException("Please add ROI region(s) to plugin input image (" + iChosenInputImage.getTitle() + ").");
            }
        }
    }

    private void checkFile() throws IllegalArgumentException {
        if (this.iSettings.initType == RegionsUtils.InitializationType.File && this.fileInitList.isSelectionEmpty()) {
            throw new IllegalArgumentException("Please select file with regions for this type of initialization");
        }
    }

    private double getValue(String aFieldName, String aStrValue, double aMinValue, double aMaxValue, boolean aIntExpected) throws IllegalArgumentException {
        double d = this.convertToDouble(aStrValue);
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("Field \"" + aFieldName + "\" has incorrect value [" + aStrValue + "]");
        }
        if (aIntExpected && (d != Math.floor(d) || Double.isInfinite(d))) {
            throw new IllegalArgumentException("Field \"" + aFieldName + "\" should have integer values only but current value is: " + d);
        }
        if (d < aMinValue || d > aMaxValue) {
            String errorStr = "Field \"" + aFieldName + "\" should be ";
            errorStr = Double.isInfinite(aMaxValue) && !Double.isInfinite(aMinValue) ? (aIntExpected ? errorStr + ">=" + (int)aMinValue : errorStr + ">=" + aMinValue) : (!Double.isInfinite(aMaxValue) && Double.isInfinite(aMinValue) ? (aIntExpected ? errorStr + "<=" + (int)aMinValue : errorStr + "<=" + aMinValue) : (aIntExpected ? errorStr + "in " + (int)aMinValue + "-" + (int)aMaxValue + " range" : errorStr + "in " + aMinValue + "-" + aMaxValue + " range"));
            errorStr = aIntExpected ? errorStr + ", but current value is: " + (int)d : errorStr + ", but current value is: " + d;
            throw new IllegalArgumentException(errorStr);
        }
        return d;
    }

    private double convertToDouble(String aValue) {
        try {
            return Double.parseDouble(aValue);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public ImagePlus getInputLabelImage() {
        if (!this.fileInitList.isSelectionEmpty()) {
            this.iSettings.initFileName = (String)this.fileInitList.getSelectedValue();
            return WindowManager.getImage((String)((String)this.fileInitList.getSelectedValue()));
        }
        return null;
    }

    @Override
    protected void updateFileInitList() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiDrs.this.addFilesToInitFileChooser();
            }
        });
    }
}

