/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.GUI;

import ij.measure.ResultsTable;
import java.io.IOException;
import java.util.Collection;
import mosaic.regions.utils.LabelStatistics;

public class StatisticsTable {
    private final int iPadSize;
    private final ResultsTable iResultsTable;

    public StatisticsTable(Collection<LabelStatistics> aLabelInfos, int aPadSize) {
        this.iPadSize = aPadSize;
        this.iResultsTable = this.createStatistics(aLabelInfos);
    }

    public void show(String aNameOfTable) {
        this.iResultsTable.show(aNameOfTable);
    }

    public void save(String aFileName) {
        try {
            this.iResultsTable.saveAs(aFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ResultsTable createStatistics(Collection<LabelStatistics> collection) {
        ResultsTable rt = new ResultsTable();
        rt.showRowNumbers(false);
        for (LabelStatistics info : collection) {
            rt.incrementCounter();
            rt.addValue("Id", (double)rt.getCounter());
            rt.addValue("Image_ID", 0.0);
            rt.addValue("label", (double)info.iLabel);
            rt.addValue("size", (double)info.iLabelCount);
            rt.addValue("mean", info.iMeanIntensity);
            rt.addValue("variance", info.iVarIntensity);
            rt.addValue("Coord_X", info.iMeanPosition[0] - (double)this.iPadSize);
            rt.addValue("Coord_Y", info.iMeanPosition[1] - (double)this.iPadSize);
            rt.addValue("Coord_Z", info.iMeanPosition.length > 2 ? info.iMeanPosition[2] - (double)this.iPadSize : 0.0);
        }
        return rt;
    }
}

