/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.RC;

import ij.ImagePlus;
import ij.io.Opener;
import java.io.File;
import mosaic.core.cluster.ClusterGUI;
import mosaic.core.cluster.ClusterSession;
import mosaic.core.psf.GeneratePSF;
import mosaic.core.utils.MosaicUtils;
import mosaic.plugins.RegionCompetition;
import mosaic.regions.RC.PluginSettingsRC;
import mosaic.regions.RegionsUtils;
import mosaic.utils.Debug;
import mosaic.utils.ImgUtils;
import org.apache.log4j.Logger;

public class ClusterModeRC {
    private static final Logger logger = Logger.getLogger(ClusterModeRC.class);

    public static void runClusterMode(ImagePlus aImp, ImagePlus labelImage, PluginSettingsRC iSettings, String[] out) {
        String labelImageFilename = ImgUtils.getImageAbsolutePath(aImp);
        String inputImageFilename = ImgUtils.getImageAbsolutePath(labelImage);
        Debug.print("CLUSTER", inputImageFilename, labelImageFilename);
        logger.info((Object)"Running RC on cluster");
        RegionCompetition.getConfigHandler().SaveToFile(ClusterSession.DefaultSettingsFileName, iSettings);
        ClusterGUI cg = new ClusterGUI();
        ClusterSession ss = cg.getClusterSession();
        ss.setInputParameterName("text1");
        ss.setSlotPerProcess(1);
        File[] fileslist = null;
        if (aImp == null) {
            File fl = new File(inputImageFilename);
            File fl_l = new File(labelImageFilename);
            if (fl.isDirectory()) {
                String opt = ClusterModeRC.getOptions(fl, iSettings);
                if (iSettings.initType == RegionsUtils.InitializationType.File) {
                    ss = cg.getClusterSession();
                    fileslist = fl_l.listFiles();
                    File dir = new File("label");
                    ss.upload(dir, fileslist);
                    opt = opt + " text2=" + ss.getClusterDirectory() + File.separator + dir.getPath();
                }
                fileslist = fl.listFiles();
                ss = ClusterSession.processFiles(fileslist, "Region Competition", opt + " show_and_save_statistics", out, cg);
            } else if (fl.isFile()) {
                String opt = ClusterModeRC.getOptions(fl, iSettings);
                if (iSettings.initType == RegionsUtils.InitializationType.File) {
                    ss = cg.getClusterSession();
                    fileslist = new File[]{fl_l};
                    ss.upload(fileslist);
                    opt = opt + " text2=" + ss.getClusterDirectory() + File.separator + fl_l.getName();
                }
                ss = ClusterSession.processFile(fl, "Region Competition", opt + " show_and_save_statistics", out, cg);
            } else {
                ss = ClusterSession.getFinishedJob(out, "Region Competition", cg);
            }
        } else {
            String opt = ClusterModeRC.getOptions(aImp, iSettings);
            if (iSettings.initType == RegionsUtils.InitializationType.File) {
                ss = cg.getClusterSession();
                ss.splitAndUpload(labelImage, new File("label"), null);
                opt = opt + " text2=" + ss.getClusterDirectory() + File.separator + "label" + File.separator + ss.getSplitAndUploadFilename(0);
            }
            ss = ClusterSession.processImage(aImp, "Region Competition", opt + " show_and_save_statistics", out, cg);
        }
        File f = ClusterSession.processJobsData(ImgUtils.getImageDirectory(aImp));
        if (aImp != null) {
            MosaicUtils.StitchCSV(ImgUtils.getImageDirectory(aImp), out, ImgUtils.getImageDirectory(aImp) + File.separator + aImp.getTitle());
        } else {
            MosaicUtils.StitchCSV(f.getParent(), out, null);
        }
    }

    private static int getDimension(File f) {
        Opener o = new Opener();
        ImagePlus ip = o.openImage(f.getAbsolutePath());
        return ClusterModeRC.getDimension(ip);
    }

    private static int getDimension(ImagePlus aImp) {
        return aImp.getNSlices() == 1 ? 2 : 3;
    }

    private static String getOptions(File f, PluginSettingsRC aSettings) {
        int d = ClusterModeRC.getDimension(f);
        return ClusterModeRC.generateParameters(d, aSettings);
    }

    private static String getOptions(ImagePlus aImp, PluginSettingsRC aSettings) {
        int d = ClusterModeRC.getDimension(aImp);
        return ClusterModeRC.generateParameters(d, aSettings);
    }

    private static String generateParameters(int aDimension, PluginSettingsRC aSettings) {
        String par = "Dimensions=" + aDimension + " ";
        if (aSettings.energyFunctional == RegionsUtils.EnergyFunctionalType.e_DeconvolutionPC) {
            GeneratePSF psf2 = new GeneratePSF();
            psf2.generate(aDimension);
            par = par + psf2.getParameters();
        }
        return par;
    }
}

