/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.RC;

import java.util.LinkedList;
import java.util.List;
import mosaic.core.imageUtils.Point;

public class ContourParticle {
    public int label = 0;
    public int candidateLabel = 0;
    public float intensity = 0.0f;
    public double energyDifference = Double.MAX_VALUE;
    boolean isMother = false;
    boolean isDaughter = false;
    int referenceCount = 0;
    boolean isProcessed = false;
    private final List<Point> motherList = new LinkedList<Point>();
    private final List<Point> daughterList = new LinkedList<Point>();
    private final List<Integer> testedList = new LinkedList<Integer>();

    public ContourParticle(int aLabel, float aIntensity) {
        this.label = aLabel;
        this.intensity = aIntensity;
    }

    List<Point> getMotherList() {
        return this.motherList;
    }

    void addMother(Point aMother) {
        this.motherList.add(aMother);
    }

    List<Point> getDaughterList() {
        return this.daughterList;
    }

    void addDaughter(Point aDaughter) {
        this.daughterList.add(aDaughter);
    }

    boolean hasLabelBeenTested(int aLabel) {
        return this.testedList.contains(aLabel);
    }

    void setTestedLabel(int aLabel) {
        this.testedList.add(aLabel);
    }

    void clearLists() {
        this.motherList.clear();
        this.daughterList.clear();
        this.testedList.clear();
    }

    public String toString() {
        return "[L=" + this.label + " val=" + this.intensity + " L'=" + this.candidateLabel + "]";
    }
}

