/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.energies;

import ij.measure.Calibration;
import mosaic.core.imageUtils.MaskOnSpaceMapper;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.core.imageUtils.masks.BallMask;

public class CurvatureBasedFlow {
    private final MaskOnSpaceMapper sphereIt;
    private final LabelImage labelImage;
    private final int dim;
    private final int[] inputDims;
    private final float rad;
    private final BallMask sphere;
    private final double vVolume;

    public CurvatureBasedFlow(int rad, LabelImage labelImage, Calibration cal) {
        this.rad = rad;
        this.dim = labelImage.getNumOfDimensions();
        this.inputDims = labelImage.getDimensions();
        this.labelImage = labelImage;
        float[] spacing = null;
        if (cal != null) {
            if (this.dim == 2) {
                spacing = new float[]{(float)cal.pixelWidth, (float)cal.pixelHeight};
                this.sphere = new BallMask(rad, 2 * rad, spacing);
            } else {
                spacing = new float[]{(float)cal.pixelWidth, (float)cal.pixelHeight, (float)cal.pixelDepth};
                this.sphere = new BallMask(rad, 2 * rad, spacing);
            }
        } else {
            this.sphere = new BallMask(rad, this.dim);
        }
        this.sphereIt = new MaskOnSpaceMapper(this.sphere, this.inputDims);
        if (this.dim == 2) {
            this.vVolume = 3.141592f * (float)rad * (float)rad;
        } else if (this.dim == 3) {
            this.vVolume = 4.188789f * (float)rad * (float)rad * (float)rad;
        } else {
            throw new RuntimeException("Curvature flow only implemented for 2D and 3D");
        }
    }

    public double generateData(Point origin, int aFrom, int aTo) {
        int vNto = 0;
        int vNFrom = 0;
        this.sphereIt.setMiddlePoint(origin);
        while (this.sphereIt.hasNext()) {
            int idx = this.sphereIt.next();
            int absLabel = this.labelImage.getLabelAbs(idx);
            if (absLabel == aTo) {
                ++vNto;
                continue;
            }
            if (absLabel != aFrom) continue;
            ++vNFrom;
        }
        double vCurvatureFlow = 0.0;
        if (aFrom == 0) {
            int vN = vNto;
            if (this.dim == 2) {
                vCurvatureFlow -= (double)(9.424776f / this.rad) * ((double)vN / this.vVolume - 0.5);
            } else if (this.dim == 3) {
                vCurvatureFlow -= (double)(16.0f / (3.0f * this.rad)) * ((double)vN / this.vVolume - 0.5);
            }
        } else if (aTo == 0) {
            int vN = vNFrom;
            if (this.dim == 2) {
                vCurvatureFlow += (double)(9.424776f / this.rad) * ((double)vN / this.vVolume - 0.5);
            } else if (this.dim == 3) {
                vCurvatureFlow += (double)(16.0f / (3.0f * this.rad)) * ((double)vN / this.vVolume - 0.5);
            }
        } else if (this.dim == 2) {
            vCurvatureFlow -= (double)(9.424776f / this.rad) * ((double)vNto / this.vVolume - 0.5);
            vCurvatureFlow += (double)(9.424776f / this.rad) * ((double)vNFrom / this.vVolume - 0.5);
        } else if (this.dim == 3) {
            vCurvatureFlow -= (double)(16.0f / (3.0f * this.rad)) * ((double)vNto / this.vVolume - 0.5);
            vCurvatureFlow += (double)(16.0f / (3.0f * this.rad)) * ((double)vNFrom / this.vVolume - 0.5);
        }
        return vCurvatureFlow;
    }
}

