/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.energies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.IntensityImage;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.core.utils.MosaicUtils;
import mosaic.regions.RC.ContourParticle;
import mosaic.regions.energies.Energy;
import mosaic.regions.utils.LabelStatistics;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.fft2.FFTConvolution;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;

public class E_Deconvolution
extends Energy.ExternalEnergy {
    private final Img<FloatType> DevImage;
    private final RandomAccess<FloatType> infDevAccessIt;
    private final IntensityImage iImage;
    private final Img<FloatType> iPsf;
    private final Point iMiddlePointPsf;

    public E_Deconvolution(IntensityImage aImage, Img<FloatType> aPsf) {
        this.DevImage = new ArrayImgFactory().create(aImage.getDimensions(), (Object)new FloatType());
        this.infDevAccessIt = Views.extendPeriodic(this.DevImage).randomAccess();
        this.iImage = aImage;
        this.iPsf = aPsf;
        int[] psfDims = MosaicUtils.getImageIntDimensions(this.iPsf);
        for (int i = 0; i < psfDims.length; ++i) {
            psfDims[i] = psfDims[i] / 2;
        }
        this.iMiddlePointPsf = new Point(psfDims);
    }

    @Override
    public Energy.EnergyResult CalculateEnergyDifference(Point aIndex, ContourParticle contourParticle, int aToLabel, HashMap<Integer, LabelStatistics> labelMap) {
        int aFromLabel = contourParticle.label;
        float intensityDelta = (float)(labelMap.get((Object)Integer.valueOf((int)aToLabel)).iMedianIntensity - labelMap.get((Object)Integer.valueOf((int)aFromLabel)).iMedianIntensity);
        Point LowerCorner = aIndex.sub(this.iMiddlePointPsf);
        int[] loc = new int[this.iPsf.numDimensions()];
        Cursor vPSF = this.iPsf.localizingCursor();
        double energyDifference = 0.0;
        while (vPSF.hasNext()) {
            vPSF.fwd();
            vPSF.localize(loc);
            Point pos = LowerCorner.add(loc);
            this.infDevAccessIt.setPosition(pos.iCoords);
            float vEOld = ((FloatType)this.infDevAccessIt.get()).get() - this.iImage.getSafe(pos);
            float vENew = vEOld + intensityDelta * ((FloatType)vPSF.get()).get();
            energyDifference += (double)(vENew * vENew - vEOld * vEOld);
        }
        return new Energy.EnergyResult(energyDifference, false);
    }

    private static float Median(ArrayList<Float> values) {
        Collections.sort(values);
        if (values.size() % 2 == 1) {
            int mid = (values.size() + 1) / 2 - 1;
            if (Float.isInfinite(values.get(mid).floatValue())) {
                int i;
                for (i = mid; i >= 0 && Float.isInfinite(values.get(i).floatValue()); --i) {
                }
                return values.get(i).floatValue();
            }
            return values.get((values.size() + 1) / 2 - 1).floatValue();
        }
        float lower = values.get(values.size() / 2 - 1).floatValue();
        float upper = values.get(values.size() / 2).floatValue();
        if (Float.isInfinite(lower) || Float.isInfinite(upper)) {
            int i;
            for (i = values.size() / 2; i >= 0 && Float.isInfinite(values.get(i).floatValue()); --i) {
            }
            return values.get(i).floatValue();
        }
        return (lower + upper) / 2.0f;
    }

    public void GenerateModelImage(LabelImage aLabelImage, HashMap<Integer, LabelStatistics> labelMap) {
        Cursor cVModelImage = this.DevImage.cursor();
        int size = aLabelImage.getSize();
        for (int i = 0; i < size && cVModelImage.hasNext(); ++i) {
            cVModelImage.fwd();
            int vLabel = aLabelImage.getLabelAbs(i);
            if (aLabelImage.isBorderLabel(vLabel)) {
                vLabel = 0;
            }
            ((FloatType)cVModelImage.get()).set((float)labelMap.get((Object)Integer.valueOf((int)vLabel)).iMedianIntensity);
        }
        new FFTConvolution(this.DevImage, this.iPsf).convolve();
    }

    public void RenewDeconvolution(LabelImage aInitImage, HashMap<Integer, LabelStatistics> aLabelMap) {
        double vOldBG = aLabelMap.get((Object)Integer.valueOf((int)0)).iMedianIntensity;
        HashMap<Integer, Integer> vLabelCounter = new HashMap<Integer, Integer>();
        HashMap<Integer, Float> vIntensitySum = new HashMap<Integer, Float>();
        HashMap vScalings3 = new HashMap();
        for (Map.Entry<Integer, LabelStatistics> Label2 : aLabelMap.entrySet()) {
            int vLabel = Label2.getKey();
            if (aInitImage.isBorderLabel(vLabel)) continue;
            vScalings3.put(vLabel, new ArrayList());
            vLabelCounter.put(vLabel, 0);
            vIntensitySum.put(vLabel, Float.valueOf(0.0f));
        }
        Cursor cVDevImage = this.DevImage.cursor();
        int size = aInitImage.getSize();
        for (int i = 0; i < size && cVDevImage.hasNext(); ++i) {
            ArrayList arr;
            cVDevImage.fwd();
            int vLabelAbs = aInitImage.getLabelAbs(i);
            if (aInitImage.isBorderLabel(vLabelAbs)) continue;
            vLabelCounter.put(vLabelAbs, (Integer)vLabelCounter.get(vLabelAbs) + 1);
            if (vLabelAbs == 0) {
                float vBG = this.iImage.get(i) - (((FloatType)cVDevImage.get()).get() - (float)vOldBG);
                arr = (ArrayList)vScalings3.get(vLabelAbs);
                arr.add(Float.valueOf(vBG));
                continue;
            }
            float vScale = (this.iImage.get(i) - (float)vOldBG) / (((FloatType)cVDevImage.get()).get() - (float)vOldBG);
            arr = (ArrayList)vScalings3.get(vLabelAbs);
            arr.add(Float.valueOf(vScale));
        }
        for (Map.Entry vLabel : vScalings3.entrySet()) {
            float vMedian = aLabelMap.get(vLabel.getKey()).iLabelCount > 2 ? E_Deconvolution.Median((ArrayList)vScalings3.get(vLabel.getKey())) : (float)aLabelMap.get(vLabel.getKey()).iMeanIntensity;
            if ((Integer)vLabel.getKey() == 0) {
                if (vMedian < 0.0f) {
                    vMedian = 0.0f;
                }
                aLabelMap.get(vLabel.getKey()).iMedianIntensity = vMedian;
                continue;
            }
            if (Double.isInfinite(vMedian)) {
                vMedian = E_Deconvolution.Median((ArrayList)vScalings3.get(vLabel.getKey()));
            }
            aLabelMap.get(vLabel.getKey()).iMedianIntensity = (aLabelMap.get(vLabel.getKey()).iMedianIntensity - vOldBG) * (double)vMedian + aLabelMap.get((Object)Integer.valueOf((int)0)).iMedianIntensity;
        }
        this.GenerateModelImage(aInitImage, aLabelMap);
    }

    public void UpdateConvolvedImage(Point aIndex, int aFromLabel, int aToLabel, HashMap<Integer, LabelStatistics> aLabelMap) {
        Point currentPos = aIndex.sub(this.iMiddlePointPsf);
        if (aToLabel == 0) {
            float vIntensity_FromLabel = (float)aLabelMap.get((Object)Integer.valueOf((int)aFromLabel)).iMedianIntensity;
            float vIntensity_BGLabel = (float)aLabelMap.get((Object)Integer.valueOf((int)aToLabel)).iMedianIntensity;
            this.subtractPsfFromConvImage(currentPos, vIntensity_FromLabel, vIntensity_BGLabel);
        } else {
            float vIntensity_ToLabel = (float)aLabelMap.get((Object)Integer.valueOf((int)aToLabel)).iMedianIntensity;
            float vIntensity_BGLabel = (float)aLabelMap.get((Object)Integer.valueOf((int)0)).iMedianIntensity;
            this.subtractPsfFromConvImage(currentPos, vIntensity_BGLabel, vIntensity_ToLabel);
        }
    }

    private void subtractPsfFromConvImage(Point currentPos, float fromLabel, float toLabel) {
        int[] loc = new int[this.iPsf.numDimensions()];
        Cursor vPSF = this.iPsf.localizingCursor();
        while (vPSF.hasNext()) {
            vPSF.fwd();
            vPSF.localize(loc);
            Point pos = new Point(loc).add(currentPos);
            this.infDevAccessIt.setPosition(pos.iCoords);
            ((FloatType)this.infDevAccessIt.get()).set(((FloatType)this.infDevAccessIt.get()).get() - (fromLabel - toLabel) * ((FloatType)vPSF.get()).get());
        }
    }
}

