/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.energies;

import java.util.HashMap;
import mosaic.core.imageUtils.Point;
import mosaic.regions.RC.ContourParticle;
import mosaic.regions.energies.Energy;
import mosaic.regions.utils.LabelStatistics;
import mosaic.utils.Debug;

public class E_KLMergingCriterion
extends Energy.ExternalEnergy {
    private final float m_RegionMergingThreshold;
    private final int bgLabel;

    public E_KLMergingCriterion(int bgLabel, float m_RegionMergingThreshold) {
        this.bgLabel = bgLabel;
        this.m_RegionMergingThreshold = m_RegionMergingThreshold;
    }

    @Override
    public Energy.EnergyResult CalculateEnergyDifference(Point contourPoint, ContourParticle contourParticle, int toLabel, HashMap<Integer, LabelStatistics> labelMap) {
        int fromLabel = contourParticle.label;
        boolean merge = this.CalculateMergingEnergyForLabel(fromLabel, toLabel, labelMap);
        return new Energy.EnergyResult(null, merge);
    }

    private boolean CalculateMergingEnergyForLabel(int aLabelA, int aLabelB, HashMap<Integer, LabelStatistics> labelMap) {
        double value;
        return aLabelA != this.bgLabel && aLabelB != this.bgLabel && (value = this.CalculateKLMergingCriterion(aLabelA, aLabelB, labelMap)) < (double)this.m_RegionMergingThreshold;
    }

    private double CalculateKLMergingCriterion(int L1, int L2, HashMap<Integer, LabelStatistics> labelMap) {
        LabelStatistics aL1 = labelMap.get(L1);
        LabelStatistics aL2 = labelMap.get(L2);
        double vMu1 = aL1.iMeanIntensity;
        double vMu2 = aL2.iMeanIntensity;
        double vVar1 = aL1.iVarIntensity;
        double vVar2 = aL2.iVarIntensity;
        int vN1 = aL1.iLabelCount;
        int vN2 = aL2.iLabelCount;
        return E_KLMergingCriterion.calc(vMu1, vMu2, vVar1, vVar2, vN1, vN2);
    }

    static double calc(double aMu1, double aMu2, double aVar1, double aVar2, int aN1, int aN2) {
        double vDKL2;
        double vDKL1;
        double result;
        double vSumOfSq1 = aVar1 * (double)(aN1 - 1) + (double)aN1 * aMu1 * aMu1;
        double vSumOfSq2 = aVar2 * (double)(aN2 - 1) + (double)aN2 * aMu2 * aMu2;
        double vMu12 = ((double)aN1 * aMu1 + (double)aN2 * aMu2) / (double)(aN1 + aN2);
        double vVar12 = 1.0 / ((double)(aN1 + aN2) - 1.0) * (vSumOfSq1 + vSumOfSq2 - (double)(aN1 + aN2) * vMu12 * vMu12);
        if (vVar12 <= 0.0) {
            return 0.0;
        }
        if (aVar1 < 0.0) {
            aVar1 = 0.0;
        }
        if (aVar2 < 0.0) {
            aVar2 = 0.0;
        }
        if (Double.isNaN(result = (vDKL1 = (aMu1 - vMu12) * (aMu1 - vMu12) / (2.0 * vVar12) + 0.5 * (aVar1 / vVar12 - 1.0 - Math.log(aVar1 / vVar12))) + (vDKL2 = (aMu2 - vMu12) * (aMu2 - vMu12) / (2.0 * vVar12) + 0.5 * (aVar2 / vVar12 - 1.0 - Math.log(aVar2 / vVar12))))) {
            Debug.print("E_KLMergingCriterion.java: NaN problem", aMu1, aMu2, aVar1, aVar2, aN1, aN2);
            result = 0.0;
        }
        return result;
    }
}

