/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.energies;

import java.util.HashMap;
import mosaic.core.imageUtils.Point;
import mosaic.regions.RC.ContourParticle;
import mosaic.regions.energies.Energy;
import mosaic.regions.utils.LabelStatistics;

public class ImageModel {
    private static final float EnergyRegionCoeff = 1.0f;
    private static final float ConstantOutwardFlow = 0.0f;
    private final Energy.ExternalEnergy iEnergyData;
    private final Energy.InternalEnergy iEnergyLength;
    private Energy.ExternalEnergy iEnergyMerge;
    private final float iEnergyContourLengthCoeff;

    public ImageModel(Energy.ExternalEnergy aEnergyData, Energy.InternalEnergy aEnergyLength, Energy.ExternalEnergy aEnergyMerge, float aEnergyContourLengthCoeff) {
        this.iEnergyData = aEnergyData;
        this.iEnergyLength = aEnergyLength;
        this.iEnergyMerge = aEnergyMerge;
        this.iEnergyContourLengthCoeff = aEnergyContourLengthCoeff;
    }

    public Energy getEdata() {
        return this.iEnergyData;
    }

    public Energy.EnergyResult calculateDeltaEnergy(Point aContourIndex, ContourParticle aContourPointPtr, int aToLabel, HashMap<Integer, LabelStatistics> aLabelMap) {
        Double energyChange = 0.0;
        Boolean shouldMerge = false;
        Energy.EnergyResult e = this.iEnergyData.CalculateEnergyDifference(aContourIndex, aContourPointPtr, aToLabel, aLabelMap);
        energyChange = energyChange + 1.0 * e.energyDifference;
        shouldMerge = e.merge;
        if (this.iEnergyContourLengthCoeff != 0.0f && this.iEnergyLength != null) {
            e = this.iEnergyLength.CalculateEnergyDifference(aContourIndex, aContourPointPtr, aToLabel, aLabelMap);
            energyChange = energyChange + (double)this.iEnergyContourLengthCoeff * e.energyDifference;
        }
        energyChange = energyChange - (aContourPointPtr.label == 0 ? 0.0 : -0.0);
        if (this.iEnergyMerge != null) {
            e = this.iEnergyMerge.CalculateEnergyDifference(aContourIndex, aContourPointPtr, aToLabel, aLabelMap);
            shouldMerge = e.merge;
        }
        return new Energy.EnergyResult(energyChange, shouldMerge);
    }
}

