/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.initializers;

import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.core.imageUtils.iterators.SpaceIterator;
import mosaic.regions.initializers.Initializer;
import mosaic.regions.utils.BubbleDrawer;

public class BubbleInitializer
extends Initializer {
    public BubbleInitializer(LabelImage labelImage) {
        super(labelImage);
    }

    public void initialize(int aRadius, int aPadding) {
        int radius = aRadius <= 0 ? 1 : aRadius;
        for (int i = 0; i < this.iNumOfDimensions; ++i) {
            int size = this.iDimensionsSize[i];
            if (2 * radius <= size) continue;
            radius = size / 2;
        }
        this.initializeBubbles(radius, aPadding);
    }

    private void initializeBubbles(int aRadius, int aPadding) {
        int[] gridDims = new int[this.iNumOfDimensions];
        int[] borderOffset = new int[this.iNumOfDimensions];
        this.calculateGridDimensionsAndGapsBetweenBubbles(aRadius, aPadding, gridDims, borderOffset);
        this.drawBubblesWithLabels(aRadius, aPadding, gridDims, borderOffset);
    }

    private void calculateGridDimensionsAndGapsBetweenBubbles(int aRadius, int aPadding, int[] aGridDims, int[] aBorderOffset) {
        for (int i = 0; i < this.iNumOfDimensions; ++i) {
            int bubblesPerLength;
            int size = this.iDimensionsSize[i];
            aGridDims[i] = bubblesPerLength = (size + aPadding) / (aPadding + 2 * aRadius);
            aBorderOffset[i] = (size - (bubblesPerLength * 2 * aRadius + (bubblesPerLength - 1) * aPadding)) / 2;
        }
    }

    private void drawBubblesWithLabels(int aRadius, int aPadding, int[] aGrid, int[] aBorderOffset) {
        Point offset = new Point(aBorderOffset);
        BubbleDrawer bd = new BubbleDrawer(this.iLabelImage, aRadius, 2 * aRadius);
        SpaceIterator it = new SpaceIterator(aGrid);
        int bubbleLabel = 1;
        for (Point ofs : it.getPointIterable()) {
            ofs = ofs.mult(aPadding + 2 * aRadius).add(offset);
            bd.drawUpperLeft(ofs, bubbleLabel);
            ++bubbleLabel;
        }
    }
}

