/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.utils;

import mosaic.core.imageUtils.MaskOnSpaceMapper;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.core.imageUtils.masks.BallMask;

public class BubbleDrawer {
    private final LabelImage labelImage;
    private final MaskOnSpaceMapper sphereIt;
    private final BallMask sphere;

    public BubbleDrawer(LabelImage labelImage, int radius, int size) {
        this.labelImage = labelImage;
        int dim = labelImage.getNumOfDimensions();
        int[] input = labelImage.getDimensions();
        float[] scaling = new float[dim];
        for (int i = 0; i < dim; ++i) {
            scaling[i] = 1.0f;
        }
        this.sphere = new BallMask(radius, size, scaling);
        this.sphereIt = new MaskOnSpaceMapper(this.sphere, input);
    }

    public void drawUpperLeft(Point ofs, int val) {
        this.sphereIt.setUpperLeft(ofs);
        while (this.sphereIt.hasNext()) {
            int idx = this.sphereIt.next();
            this.labelImage.setLabel(idx, val);
        }
    }

    public void drawCenter(Point center, int val) {
        this.sphereIt.setMiddlePoint(center);
        while (this.sphereIt.hasNext()) {
            int idx = this.sphereIt.next();
            this.labelImage.setLabel(idx, val);
        }
    }
}

