/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mosaic.core.imageUtils.images.IntensityImage;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.regions.utils.LabelStatistics;
import org.apache.log4j.Logger;

public class LabelStatisticToolbox {
    private static final Logger logger = Logger.getLogger(LabelStatisticToolbox.class);

    public static int initStatistics(LabelImage iLabelImage, IntensityImage iIntensityImage, HashMap<Integer, LabelStatistics> iLabelStatistics) {
        int maxUsedLabel = 0;
        for (int i = 0; i < iLabelImage.getSize(); ++i) {
            LabelStatistics stats;
            int absLabel = iLabelImage.getLabelAbs(i);
            if (iLabelImage.isBorderLabel(absLabel)) continue;
            if (maxUsedLabel < absLabel) {
                maxUsedLabel = absLabel;
            }
            if ((stats = iLabelStatistics.get(absLabel)) == null) {
                stats = new LabelStatistics(absLabel, iLabelImage.getNumOfDimensions());
                iLabelStatistics.put(absLabel, stats);
            }
            double val = iIntensityImage.get(i);
            stats.iSum += val;
            stats.iSumOfSq += val * val;
            ++stats.iLabelCount;
        }
        LabelStatistics stats = iLabelStatistics.get(0);
        if (stats == null) {
            stats = new LabelStatistics(0, iLabelImage.getNumOfDimensions());
            iLabelStatistics.put(0, stats);
        }
        for (LabelStatistics stat : iLabelStatistics.values()) {
            int n = stat.iLabelCount;
            stat.iMeanIntensity = n > 0 ? stat.iSum / (double)n : 0.0;
            stat.iVarIntensity = LabelStatisticToolbox.calculateVariance(stats.iSumOfSq, stat.iMeanIntensity, n);
            stat.iMedianIntensity = stat.iMeanIntensity;
        }
        return maxUsedLabel;
    }

    public static void updateLabelStatistics(double aIntensity, int aFromLabelIdx, int aToLabelIdx, HashMap<Integer, LabelStatistics> iLabelStatistics) {
        LabelStatistics toStats = iLabelStatistics.get(aToLabelIdx);
        LabelStatistics fromStats = iLabelStatistics.get(aFromLabelIdx);
        toStats.iSumOfSq += aIntensity * aIntensity;
        fromStats.iSumOfSq -= aIntensity * aIntensity;
        toStats.iSum += aIntensity;
        fromStats.iSum -= aIntensity;
        ++toStats.iLabelCount;
        --fromStats.iLabelCount;
        toStats.iMeanIntensity = toStats.iSum / (double)toStats.iLabelCount;
        fromStats.iMeanIntensity = fromStats.iLabelCount > 0 ? fromStats.iSum / (double)fromStats.iLabelCount : 0.0;
        toStats.iVarIntensity = LabelStatisticToolbox.calculateVariance(toStats.iSumOfSq, toStats.iMeanIntensity, toStats.iLabelCount);
        fromStats.iVarIntensity = LabelStatisticToolbox.calculateVariance(fromStats.iSumOfSq, fromStats.iMeanIntensity, fromStats.iLabelCount);
    }

    public static void removeEmptyStatistics(HashMap<Integer, LabelStatistics> iLabelStatistics) {
        Iterator<Map.Entry<Integer, LabelStatistics>> labelStatsIt = iLabelStatistics.entrySet().iterator();
        while (labelStatsIt.hasNext()) {
            Map.Entry<Integer, LabelStatistics> entry = labelStatsIt.next();
            if (entry.getValue().iLabelCount != 0) continue;
            if (entry.getKey() != 0) {
                labelStatsIt.remove();
                continue;
            }
            logger.error((Object)"Tried to remove background label from label statistics!");
        }
    }

    private static double calculateVariance(double aSumSq, double aMean, int aN) {
        return aN < 2 ? 0.0 : (aSumSq - (double)aN * aMean * aMean) / ((double)aN - 1.0);
    }
}

