/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils;

import java.util.List;

public class ConvertArray {
    public static float[] toFloat(double[] aArray) {
        int len = aArray.length;
        float[] result = new float[len];
        for (int i = 0; i < len; ++i) {
            result[i] = (float)aArray[i];
        }
        return result;
    }

    public static float[][] toFloat(double[][] aArray) {
        int h = aArray.length;
        int w = aArray[0].length;
        float[][] result = new float[h][w];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                result[y][x] = (float)aArray[y][x];
            }
        }
        return result;
    }

    public static float[][][] toFloat(double[][][] aArray) {
        int d = aArray.length;
        int h = aArray[0].length;
        int w = aArray[0][0].length;
        float[][][] result = new float[d][h][w];
        for (int z = 0; z < d; ++z) {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    result[z][y][x] = (float)aArray[z][y][x];
                }
            }
        }
        return result;
    }

    public static double[] toDouble(float[] aArray) {
        int h = aArray.length;
        double[] result = new double[h];
        for (int y = 0; y < h; ++y) {
            result[y] = aArray[y];
        }
        return result;
    }

    public static double[][] toDouble(float[][] aArray) {
        int h = aArray.length;
        int w = aArray[0].length;
        double[][] result = new double[h][w];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                result[y][x] = aArray[y][x];
            }
        }
        return result;
    }

    public static double[][][] toDouble(float[][][] aArray) {
        int d = aArray.length;
        int h = aArray[0].length;
        int w = aArray[0][0].length;
        double[][][] result = new double[d][h][w];
        for (int z = 0; z < d; ++z) {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    result[z][y][x] = aArray[z][y][x];
                }
            }
        }
        return result;
    }

    public static double[][][] toDouble(short[][][] aArray) {
        int d = aArray.length;
        int h = aArray[0].length;
        int w = aArray[0][0].length;
        double[][][] result = new double[d][h][w];
        for (int z = 0; z < d; ++z) {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    result[z][y][x] = aArray[z][y][x];
                }
            }
        }
        return result;
    }

    public static double[] toDouble(List<Double> aList) {
        int h = aList.size();
        double[] result = new double[h];
        for (int y = 0; y < h; ++y) {
            result[y] = aList.get(y);
        }
        return result;
    }

    public static int[] toInt(byte[] aArray) {
        int len = aArray.length;
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            result[i] = aArray[i];
        }
        return result;
    }

    public static int[] toInt(short[] aArray) {
        int len = aArray.length;
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            result[i] = aArray[i];
        }
        return result;
    }

    public static int[] toInt(long[] aArray) {
        int len = aArray.length;
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            result[i] = (int)aArray[i];
        }
        return result;
    }

    public static int[] toInt(float[] aArray) {
        int len = aArray.length;
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            result[i] = (int)aArray[i];
        }
        return result;
    }

    public static short[] toShort(int[] aArray) {
        int len = aArray.length;
        short[] result = new short[len];
        for (int i = 0; i < len; ++i) {
            result[i] = (short)aArray[i];
        }
        return result;
    }

    public static float[][] toFloat2D(float[] aArray, int aWidth, int aHeight) {
        if (aArray.length != aWidth * aHeight) {
            throw new RuntimeException("Wrong Dimensions: " + aArray.length + " vs " + aWidth + "/" + aHeight);
        }
        float[][] result = new float[aWidth][aHeight];
        for (int x = 0; x < aWidth; ++x) {
            for (int y = 0; y < aHeight; ++y) {
                result[x][y] = aArray[y * aWidth + x];
            }
        }
        return result;
    }

    public static double[][] toDouble2D(double[] aArray, int aWidth, int aHeight) {
        if (aArray.length != aWidth * aHeight) {
            throw new RuntimeException("Wrong Dimensions: " + aArray.length + " vs " + aWidth + "/" + aHeight);
        }
        double[][] result = new double[aWidth][aHeight];
        for (int x = 0; x < aWidth; ++x) {
            for (int y = 0; y < aHeight; ++y) {
                result[x][y] = aArray[y * aWidth + x];
            }
        }
        return result;
    }
}

