/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils;

import ij.IJ;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class SysOps {
    public static final String SEPARATOR = File.separator;

    public static void copyFileToDirectory(String aSrcFile, String aDestDir) {
        SysOps.copyFileToDirectory(new File(aSrcFile), new File(aDestDir));
    }

    public static void copyFileToDirectory(File aSrcFile, File aDestDir) {
        try {
            FileUtils.copyFileToDirectory((File)aSrcFile, (File)aDestDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot copy file [" + aSrcFile + "] to dir [" + aDestDir + "] [" + e.getMessage() + "]");
        }
    }

    public static void copyDirectoryToDirectory(File aSrcDir, File aDestDir) {
        try {
            FileUtils.copyDirectoryToDirectory((File)aSrcDir, (File)aDestDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot copy directory [" + aSrcDir + "] to dir [" + aDestDir + "] [" + e.getMessage() + "]");
        }
    }

    public static void copyFile(File aSrcFile, File aDestFile) {
        try {
            FileUtils.copyFile((File)aSrcFile, (File)aDestFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot copy file [" + aSrcFile + "] to [" + aDestFile + "]");
        }
    }

    public static void createDir(String aDirName) {
        SysOps.createDir(new File(aDirName));
    }

    public static void createDir(File aDir) {
        try {
            FileUtils.forceMkdir((File)aDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Creating directory: [" + aDir.getAbsolutePath() + "] failed! [" + e.getMessage() + "]");
        }
    }

    public static void moveFile(String aSrcFile, String aDestFile) {
        File src = new File(aSrcFile);
        File dest = new File(aDestFile);
        SysOps.moveFile(src, dest, false);
    }

    public static void moveFile(String aSrcFile, String aDestFile, boolean aQuiteModeActive) {
        File src = new File(aSrcFile);
        File dest = new File(aDestFile);
        SysOps.moveFile(src, dest, aQuiteModeActive);
    }

    public static void moveFileToDir(File aSrcFile, File aDestDir, boolean aQuiteModeActive, boolean aCreateDestDir) {
        try {
            if (!aSrcFile.exists() && aQuiteModeActive) {
                return;
            }
            String movedFileAbsolutePath = aDestDir.getAbsolutePath() + File.separator + aSrcFile.getName();
            File movedFile = new File(movedFileAbsolutePath);
            if (movedFile.exists()) {
                FileUtils.deleteQuietly((File)movedFile);
            }
            FileUtils.moveFileToDirectory((File)aSrcFile, (File)aDestDir, (boolean)aCreateDestDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot move file [" + aSrcFile + "] to [" + aDestDir + "] [" + e.getMessage() + "]");
        }
    }

    public static void moveFile(File aSrcFile, File aDestFile, boolean aQuiteModeActive) {
        try {
            if (aDestFile.exists()) {
                FileUtils.deleteQuietly((File)aDestFile);
            }
            if (!aSrcFile.exists() && aQuiteModeActive) {
                return;
            }
            FileUtils.moveFile((File)aSrcFile, (File)aDestFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot move file [" + aSrcFile + "] to [" + aDestFile + "] [" + e.getMessage() + "]");
        }
    }

    public static void removeDir(String aDirName) {
        SysOps.removeDir(new File(aDirName));
    }

    public static void removeDir(File aDir) {
        try {
            FileUtils.deleteDirectory((File)aDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Deleting directory: [" + aDir.getAbsolutePath() + "] failed! [" + e.getMessage() + "]");
        }
    }

    public static String getTmpPath() {
        return IJ.getDirectory((String)"temp");
    }

    public static String removeExtension(String aFileName) {
        return FilenameUtils.removeExtension((String)aFileName);
    }

    public static String getPathToFile(String aFileName) {
        return FilenameUtils.getFullPath((String)aFileName);
    }

    public static String getExtension(String aFileName) {
        return FilenameUtils.getExtension((String)aFileName);
    }

    public static String getFileName(String aFileName) {
        return FilenameUtils.getName((String)aFileName);
    }

    public static String getSystemUsername() {
        String username = System.getenv("USER");
        if (username == null || username.equals("")) {
            return null;
        }
        return username;
    }

    public static String removeRedundantSeparators(String aFileName) {
        return aFileName.replaceAll("/+", "/");
    }
}

