/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils;

import org.apache.log4j.Logger;

public class TimeMeasurement {
    private static final Logger logger = Logger.getLogger(TimeMeasurement.class);
    private final long startTime;
    private long lastTime;

    public TimeMeasurement() {
        this.lastTime = this.startTime = System.nanoTime();
    }

    public long getTimeNanoSec() {
        long endTime = System.nanoTime();
        long duration = endTime - this.startTime;
        this.lastTime = endTime;
        return duration;
    }

    public long getTimeMicroSec() {
        return this.getTimeNanoSec() / 1000L;
    }

    public long getTimeMilliSec() {
        return this.getTimeNanoSec() / 1000000L;
    }

    public long getTimeSec() {
        return this.getTimeNanoSec() / 1000000000L;
    }

    public long getLapTimeNanoSec() {
        long endTime = System.nanoTime();
        long duration = endTime - this.lastTime;
        this.lastTime = endTime;
        return duration;
    }

    public long getLapTimeMicroSec() {
        return this.getLapTimeNanoSec() / 1000L;
    }

    public long getLapTimeMilliSec() {
        return this.getLapTimeNanoSec() / 1000000L;
    }

    public long getLapTimeSec() {
        return this.getLapTimeNanoSec() / 1000000000L;
    }

    public void logLapTimeNanoSec(String aName) {
        logger.info((Object)(aName + " (ns): " + this.getLapTimeNanoSec()));
    }

    public void logTimeNanoSec(String aName) {
        logger.info((Object)(aName + " (ns): " + this.getTimeNanoSec()));
    }

    public void logLapTimeSec(String aName) {
        logger.info((Object)(aName + " (s): " + this.getLapTimeSec()));
    }

    public void logTimeSec(String aName) {
        logger.info((Object)(aName + " (s): " + this.getTimeSec()));
    }
}

