/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.io.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.OutputStream;
import java.util.Vector;
import mosaic.utils.SysOps;
import mosaic.utils.io.ssh.SshSession;
import org.apache.log4j.Logger;

public class SFTP
extends SshSession {
    private static final Logger logger = Logger.getLogger(SFTP.class);
    ChannelSftp sftp = this.createSftpChannel();

    public SFTP(String aHostAddress, String aUserName, String aPassword, String aKeyPath) throws JSchException {
        super(aHostAddress, aUserName, aPassword, aKeyPath);
    }

    public SFTP(Session aSession) throws JSchException {
        super(aSession);
    }

    public boolean upload(String aRemoteDirectory, String ... aFiles) {
        File[] files = new File[aFiles.length];
        for (int i = 0; i < aFiles.length; ++i) {
            files[i] = new File(aFiles[i]);
        }
        File dir = new File(aRemoteDirectory);
        return this.upload(dir, files);
    }

    public boolean upload(File aRemoteDirectory, File ... aFiles) {
        for (File file : aFiles) {
            String destFileAbsolutePath = aRemoteDirectory.getPath() + File.separator + file.getName();
            String uploadString = "[" + file.getAbsolutePath() + "] file to [" + this.session.getHost() + ":" + destFileAbsolutePath + "]";
            try {
                logger.debug((Object)("Uploding " + uploadString));
                this.sftp.put(file.getAbsolutePath(), destFileAbsolutePath);
            }
            catch (SftpException e) {
                logger.error((Object)("Could not upload " + uploadString));
                logger.error((Object)("Reason: " + e.toString()));
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean download(String aLocalDirectory, String ... aFiles) {
        File[] files = new File[aFiles.length];
        for (int i = 0; i < aFiles.length; ++i) {
            files[i] = new File(aFiles[i]);
        }
        File dir = new File(aLocalDirectory);
        return this.download(dir, files);
    }

    public boolean download(File aLocalDirectory, File ... aFiles) {
        for (File file : aFiles) {
            String destFileAbsolutePath = aLocalDirectory.getPath() + File.separator + file.getName();
            String downloadString = "[" + this.session.getHost() + ":" + file.getAbsolutePath() + "] file to [" + destFileAbsolutePath + "]";
            try {
                logger.debug((Object)("Downloading " + downloadString));
                this.sftp.get(file.getAbsolutePath(), destFileAbsolutePath);
            }
            catch (SftpException e) {
                logger.error((Object)("Could not download " + downloadString));
                logger.error((Object)("Reason: " + e.toString()));
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean downloadDir(String aLocalDirectory, String aRemoteDirectory) {
        return this.downloadDir(new File(aLocalDirectory), new File(aRemoteDirectory));
    }

    public boolean downloadDir(File aLocalDirectory, File aRemoteDirectory) {
        logger.info((Object)("Downloading directory [" + aRemoteDirectory + "] to [" + aLocalDirectory + "]"));
        try {
            SftpATTRS remoteDirStat = this.getFileStat(aRemoteDirectory.getAbsolutePath());
            if (remoteDirStat == null || !remoteDirStat.isDir()) {
                logger.error((Object)("aRemoteDirectory is not a directory type! [" + aRemoteDirectory + "]"));
                return false;
            }
            Vector ls = this.sftp.ls(aRemoteDirectory.getAbsolutePath());
            for (ChannelSftp.LsEntry entry : ls) {
                SftpATTRS attrs = entry.getAttrs();
                String name = entry.getFilename();
                String remoteAbsoluteFileName = aRemoteDirectory + File.separator + name;
                if (attrs.isDir()) {
                    if (name.equals("..") || name.equals(".")) continue;
                    String deepDirectory = aLocalDirectory + File.separator + name;
                    File newDir = new File(deepDirectory);
                    if (!newDir.exists()) {
                        logger.debug((Object)("Making local dir [" + newDir.getAbsolutePath() + "]"));
                        SysOps.createDir(newDir);
                    }
                    if (this.downloadDir(newDir, new File(remoteAbsoluteFileName))) continue;
                    return false;
                }
                if (attrs.isReg()) {
                    if (this.download(aLocalDirectory.getAbsolutePath(), remoteAbsoluteFileName)) continue;
                    return false;
                }
                logger.debug((Object)("skipping: " + remoteAbsoluteFileName + " to " + aLocalDirectory));
            }
        }
        catch (SftpException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean uploadDir(String aLocalDirectory, String aRemoteDirectory) {
        return this.uploadDir(new File(aLocalDirectory), new File(aRemoteDirectory));
    }

    public boolean uploadDir(File aLocalDirectory, File aRemoteDirectory) {
        logger.info((Object)("Uploading directory [" + aLocalDirectory + "] to [" + aRemoteDirectory + "]"));
        try {
            File[] ls;
            if (!aLocalDirectory.isDirectory()) {
                logger.error((Object)("aLocalDirectory is not a directory type! [" + aLocalDirectory + "]"));
                return false;
            }
            for (File entry : ls = aLocalDirectory.listFiles()) {
                String name = entry.getName();
                String localAbsoluteFileName = aLocalDirectory + File.separator + name;
                if (entry.isDirectory()) {
                    if (name.equals("..") || name.equals(".")) continue;
                    String deepDirectory = aRemoteDirectory + File.separator + name;
                    if (this.getFileStat(deepDirectory) == null) {
                        logger.debug((Object)("Making remote dir [" + deepDirectory + "]"));
                        this.sftp.mkdir(deepDirectory);
                    }
                    if (this.uploadDir(new File(localAbsoluteFileName), new File(deepDirectory))) continue;
                    return false;
                }
                if (entry.isFile()) {
                    if (this.upload(aRemoteDirectory.getAbsolutePath(), localAbsoluteFileName)) continue;
                    return false;
                }
                logger.debug((Object)("skipping: " + localAbsoluteFileName + " to " + aRemoteDirectory));
            }
        }
        catch (SftpException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private SftpATTRS getFileStat(String aFullPathName) {
        try {
            return this.sftp.stat(aFullPathName);
        }
        catch (SftpException e) {
            return null;
        }
    }

    private ChannelSftp createSftpChannel() throws JSchException {
        ChannelSftp sftp = (ChannelSftp)this.session.openChannel("sftp");
        sftp.setExtOutputStream((OutputStream)System.err);
        sftp.connect();
        return sftp;
    }
}

