/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.io.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import mosaic.utils.io.ssh.SshSession;
import org.apache.log4j.Logger;

public class SSH
extends SshSession {
    private static final Logger logger = Logger.getLogger(SSH.class);
    private static final int CMD_EXECUTION_TIMEOUT_MS = 10000;

    public SSH(String aHostAddress, String aUserName, String aPassword, String aKeyPath) throws JSchException {
        super(aHostAddress, aUserName, aPassword, aKeyPath);
    }

    public SSH(Session aSession) throws JSchException {
        super(aSession);
    }

    public SshOutput executeCommands(String ... aCommands) {
        StringBuilder sb = new StringBuilder();
        for (String cmd : aCommands) {
            sb.append(cmd);
            sb.append("; ");
        }
        return this.executeTaggedCommand(sb.toString(), this.session);
    }

    private SshOutput executeTaggedCommand(String aCommandStr, Session aSshSession) {
        logger.debug((Object)("Executing command: [" + aCommandStr + "]"));
        String startStr = "---START_CMD_OUTPUT_TAG---";
        String cmds = "echo -n \"---START_CMD_OUTPUT_TAG---\"; " + aCommandStr;
        SshOutput output = this.executeCommand(cmds, aSshSession);
        int from = output.out.indexOf("---START_CMD_OUTPUT_TAG---");
        logger.trace((Object)("Index: " + from));
        from = from < 0 ? 0 : from + "---START_CMD_OUTPUT_TAG---".length();
        logger.trace((Object)("Index: " + from));
        output.out = output.out.substring(from);
        logger.debug((Object)output);
        return output;
    }

    private SshOutput executeCommand(String command, Session session) {
        SshOutput.Result success = SshOutput.Result.ERROR;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream errOut = new ByteArrayOutputStream();
        int errCode = -1234;
        logger.trace((Object)("Executing command: [" + command + "]"));
        try {
            final ChannelExec channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand(command);
            channel.setOutputStream((OutputStream)out);
            channel.setExtOutputStream((OutputStream)out);
            channel.setErrStream((OutputStream)errOut);
            channel.setPty(true);
            channel.connect();
            Thread timeoutThread = new Thread(){

                @Override
                public void run() {
                    try {
                        while (!channel.isClosed() && !Thread.currentThread().isInterrupted()) {
                            1.sleep(100L);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                }
            };
            timeoutThread.start();
            timeoutThread.join(10000L);
            if (timeoutThread.isAlive()) {
                logger.error((Object)"Command not executed entirely");
                timeoutThread.interrupt();
            } else {
                success = session.isConnected() ? SshOutput.Result.SUCCESS : SshOutput.Result.DISCONNECTED;
            }
            errCode = channel.getExitStatus();
            if (!channel.isClosed()) {
                channel.disconnect();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String removeColorInfo = "\u001b\\[[;\\d]*[ -/]*[@-~]";
        SshOutput result = new SshOutput(success, out.toString().replaceAll("\u001b\\[[;\\d]*[ -/]*[@-~]", ""), errOut.toString().replaceAll("\u001b\\[[;\\d]*[ -/]*[@-~]", ""), errCode);
        logger.trace((Object)result);
        return result;
    }

    public static class SshOutput {
        Result cmdExecutionResult;
        String out;
        String err;
        int cmdErrorCode;

        SshOutput(Result aExecutionResult, String aOutput, String aError, int aCmdErrorCode) {
            this.cmdExecutionResult = aExecutionResult;
            this.out = aOutput;
            this.err = aError;
            this.cmdErrorCode = aCmdErrorCode;
        }

        public String toString() {
            return "Result=" + (Object)((Object)this.cmdExecutionResult) + " CmdErrCode=" + this.cmdErrorCode + (this.out.length() != 0 ? "\n------------- Out -------------\n" + this.out + "\n-------------------------------" : "") + (this.err.length() != 0 ? "\n------------- Err -------------\n" + this.err + "\n-------------------------------" : "");
        }

        static enum Result {
            SUCCESS,
            ERROR,
            DISCONNECTED;

        }
    }
}

