/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.math;

public class LeastSquares {
    private double iBeta;
    private double iAlpha;

    public LeastSquares calculate(double[] aX, double[] aY) {
        if (aX.length != aY.length) {
            throw new IllegalArgumentException("Both arrays should have same number of elements [" + aX.length + " vs. " + aY.length + "]");
        }
        double SX = LeastSquares.Sum(aX);
        double SY = LeastSquares.Sum(aY);
        double SXX = LeastSquares.SumMultiplied(aX, aX);
        double SXY = LeastSquares.SumMultiplied(aX, aY);
        double n = aX.length;
        this.iBeta = (SXY - SX * SY / n) / (SXX - SX * SX / n);
        this.iAlpha = (SY - this.iBeta * SX) / n;
        return this;
    }

    public double getAlpha() {
        return this.iAlpha;
    }

    public double getBeta() {
        return this.iBeta;
    }

    private static double Sum(double[] aValues) {
        double sum = 0.0;
        for (int i = 0; i < aValues.length; ++i) {
            sum += aValues[i];
        }
        return sum;
    }

    private static double SumMultiplied(double[] aX, double[] aY) {
        double sum = 0.0;
        for (int i = 0; i < aX.length; ++i) {
            sum += aX[i] * aY[i];
        }
        return sum;
    }
}

