/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.math;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mosaic.utils.math.Interpolation;
import mosaic.utils.math.Matrix;

public class Matlab {
    public static double[] linspaceArray(double aMin, double aMax, int aNoOfSteps) {
        if (aNoOfSteps < 1) {
            return null;
        }
        double[] result = new double[aNoOfSteps];
        if (aNoOfSteps > 1) {
            double step = (aMax - aMin) / (double)(aNoOfSteps - 1);
            for (int i = 0; i < aNoOfSteps - 1; ++i) {
                result[i] = aMin + (double)i * step;
            }
        }
        result[aNoOfSteps - 1] = aMax;
        return result;
    }

    public static Matrix linspace(double aMin, double aMax, int aNoOfSteps) {
        return Matrix.mkRowVector(Matlab.linspaceArray(aMin, aMax, aNoOfSteps));
    }

    public static double[] regularySpacedArray(double aStart, double aStep, double aStop) {
        if (aStep == 0.0 || !(aStart > aStop ^ aStep > 0.0)) {
            return null;
        }
        int noOfSteps = (int)((aStop - aStart) / aStep) + 1;
        double[] result = new double[noOfSteps];
        double val = aStart;
        for (int i = 0; i < noOfSteps; ++i) {
            result[i] = val;
            val += aStep;
        }
        return result;
    }

    public static Matrix regularySpacedVector(double aMin, double aStep, double aMax) {
        return Matrix.mkRowVector(Matlab.regularySpacedArray(aMin, aStep, aMax));
    }

    public static Matrix[] meshgrid(Matrix aVector1, Matrix aVector2) {
        int i;
        if (aVector1.isColVector()) {
            aVector1 = aVector1.copy().transpose();
        }
        if (aVector2.isRowVector()) {
            aVector2 = aVector2.copy().transpose();
        }
        int r = aVector2.numRows();
        int c = aVector1.numCols();
        Matrix m1 = new Matrix(r, c);
        Matrix m2 = new Matrix(r, c);
        for (i = 0; i < r; ++i) {
            m1.insert(aVector1, i, 0);
        }
        for (i = 0; i < c; ++i) {
            m2.insert(aVector2, 0, i);
        }
        return new Matrix[]{m1, m2};
    }

    public static Matrix imfilterSymmetric(Matrix aImg, Matrix aFilter) {
        Matrix result = new Matrix(aImg.numRows(), aImg.numCols());
        int filterRows = aFilter.numRows();
        int filterCols = aFilter.numCols();
        int filterRowMiddle = (filterRows + 1) / 2 - 1;
        int filterColMiddle = (filterCols + 1) / 2 - 1;
        double[][] filter = aFilter.getArrayYX();
        int imageRows = aImg.numRows();
        int imageCols = aImg.numCols();
        double[][] image = aImg.getArrayYX();
        for (int r = 0; r < imageRows; ++r) {
            for (int c = 0; c < imageCols; ++c) {
                double sum = 0.0;
                for (int fr = 0; fr < filterRows; ++fr) {
                    for (int fc = 0; fc < filterCols; ++fc) {
                        int imr = r - filterRowMiddle + fr;
                        int imc = c - filterColMiddle + fc;
                        do {
                            if (imr < 0) {
                                imr = -imr - 1;
                            }
                            if (imr >= imageRows) {
                                imr = imageRows - 1 - (imr - (imageRows - 1) - 1);
                            }
                            if (imc < 0) {
                                imc = -imc - 1;
                            }
                            if (imc < imageCols) continue;
                            imc = imageCols - 1 - (imc - (imageCols - 1) - 1);
                        } while (imr < 0 || imr >= imageRows || imc < 0 || imc >= imageCols);
                        sum += filter[fr][fc] * image[imr][imc];
                    }
                }
                result.set(r, c, sum);
            }
        }
        return result;
    }

    public static Matrix imfilterConv(Matrix aImg, Matrix aFilter) {
        Matrix result = new Matrix(aImg.numRows(), aImg.numCols());
        int filterRows = aFilter.numRows();
        int filterCols = aFilter.numCols();
        int filterRowMiddle = (filterRows + 2) / 2 - 1;
        int filterColMiddle = (filterCols + 2) / 2 - 1;
        double[][] filter = aFilter.getArrayYX();
        int imageRows = aImg.numRows();
        int imageCols = aImg.numCols();
        double[][] image = aImg.getArrayYX();
        for (int r = 0; r < imageRows; ++r) {
            for (int c = 0; c < imageCols; ++c) {
                double sum = 0.0;
                for (int fr = 0; fr < filterRows; ++fr) {
                    for (int fc = 0; fc < filterCols; ++fc) {
                        int imr = r + filterRowMiddle - fr;
                        int imc = c + filterColMiddle - fc;
                        double imgVal = 0.0;
                        if (imr >= 0 && imr < imageRows && imc >= 0 && imc < imageCols) {
                            imgVal = image[imr][imc];
                        }
                        sum += imgVal * filter[fr][fc];
                    }
                }
                result.set(r, c, sum);
            }
        }
        return result;
    }

    public static Matrix imresize(Matrix aM, double scale) {
        int w = aM.numCols();
        int h = aM.numRows();
        int nw = (int)Math.ceil((double)w * scale);
        int nh = (int)Math.ceil((double)h * scale);
        return Matlab.imresize(aM, nw, nh);
    }

    public static Matrix imresize(Matrix aM, int aNewWidth, int aNewHeight) {
        Matrix result = null;
        if (aM.numCols() != aNewWidth || aM.numRows() != aNewHeight) {
            double[][] output = Interpolation.resize(aM.getArrayYX(), aNewHeight, aNewWidth, Interpolation.InterpolationType.BICUBIC, Interpolation.InterpolationMode.MATLAB);
            result = new Matrix(output);
        } else {
            result = aM.copy();
        }
        return result;
    }

    public static Map<Integer, List<Integer>> bwconncomp(Matrix aInputImg, boolean aIs8connected) {
        double[][] img = aInputImg.getArrayXY();
        int width = img.length;
        int height = img[0].length;
        int labelIndex = 2;
        HashMap<Integer, List<Integer>> connectedComponents = new HashMap<Integer, List<Integer>>();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (img[x][y] != 1.0) continue;
                connectedComponents.put(labelIndex, Matlab.findAllElementsOfObject(img, x, y, width, height, labelIndex, aIs8connected));
                ++labelIndex;
            }
        }
        return connectedComponents;
    }

    private static List<Integer> findAllElementsOfObject(double[][] aM, int aStartXpoint, int aStartYpoint, int aWidth, int aHeight, int aLabel, boolean aIs8connected) {
        ArrayList<Integer> elements = new ArrayList<Integer>();
        ArrayList<Integer> q = new ArrayList<Integer>();
        q.add(aStartXpoint * aHeight + aStartYpoint);
        while (!q.isEmpty()) {
            int id = (Integer)q.remove(0);
            int x = id / aHeight;
            int y = id % aHeight;
            aM[x][y] = aLabel;
            elements.add(id);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    int idx;
                    if (dx == 0 && dy == 0) continue;
                    int indX = x + dx;
                    int indY = y + dy;
                    if (indX < 0 || indX >= aWidth || indY < 0 || indY >= aHeight || !aIs8connected && dy * dx != 0 || aM[indX][indY] != 1.0 || q.contains(idx = indX * aHeight + indY)) continue;
                    q.add(idx);
                }
            }
        }
        return elements;
    }

    public static Matrix logical(Matrix aMatrix, final double aTreshold) {
        Matrix result = aMatrix.copy().process(new Matrix.MFunc(){

            @Override
            public double f(double aElement, int aRow, int aCol) {
                return aElement > aTreshold ? 1.0 : 0.0;
            }
        });
        return result;
    }
}

