/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.math.generalizedLinearModel;

import mosaic.utils.math.Matrix;
import mosaic.utils.math.generalizedLinearModel.Glm;

public class GlmPoisson
implements Glm {
    @Override
    public Matrix link(Matrix aX) {
        return aX.copy();
    }

    @Override
    public double linkDerivative(Matrix aX) {
        return 1.0;
    }

    @Override
    public Matrix linkInverse(Matrix aX) {
        return aX.copy();
    }

    @Override
    public Matrix varFunction(Matrix aX) {
        return aX.copy();
    }

    @Override
    public double nllMean(Matrix aImage, Matrix aMu, Matrix aWeights) {
        Matrix denominator = new Matrix(aMu).add(Math.ulp(1.0));
        Matrix temp = new Matrix(aImage).add(Math.ulp(1.0)).elementDiv(denominator);
        temp.process(new Matrix.MFunc(){

            @Override
            public double f(double aElement, int aRow, int aCol) {
                return aElement > 0.0 ? aElement : 1.0;
            }
        });
        Matrix nll = temp.log();
        nll.elementMult(aImage).add(aMu).sub(aImage).elementMult(aWeights);
        return nll.sum();
    }

    @Override
    public Matrix priorWeights(Matrix aImage) {
        return new Matrix(aImage.numRows(), aImage.numCols()).ones();
    }
}

