/*
 * Decompiled with CFR 0.152.
 */
package mosaic.variationalCurvatureFilters;

import mosaic.variationalCurvatureFilters.CurvatureFilter;
import mosaic.variationalCurvatureFilters.FilterKernel;

public class NoSplitFilter
implements CurvatureFilter {
    private final FilterKernel iFk;

    public NoSplitFilter(FilterKernel aFilterKernel) {
        this.iFk = aFilterKernel;
    }

    @Override
    public void runFilter(float[][] aImg, int aNumOfIterations) {
        int M = aImg.length - 1;
        int N = aImg[0].length - 1;
        for (int it = 0; it < aNumOfIterations; ++it) {
            for (int seq = 0; seq <= 3; ++seq) {
                int row;
                int col = seq / 2 + 1;
                for (int i = row = seq % 2 + 1; i < M; i += 2) {
                    float[] pPreviousRow = aImg[i - 1];
                    float[] pCurrentRow = aImg[i];
                    float[] pNextRow = aImg[i + 1];
                    for (int j = col; j < N; j += 2) {
                        float m = pCurrentRow[j];
                        float u = pPreviousRow[j];
                        float d = pNextRow[j];
                        float l = pCurrentRow[j - 1];
                        float r = pCurrentRow[j + 1];
                        float ld = pNextRow[j - 1];
                        float rd = pNextRow[j + 1];
                        float lu = pPreviousRow[j - 1];
                        float ru = pPreviousRow[j + 1];
                        int n = j;
                        pCurrentRow[n] = pCurrentRow[n] + this.iFk.filterKernel(lu, u, ru, l, m, r, ld, d, rd);
                    }
                }
            }
        }
    }

    @Override
    public void runFilter(float[][] aImg, int aNumOfIterations, CurvatureFilter.Mask aMask) {
        int M = aImg.length - 1;
        int N = aImg[0].length - 1;
        for (int it = 0; it < aNumOfIterations; ++it) {
            for (int seq = 0; seq <= 3; ++seq) {
                int row;
                int col = seq / 2 + 1;
                for (int i = row = seq % 2 + 1; i < M; i += 2) {
                    float[] pPreviousRow = aImg[i - 1];
                    float[] pCurrentRow = aImg[i];
                    float[] pNextRow = aImg[i + 1];
                    for (int j = col; j < N; j += 2) {
                        if (!aMask.shouldBeProcessed(j, i)) continue;
                        float m = pCurrentRow[j];
                        float u = pPreviousRow[j];
                        float d = pNextRow[j];
                        float l = pCurrentRow[j - 1];
                        float r = pCurrentRow[j + 1];
                        float ld = pNextRow[j - 1];
                        float rd = pNextRow[j + 1];
                        float lu = pPreviousRow[j - 1];
                        float ru = pPreviousRow[j + 1];
                        int n = j;
                        pCurrentRow[n] = pCurrentRow[n] + this.iFk.filterKernel(lu, u, ru, l, m, r, ld, d, rd);
                    }
                }
            }
        }
    }
}

