/*
 * Decompiled with CFR 0.152.
 */
package mosaic.variationalCurvatureFilters;

import mosaic.variationalCurvatureFilters.CurvatureFilter;
import mosaic.variationalCurvatureFilters.FilterKernel;

public class SplitFilter
implements CurvatureFilter {
    private int originalWidth;
    private int originalHeight;
    private int roundedWidth;
    private int roundedHeight;
    private int halfWidth;
    private int halfHeight;
    private final FilterKernel iFk;

    public SplitFilter(FilterKernel aFk) {
        this.iFk = aFk;
    }

    @Override
    public void runFilter(float[][] aImg, int aNumOfIterations) {
        this.originalWidth = aImg[0].length;
        this.originalHeight = aImg.length;
        this.roundedWidth = (int)(Math.ceil((double)this.originalWidth / 2.0) * 2.0);
        this.roundedHeight = (int)(Math.ceil((double)this.originalHeight / 2.0) * 2.0);
        this.halfWidth = this.roundedWidth / 2;
        this.halfHeight = this.roundedHeight / 2;
        float[][] WC = new float[this.halfHeight][this.halfWidth];
        float[][] WT = new float[this.halfHeight][this.halfWidth];
        float[][] BC = new float[this.halfHeight][this.halfWidth];
        float[][] BT = new float[this.halfHeight][this.halfWidth];
        this.splitImage(aImg, WC, WT, BC, BT);
        this.runFilter(WC, WT, BC, BT, aNumOfIterations);
        this.mergeImage(aImg, WC, WT, BC, BT);
    }

    @Override
    public void runFilter(float[][] aImg, int aNumOfIterations, CurvatureFilter.Mask aMask) {
        throw new RuntimeException("Split filter cannot be used with mask.");
    }

    private void splitImage(float[][] aConvertedImg, float[][] WC, float[][] WT, float[][] BC, float[][] BT) {
        for (int x = 0; x < this.roundedWidth; ++x) {
            for (int y = 0; y < this.roundedHeight; ++y) {
                int yIdx = y;
                int xIdx = x;
                if (yIdx >= this.originalHeight) {
                    yIdx = this.originalHeight - 1;
                }
                if (xIdx >= this.originalWidth) {
                    xIdx = this.originalWidth - 1;
                }
                if (x % 2 == 0 && y % 2 == 0) {
                    BT[y / 2][x / 2] = aConvertedImg[yIdx][xIdx];
                    continue;
                }
                if (x % 2 == 1 && y % 2 == 0) {
                    WT[y / 2][x / 2] = aConvertedImg[yIdx][xIdx];
                    continue;
                }
                if (x % 2 == 0 && y % 2 == 1) {
                    WC[y / 2][x / 2] = aConvertedImg[yIdx][xIdx];
                    continue;
                }
                if (x % 2 != 1 || y % 2 != 1) continue;
                BC[y / 2][x / 2] = aConvertedImg[yIdx][xIdx];
            }
        }
    }

    private void mergeImage(float[][] aOutputImg, float[][] WC, float[][] WT, float[][] BC, float[][] BT) {
        for (int x = 0; x < this.originalWidth; ++x) {
            for (int y = 0; y < this.originalHeight; ++y) {
                if (x % 2 == 0 && y % 2 == 0) {
                    aOutputImg[y][x] = BT[y / 2][x / 2];
                    continue;
                }
                if (x % 2 == 1 && y % 2 == 0) {
                    aOutputImg[y][x] = WT[y / 2][x / 2];
                    continue;
                }
                if (x % 2 == 0 && y % 2 == 1) {
                    aOutputImg[y][x] = WC[y / 2][x / 2];
                    continue;
                }
                if (x % 2 != 1 || y % 2 != 1) continue;
                aOutputImg[y][x] = BC[y / 2][x / 2];
            }
        }
    }

    private void runFilter(float[][] WC, float[][] WT, float[][] BC, float[][] BT, int aNumOfIterations) {
        for (int i = 0; i < aNumOfIterations; ++i) {
            int y;
            for (y = 0; y < this.halfHeight - 1; ++y) {
                this.processOneImageLine(BC[y], WC[y], WT[y + 1], BT[y + 1], WT[y], BT[y], true);
            }
            for (y = 1; y < this.originalHeight / 2; ++y) {
                this.processOneImageLine(WT[y], BT[y], BC[y], WC[y], BC[y - 1], WC[y - 1], true);
            }
            for (y = 0; y < this.halfHeight - 1; ++y) {
                this.processOneImageLine(WC[y], BC[y], BT[y + 1], WT[y + 1], BT[y], WT[y], false);
            }
            for (y = 1; y < this.originalHeight / 2; ++y) {
                this.processOneImageLine(BT[y], WT[y], WC[y], BC[y], WC[y - 1], BC[y - 1], false);
            }
        }
    }

    private void processOneImageLine(float[] aMiddle, float[] aSides, float[] aDown, float[] aDownCorners, float[] aUp, float[] aUpCorners, boolean aShifted) {
        int endIdx = (this.originalWidth - (aShifted ? 1 : 0)) / 2 - 1;
        int startIdx = 2 + (aShifted ? -1 : 0);
        int rightIdx = (startIdx + 1) / 2;
        int leftIdx = rightIdx - 1;
        int middleIdx = startIdx / 2;
        for (int j = startIdx / 2; j <= endIdx; ++j) {
            float m = aMiddle[middleIdx];
            float u = aUp[middleIdx];
            float d = aDown[middleIdx];
            float l = aSides[leftIdx];
            float r = aSides[rightIdx];
            float ld = aDownCorners[leftIdx];
            float rd = aDownCorners[rightIdx];
            float lu = aUpCorners[leftIdx];
            float ru = aUpCorners[rightIdx];
            int n = middleIdx++;
            aMiddle[n] = aMiddle[n] + this.iFk.filterKernel(lu, u, ru, l, m, r, ld, d, rd);
            ++rightIdx;
            ++leftIdx;
        }
    }
}

