/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mosaic.bregman.segmentation.Pix;
import mosaic.bregman.segmentation.Region;

public class ColocalizationAnalysis {
    private int iScaleX;
    private int iScaleY;
    private int iScaleZ;

    ColocalizationAnalysis(int aScaleZ, int aScaleX, int aScaleY) {
        this.iScaleX = aScaleX;
        this.iScaleY = aScaleY;
        this.iScaleZ = aScaleZ;
    }

    Map<ChannelPair, ColocResult> calculateAll(List<ChannelPair> aChannelPairs, List<List<Region>> aRegions, short[][][][] aLabeledRegions, double[][][][] aNormalizedImages) {
        HashMap<ChannelPair, ColocResult> results = new HashMap<ChannelPair, ColocResult>();
        for (ChannelPair cp : aChannelPairs) {
            ColocResult channelColoc = this.calculateChannelColoc(aRegions.get(cp.ch1), aRegions.get(cp.ch2), aLabeledRegions[cp.ch2], aNormalizedImages[cp.ch2]);
            results.put(cp, channelColoc);
        }
        return results;
    }

    private RegionColoc regionColocData(Region a1stRegion, List<Region> a2ndRegion, short[][][] a2ndLabeledRegions, double[][][] a2ndRegionImage) {
        int colocCount = 0;
        short previousColocLabel = 0;
        boolean singleRegionColoc = true;
        double intensityColoc = 0.0;
        double sizeColoc = 0.0;
        double sum = 0.0;
        for (Pix p : a1stRegion.iPixels) {
            Region region2;
            sum += a2ndRegionImage[p.pz / this.iScaleZ][p.px / this.iScaleX][p.py / this.iScaleY];
            short label = a2ndLabeledRegions[p.pz][p.px][p.py];
            if (label <= 0) continue;
            ++colocCount;
            if (previousColocLabel != 0 && label != previousColocLabel) {
                singleRegionColoc = false;
            }
            if (a2ndRegion == null || a2ndRegion.size() < label || (region2 = a2ndRegion.get(label - 1)) == null) continue;
            intensityColoc += region2.intensity;
            sizeColoc += (double)region2.realSize;
            previousColocLabel = label;
        }
        int count = a1stRegion.iPixels.size();
        RegionColoc regionColoc = new RegionColoc();
        regionColoc.colocObjectIntensity = sum / (double)count;
        regionColoc.overlapFactor = (float)colocCount / (float)count;
        regionColoc.singleRegionColoc = singleRegionColoc;
        if (colocCount != 0) {
            regionColoc.colocObjectsAverageArea = (float)(sizeColoc / (double)colocCount);
            regionColoc.colocObjectsAverageIntensity = (float)intensityColoc / (float)colocCount;
        }
        return regionColoc;
    }

    private ColocResult calculateChannelColoc(List<Region> aRegions1, List<Region> aRegions2, short[][][] aLabeledRegions2, double[][][] aImageRegions2) {
        float ColocThreshold = 0.5f;
        int objectsCount = aRegions1.size();
        double totalsignal = 0.0;
        double colocsignal = 0.0;
        double totalsize = 0.0;
        double colocsize = 0.0;
        double sum = 0.0;
        double objectscoloc = 0.0;
        TreeMap<Integer, RegionColoc> regionColocs = new TreeMap<Integer, RegionColoc>();
        for (Region r : aRegions1) {
            RegionColoc regionColoc = this.regionColocData(r, aRegions2, aLabeledRegions2, aImageRegions2);
            regionColocs.put(r.iLabel, regionColoc);
            colocsignal += (double)r.realSize * r.intensity * (double)regionColoc.overlapFactor;
            totalsignal += (double)r.realSize * r.intensity;
            colocsize += (double)(r.realSize * regionColoc.overlapFactor);
            totalsize += (double)r.realSize;
            sum += regionColoc.colocObjectIntensity;
            if (!(regionColoc.overlapFactor > 0.5f)) continue;
            objectscoloc += 1.0;
        }
        ChannelColoc channelColoc = new ChannelColoc();
        channelColoc.colocSignal = colocsignal / totalsignal;
        channelColoc.colocNumber = objectscoloc / (double)objectsCount;
        channelColoc.colocSize = colocsize / totalsize;
        channelColoc.coloc = sum / (double)objectsCount;
        ColocResult colRes = new ColocResult();
        colRes.channelColoc = channelColoc;
        colRes.regionsColoc = regionColocs;
        return colRes;
    }

    public static class ChannelPair {
        int ch1;
        int ch2;

        ChannelPair(int aCh1, int aCh2) {
            this.ch1 = aCh1;
            this.ch2 = aCh2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.ch1;
            result = 31 * result + this.ch2;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChannelPair other = (ChannelPair)obj;
            if (this.ch1 != other.ch1) {
                return false;
            }
            return this.ch2 == other.ch2;
        }

        public String toString() {
            return "{" + this.ch1 + ", " + this.ch2 + "}";
        }
    }

    class ColocResult {
        Map<Integer, RegionColoc> regionsColoc;
        ChannelColoc channelColoc;

        ColocResult() {
        }

        public String toString() {
            return "" + this.regionsColoc + "\n" + this.channelColoc + "\n";
        }
    }

    class RegionColoc {
        public float overlapFactor = 0.0f;
        public float colocObjectsAverageArea = 0.0f;
        public float colocObjectsAverageIntensity = 0.0f;
        public double colocObjectIntensity = 0.0;
        public boolean singleRegionColoc = false;

        RegionColoc() {
        }

        public String toString() {
            return "[" + this.overlapFactor + ", " + this.colocObjectsAverageArea + ", " + this.colocObjectsAverageIntensity + ", " + this.colocObjectIntensity + ", " + this.singleRegionColoc + "]";
        }
    }

    class ChannelColoc {
        double colocSignal;
        double colocNumber;
        double colocSize;
        double coloc;

        ChannelColoc() {
        }

        public String toString() {
            return "[" + this.colocSignal + ", " + this.colocNumber + ", " + this.colocSize + ", " + this.coloc + "]";
        }
    }
}

