/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.GUI;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import java.awt.Checkbox;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mosaic.bregman.Mask;
import mosaic.bregman.Parameters;
import mosaic.utils.ArrayOps;
import mosaic.utils.ImgUtils;

class ColocalizationGUI
implements ItemListener,
ChangeListener,
TextListener {
    private ImagePlus imgch1;
    private ImagePlus imgch2;
    private JSlider t1;
    private JSlider t2;
    private JSlider tz1;
    private JSlider tz2;
    private JLabel l1;
    private JLabel lz1;
    private JLabel l2;
    private JLabel lz2;
    private TextField v1;
    private TextField v2;
    private Checkbox m1;
    private Checkbox m2;
    private boolean init1 = false;
    private boolean init2 = false;
    private ImagePlus maska_im1;
    private ImagePlus maska_im2;
    private double max = 0.0;
    private double min = Double.POSITIVE_INFINITY;
    private double max2 = 0.0;
    private double min2 = Double.POSITIVE_INFINITY;
    private double val1;
    private double val2;
    private boolean fieldval = false;
    private boolean sliderval = false;
    private boolean boxval = false;
    private boolean refreshing = false;
    private final double minrange = 0.001;
    private final double maxrange = 1.0;
    private final double logmin = Math.log10(0.001);
    private final double logspan = Math.log10(1.0) - Math.log10(0.001);
    private final int maxslider = 1000;
    private final JLabel warning = new JLabel("");
    private int ns1;
    private int ns2;
    private final Parameters iParameters;

    ColocalizationGUI(ImagePlus ch1, ImagePlus ch2, Parameters aParameters) {
        this.imgch1 = ch1;
        this.imgch2 = ch2;
        this.iParameters = aParameters;
    }

    public void run() {
        int nslices;
        Font bf = new Font(null, 1, 12);
        GenericDialog gd = new GenericDialog("Cell masks");
        gd.setInsets(-10, 0, 3);
        gd.addMessage("Cell masks (two channels images)", bf);
        String[] sgroup3 = new String[]{"Cell_mask_channel_1", "Cell_mask_channel_2"};
        boolean[] bgroup3 = new boolean[]{false, false};
        bgroup3[0] = this.iParameters.usecellmaskX;
        bgroup3[1] = this.iParameters.usecellmaskY;
        this.t1 = new JSlider();
        this.t2 = new JSlider();
        this.tz1 = new JSlider();
        this.tz2 = new JSlider();
        this.l1 = new JLabel("threshold value   ");
        this.l2 = new JLabel("threshold value   ");
        this.lz1 = new JLabel("z position preview");
        this.lz2 = new JLabel("z position preview");
        gd.addCheckboxGroup(1, 2, sgroup3, bgroup3);
        gd.addNumericField("Threshold_channel_1 (0 to 1)", this.iParameters.thresholdcellmask, 4);
        Panel p1 = new Panel();
        p1.add(this.l1);
        p1.add(this.t1);
        gd.addPanel(p1);
        Panel pz1 = new Panel();
        pz1.add(this.lz1);
        pz1.add(this.tz1);
        gd.addPanel(pz1);
        gd.addNumericField("Threshold_channel_2 (0 to 1)", this.iParameters.thresholdcellmasky, 4);
        Panel p2 = new Panel();
        p2.add(this.l2);
        p2.add(this.t2);
        gd.addPanel(p2);
        Panel pz2 = new Panel();
        pz2.add(this.lz2);
        pz2.add(this.tz2);
        gd.addPanel(pz2);
        this.v1 = (TextField)gd.getNumericFields().elementAt(0);
        this.v2 = (TextField)gd.getNumericFields().elementAt(1);
        this.m1 = (Checkbox)gd.getCheckboxes().elementAt(0);
        this.m2 = (Checkbox)gd.getCheckboxes().elementAt(1);
        this.t1.addChangeListener(this);
        this.t2.addChangeListener(this);
        this.v1.addTextListener(this);
        this.v2.addTextListener(this);
        this.m1.addItemListener(this);
        this.m2.addItemListener(this);
        this.t1.setMinimum(0);
        this.t1.setMaximum(1000);
        this.t2.setMinimum(0);
        this.t2.setMaximum(1000);
        this.t1.setValue((int)this.logvalue(this.iParameters.thresholdcellmask));
        this.t2.setValue((int)this.logvalue(this.iParameters.thresholdcellmasky));
        this.val1 = new Double(this.v1.getText());
        this.val2 = new Double(this.v2.getText());
        if (this.imgch1 != null) {
            nslices = this.imgch1.getNSlices();
            if (nslices > 1) {
                this.ns1 = this.imgch1.getSlice();
                this.tz1.setMinimum(1);
                this.tz1.setMaximum(nslices);
                this.tz1.setValue(1);
                this.tz1.addChangeListener(this);
            } else {
                this.tz1.setEnabled(false);
            }
        } else {
            this.tz1.setEnabled(false);
        }
        if (this.imgch2 != null) {
            nslices = this.imgch2.getNSlices();
            if (nslices > 1) {
                this.ns2 = this.imgch2.getSlice();
                this.tz2.setMinimum(1);
                this.tz2.setMaximum(nslices);
                this.tz2.setValue(1);
                this.tz2.addChangeListener(this);
            } else {
                this.tz2.setEnabled(false);
            }
        } else {
            this.tz2.setEnabled(false);
        }
        if (this.iParameters.usecellmaskX && this.imgch1 != null) {
            this.maska_im1 = new ImagePlus();
            this.initpreviewch1(this.imgch1);
            this.previewBinaryCellMask(new Double(this.v1.getText()), this.imgch1, this.maska_im1, 1);
            this.init1 = true;
        }
        if (this.iParameters.usecellmaskY && this.imgch2 != null) {
            this.maska_im2 = new ImagePlus();
            this.initpreviewch2(this.imgch2);
            this.previewBinaryCellMask(new Double(this.v2.getText()), this.imgch2, this.maska_im2, 2);
            this.init2 = true;
        }
        gd.showDialog();
        if (this.maska_im1 != null) {
            this.maska_im1.close();
        }
        if (this.maska_im2 != null) {
            this.maska_im2.close();
        }
        if (this.imgch1 != null) {
            this.imgch1.setSlice(this.ns1);
            this.imgch1 = null;
        }
        if (this.imgch2 != null) {
            this.imgch2.setSlice(this.ns2);
            this.imgch2 = null;
        }
        if (gd.wasCanceled()) {
            return;
        }
        this.iParameters.usecellmaskX = gd.getNextBoolean();
        this.iParameters.usecellmaskY = gd.getNextBoolean();
        this.iParameters.thresholdcellmask = gd.getNextNumber();
        this.iParameters.thresholdcellmasky = gd.getNextNumber();
    }

    private double expvalue(double slidervalue) {
        return Math.pow(10.0, slidervalue / 1000.0 * this.logspan + this.logmin);
    }

    private double logvalue(double tvalue) {
        return 1000.0 * (Math.log10(tvalue) - this.logmin) / this.logspan;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean b;
        Object source = e.getSource();
        this.boxval = true;
        if (source == this.m1) {
            b = this.m1.getState();
            if (b) {
                if (this.imgch1 != null) {
                    if (this.maska_im1 == null) {
                        this.maska_im1 = new ImagePlus();
                    }
                    this.initpreviewch1(this.imgch1);
                    this.previewBinaryCellMask(new Double(this.v1.getText()), this.imgch1, this.maska_im1, 1);
                    this.init1 = true;
                } else {
                    this.warning.setText("Please open an image first.");
                }
            } else {
                if (this.maska_im1 != null) {
                    this.maska_im1.hide();
                }
                this.init1 = false;
            }
        }
        if (source == this.m2) {
            b = this.m2.getState();
            if (b) {
                if (this.imgch2 != null) {
                    if (this.maska_im2 == null) {
                        this.maska_im2 = new ImagePlus();
                    }
                    this.initpreviewch2(this.imgch2);
                    this.previewBinaryCellMask(new Double(this.v2.getText()), this.imgch2, this.maska_im2, 2);
                    this.init2 = true;
                } else {
                    this.warning.setText("Please open an image with two channels first.");
                }
            } else {
                if (this.maska_im2 != null) {
                    this.maska_im2.hide();
                }
                this.init2 = false;
            }
        }
        this.boxval = false;
    }

    @Override
    public void textValueChanged(TextEvent e) {
        Object source = e.getSource();
        if (!this.boxval && !this.sliderval) {
            this.fieldval = true;
            if (source == this.v1 && this.init1) {
                double v = new Double(this.v1.getText());
                if (!this.sliderval && this.val1 != v && !this.refreshing) {
                    this.val1 = v;
                    this.previewBinaryCellMask(v, this.imgch1, this.maska_im1, 1);
                    int vv = (int)this.logvalue(v);
                    this.t1.setValue(vv);
                }
            } else if (source == this.v2 && this.init2) {
                double v = new Double(this.v2.getText());
                if (!this.sliderval && this.val2 != v && !this.refreshing) {
                    this.val2 = v;
                    this.previewBinaryCellMask(v, this.imgch2, this.maska_im2, 2);
                    int vv = (int)this.logvalue(v);
                    this.t2.setValue(vv);
                }
            } else if (source == this.v1 && !this.init1) {
                double v = new Double(this.v1.getText());
                if (!this.sliderval) {
                    int vv = (int)this.logvalue(v);
                    this.t1.setValue(vv);
                }
            } else if (source == this.v2 && !this.init2) {
                double v = new Double(this.v2.getText());
                if (!this.sliderval) {
                    int vv = (int)this.logvalue(v);
                    this.t2.setValue(vv);
                }
            }
            this.fieldval = false;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object origin = e.getSource();
        if (origin == this.tz1 && this.maska_im1 != null) {
            this.maska_im1.setZ(this.tz1.getValue());
            this.imgch1.setZ(this.tz1.getValue());
            return;
        }
        if (origin == this.tz2 && this.maska_im2 != null) {
            this.maska_im2.setZ(this.tz2.getValue());
            this.imgch2.setZ(this.tz2.getValue());
            return;
        }
        if (!this.boxval && !this.fieldval) {
            double vv;
            double value;
            this.sliderval = true;
            if (origin == this.t1 && this.init1 && !this.t1.getValueIsAdjusting()) {
                value = this.t1.getValue();
                vv = this.expvalue(value);
                if (!this.fieldval && this.val1 != vv) {
                    this.v1.setText(String.format(Locale.US, "%.4f", vv));
                    this.val1 = vv;
                    this.previewBinaryCellMask(vv, this.imgch1, this.maska_im1, 1);
                }
                this.refreshing = false;
            }
            if (origin == this.t1 && this.init1 && this.t1.getValueIsAdjusting() || origin == this.t1 && !this.init1) {
                value = this.t1.getValue();
                vv = this.expvalue(value);
                if (!this.fieldval) {
                    this.v1.setText(String.format(Locale.US, "%.4f", vv));
                }
                this.refreshing = true;
            }
            if (origin == this.t2 && this.init2 && !this.t2.getValueIsAdjusting()) {
                value = this.t2.getValue();
                vv = this.expvalue(value);
                if (!this.fieldval && this.val2 != vv) {
                    this.v2.setText(String.format(Locale.US, "%.4f", vv));
                    this.previewBinaryCellMask(vv, this.imgch2, this.maska_im2, 2);
                    this.val2 = vv;
                }
                this.refreshing = false;
            }
            if (origin == this.t2 && this.init2 && this.t2.getValueIsAdjusting() || origin == this.t2 && !this.init2) {
                value = this.t2.getValue();
                vv = this.expvalue(value);
                if (!this.fieldval) {
                    this.v2.setText(String.format(Locale.US, "%.4f", vv));
                }
                this.refreshing = true;
            }
            this.sliderval = false;
        }
    }

    private void initpreviewch1(ImagePlus img) {
        ArrayOps.MinMax<Double> mm = ImgUtils.findMinMax(img);
        this.min = mm.getMin();
        this.max = mm.getMax();
    }

    private void initpreviewch2(ImagePlus img) {
        ArrayOps.MinMax<Double> mm = ImgUtils.findMinMax(img);
        this.max2 = mm.getMax();
        this.min2 = mm.getMin();
    }

    private void previewBinaryCellMask(double threshold_i, ImagePlus img, ImagePlus maska_im, int channel) {
        int currentSlice = img.getSlice();
        double threshold = threshold_i * (channel == 1 ? this.max - this.min + this.min : this.max2 - this.min2 + this.min2);
        ImagePlus mask = Mask.createBinaryCellMask(img, "Cell mask channel " + channel, threshold);
        maska_im.setStack(mask.getStack());
        maska_im.setTitle(mask.getTitle());
        maska_im.updateAndDraw();
        maska_im.show();
        img.setSlice(currentSlice);
    }
}

