/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.GUI;

import mosaic.utils.math.MathOps;

class GaussianPSFModel {
    private final double NA;
    private final double r;
    private final double n;
    private final double kem;
    private final double c1;
    private final double c2;

    GaussianPSFModel(double vlem, double vlex, double vna, double vr, double vn) {
        this.NA = vna;
        double lex = vlex / 1000.0;
        double airy_unit = 1.22 * lex / this.NA;
        this.r = vr * airy_unit;
        double kex = Math.PI * 2 / lex;
        this.c1 = kex * this.r * this.NA;
        double lem = vlem / 1000.0;
        this.kem = Math.PI * 2 / lem;
        this.c2 = this.kem * this.r * this.NA;
        this.n = vn;
    }

    double lateral_WFFM() {
        return Math.sqrt(2.0) / (this.kem * this.NA);
    }

    double axial_WFFM() {
        return 2.0 * Math.sqrt(6.0) * this.n / (this.kem * Math.pow(this.NA, 2.0));
    }

    double lateral_LSCM() {
        double num = 4.0 * this.c2 * MathOps.bessel0(this.c2) * MathOps.bessel1(this.c2) - 8.0 * Math.pow(MathOps.bessel1(this.c2), 2.0);
        double den = Math.pow(this.r, 2.0) * (Math.pow(MathOps.bessel0(this.c2), 2.0) + Math.pow(MathOps.bessel1(this.c2), 2.0) - 1.0);
        return Math.sqrt(2.0) / Math.sqrt(this.c1 * this.c1 / (this.r * this.r) + num / den);
    }

    double axial_LSCM() {
        double num = 48.0 * this.c2 * this.c2 * (Math.pow(MathOps.bessel0(this.c2), 2.0) + Math.pow(MathOps.bessel1(this.c2), 2.0)) - 192.0 * Math.pow(MathOps.bessel1(this.c2), 2.0);
        double den = Math.pow(this.n, 2.0) * Math.pow(this.kem, 2.0) * Math.pow(this.r, 4.0) * (Math.pow(MathOps.bessel0(this.c2), 2.0) + Math.pow(MathOps.bessel1(this.c2), 2.0) - 1.0);
        return 2.0 * Math.sqrt(6.0) / Math.sqrt(this.c1 * this.c1 * this.NA * this.NA / (this.r * this.r * this.n * this.n) - num / den);
    }
}

