/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mosaic.bregman.segmentation.Pix;
import mosaic.bregman.segmentation.Region;
import mosaic.utils.ArrayOps;
import mosaic.utils.ImgUtils;
import org.apache.log4j.Logger;

public class Mask {
    private static final Logger logger = Logger.getLogger(Mask.class);
    private double iGlobalMin;
    private double iGlobalMax;
    private Map<Integer, boolean[][][]> iCellMasks;
    private boolean[][][] iOoverallCellMask;

    public Mask(double aGlobalMin, double aGlobalMax) {
        this.iGlobalMin = aGlobalMin;
        this.iGlobalMax = aGlobalMax;
        this.iCellMasks = new HashMap<Integer, boolean[][][]>();
    }

    void generateMasks(int aChannel, ImagePlus aImage, double aThreshold) {
        logger.info((Object)("Generating mask for channel: " + aChannel));
        double minNorm = this.iGlobalMin;
        double maxNorm = this.iGlobalMax;
        if (this.iGlobalMax == 0.0) {
            ArrayOps.MinMax<Double> mm = ImgUtils.findMinMax(aImage);
            minNorm = mm.getMin();
            maxNorm = mm.getMax();
        }
        this.iCellMasks.put(aChannel, this.generateMask(aImage, minNorm, maxNorm, aThreshold));
    }

    private boolean[][][] generateMask(ImagePlus aImage, double aNormalizationMin, double aNormalizationMax, double aMaskThreshold) {
        ImagePlus mask = Mask.createBinaryCellMask(aImage, "Cell mask", aMaskThreshold * (aNormalizationMax - aNormalizationMin) + aNormalizationMin);
        return ImgUtils.imgToZXYbinaryArray(mask);
    }

    private void computeOverallMask(int nz, int ni, int nj) {
        this.iOoverallCellMask = new boolean[nz][ni][nj];
        for (int z = 0; z < nz; ++z) {
            for (int i = 0; i < ni; ++i) {
                for (int j = 0; j < nj; ++j) {
                    boolean value = true;
                    for (boolean[][][] mask : this.iCellMasks.values()) {
                        value = value && mask[z][i][j];
                    }
                    this.iOoverallCellMask[z][i][j] = value;
                }
            }
        }
    }

    List<List<Region>> applyMask(List<List<Region>> aInputRegions, int aScale, int nz, int ni, int nj) {
        this.computeOverallMask(nz, ni, nj);
        ArrayList<List<Region>> maskedRegionList = new ArrayList<List<Region>>();
        for (int channel = 0; channel < aInputRegions.size(); ++channel) {
            ArrayList<Region> maskedRegion = new ArrayList<Region>();
            for (Region r : aInputRegions.get(channel)) {
                if (!this.isInside(r, aScale)) continue;
                maskedRegion.add(r);
            }
            maskedRegionList.add(maskedRegion);
        }
        return maskedRegionList;
    }

    private boolean isInside(Region r, int aScale) {
        double InsideThreshold = 0.1;
        int factor2 = aScale;
        int fz2 = this.iOoverallCellMask.length > 1 ? factor2 : 1;
        double size = r.iPixels.size();
        int inside = 0;
        for (Pix px : r.iPixels) {
            if (!this.iOoverallCellMask[px.pz / fz2][px.px / factor2][px.py / factor2]) continue;
            ++inside;
        }
        return (double)inside / size > 0.1;
    }

    public static ImagePlus createBinaryCellMask(ImagePlus aInputImage, String aTitle, double aThreshold) {
        int ni = aInputImage.getWidth();
        int nj = aInputImage.getHeight();
        int nz = aInputImage.getNSlices();
        ImageStack maskStack = new ImageStack(ni, nj);
        for (int z = 0; z < nz; ++z) {
            aInputImage.setSlice(z + 1);
            ImageProcessor ip = aInputImage.getProcessor();
            byte[] mask = new byte[ni * nj];
            for (int i = 0; i < ni; ++i) {
                for (int j = 0; j < nj; ++j) {
                    if (!((double)ip.getPixelValue(i, j) > aThreshold)) continue;
                    mask[j * ni + i] = -1;
                }
            }
            ByteProcessor bp = new ByteProcessor(ni, nj);
            bp.setPixels((Object)mask);
            maskStack.addSlice("", (ImageProcessor)bp);
        }
        ImagePlus maskImg = new ImagePlus(aTitle, maskStack);
        IJ.run((ImagePlus)maskImg, (String)"Invert", (String)"stack");
        boolean tempBlackbackground = Prefs.blackBackground;
        Prefs.blackBackground = false;
        IJ.run((ImagePlus)maskImg, (String)"Fill Holes", (String)"stack");
        Prefs.blackBackground = tempBlackbackground;
        IJ.run((ImagePlus)maskImg, (String)"Open", (String)"stack");
        IJ.run((ImagePlus)maskImg, (String)"Invert", (String)"stack");
        maskImg.changes = false;
        return maskImg;
    }
}

