/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman;

import ij.IJ;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import mosaic.bregman.ColocalizationAnalysis;

public class RScript {
    public static final String ScriptName = "R_analysis.R";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeRScript(String path, String aObjectsDataFile, String aObjectsColocFile, String aImagesColocFile, List<ColocalizationAnalysis.ChannelPair> aChannelPairs, int[] ImagesPerGroup, String[] GroupNames, String Ch1Name, String Ch2Name) {
        try {
            int i;
            int i2;
            PrintWriter Script = new PrintWriter(path + File.separator + ScriptName);
            Script.println("#R_analysis v2.0");
            Script.println();
            Script.println("### Input parameters ##########################################################");
            Script.println();
            Script.println("# Input file names");
            Script.println("BaseDirecotry = \"" + path + "\"");
            Script.println("FileObjData = \"" + aObjectsDataFile + "\"");
            Script.println("FileObjColoc = \"" + aObjectsColocFile + "\"");
            Script.println("FileImgColoc = \"" + aImagesColocFile + "\"");
            Script.println();
            Script.println("# Group properties");
            Script.println("NumberOfGroups = " + GroupNames.length);
            Script.print("NumberImagesPerEachGroup = c(");
            Script.print("" + ImagesPerGroup[0]);
            for (i2 = 1; i2 < ImagesPerGroup.length; ++i2) {
                Script.print("," + ImagesPerGroup[i2]);
            }
            Script.println(")");
            Script.print("GroupNames = c(");
            Script.print("\"" + GroupNames[0] + "\"");
            for (i2 = 1; i2 < GroupNames.length; ++i2) {
                Script.print(",\"" + GroupNames[i2] + "\"");
            }
            Script.println(")");
            Script.println();
            List<ColocalizationAnalysis.ChannelPair> filteredPairs = RScript.filterChannelPairs(aChannelPairs);
            Script.println("# Channel properties");
            int numOfChannels = RScript.findNumOfChannels(filteredPairs);
            Script.println("NumberOfChannels = " + numOfChannels);
            Script.print("NamesOfChannels = c(");
            if (numOfChannels >= 1) {
                Script.print("\"" + Ch1Name + "\"");
            }
            if (numOfChannels >= 2) {
                Script.print(", \"" + Ch2Name + "\"");
            }
            for (i = 2; i < numOfChannels; ++i) {
                Script.print(", \"channel " + i + " name\"");
            }
            Script.println(")");
            Script.print("MinIntensitiesInChannels = c(");
            Script.print("0");
            for (i = 1; i < numOfChannels; ++i) {
                Script.print(", 0");
            }
            Script.println(")");
            Script.println();
            Script.print("ChannelPairs = list(");
            Script.print("c(" + filteredPairs.get((int)0).ch1 + "," + filteredPairs.get((int)0).ch2 + ")");
            for (i = 1; i < filteredPairs.size(); ++i) {
                Script.print(", c(" + filteredPairs.get((int)i).ch1 + "," + filteredPairs.get((int)i).ch2 + ")");
            }
            Script.println(")");
            Script.println();
            InputStream in = null;
            try {
                in = RScript.class.getClassLoader().getResourceAsStream("Rscript.r");
                if (in == null) {
                    IJ.log((String)"RSCRIPT generation has not succeed (cannot find Rscript.r resource)");
                }
                Scanner scanner = new Scanner(in);
                String content = scanner.useDelimiter("\\Z").next();
                Script.print(content);
                scanner.close();
            }
            catch (Exception e) {
                System.err.println("Error generating R Script " + e.getMessage());
            }
            finally {
                Script.close();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error creating R Script file " + e.getMessage());
        }
    }

    private static int findNumOfChannels(List<ColocalizationAnalysis.ChannelPair> aChannelPairs) {
        int max = 0;
        for (ColocalizationAnalysis.ChannelPair cp : aChannelPairs) {
            int tempMax = Math.max(cp.ch1, cp.ch2);
            if (tempMax <= max) continue;
            max = tempMax;
        }
        return max + 1;
    }

    private static List<ColocalizationAnalysis.ChannelPair> filterChannelPairs(List<ColocalizationAnalysis.ChannelPair> aChannelPairs) {
        ArrayList<ColocalizationAnalysis.ChannelPair> filteredPairs = new ArrayList<ColocalizationAnalysis.ChannelPair>();
        filteredPairs.addAll(aChannelPairs);
        for (ColocalizationAnalysis.ChannelPair cp : filteredPairs) {
            filteredPairs.remove(new ColocalizationAnalysis.ChannelPair(cp.ch2, cp.ch1));
        }
        return filteredPairs;
    }
}

