/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.segmentation;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import mosaic.bregman.segmentation.Pix;
import mosaic.bregman.segmentation.Region;

class FindConnectedRegions {
    private final ImagePlus iInputImg;
    private short[][][] iLabeledRegions;
    private final ArrayList<Region> iFoundRegions = new ArrayList();
    private static final byte IN_QUEUE = 1;
    private static final byte ADDED = 2;

    FindConnectedRegions(ImagePlus aInputImg) {
        this.iInputImg = aInputImg;
    }

    void run(int aMaximumPointsInRegion, int aMinimumPointsInRegion, float aMinThreshold, boolean exclude_z_edges, int oversampling2ndstep, int interpolation) {
        if (this.iInputImg == null) {
            IJ.error((String)"No image to operate on.");
            return;
        }
        if (0 != this.iInputImg.getType()) {
            IJ.error((String)"The image must be 8 bit");
            return;
        }
        int width = this.iInputImg.getWidth();
        int height = this.iInputImg.getHeight();
        int depth = this.iInputImg.getStackSize();
        this.iLabeledRegions = new short[depth][width][height];
        if (aMinimumPointsInRegion < 0) {
            aMinimumPointsInRegion = 0;
        }
        if (aMaximumPointsInRegion < 0) {
            aMaximumPointsInRegion = width * height * depth;
        }
        ImageStack stack = this.iInputImg.getStack();
        byte[][] sliceDataBytes = new byte[depth][];
        for (int z = 0; z < depth; ++z) {
            ByteProcessor bp = (ByteProcessor)stack.getProcessor(z + 1);
            sliceDataBytes[z] = (byte[])bp.getPixelsCopy();
        }
        int tag = 0;
        int queueArrayLength = 131072;
        int[] queue = new int[queueArrayLength];
        int pixelsCount = 0;
        while (pixelsCount < width * height * depth) {
            int initial_x = -1;
            int initial_y = -1;
            int initial_z = -1;
            int maxValueInt = -1;
            for (int z = 0; z < depth; ++z) {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int value = sliceDataBytes[z][y * width + x] & 0xFF;
                        if (value <= maxValueInt || !((float)value >= aMinThreshold)) continue;
                        initial_x = x;
                        initial_y = y;
                        initial_z = z;
                        maxValueInt = value;
                    }
                }
            }
            if (maxValueInt < 0) break;
            int pointsInQueue = 0;
            Arrays.fill(queue, 0);
            byte[] pointState = new byte[depth * width * height];
            int i = width * (initial_z * height + initial_y) + initial_x;
            pointState[i] = 1;
            queue[pointsInQueue++] = i;
            int pointsInThisRegion = 0;
            while (pointsInQueue > 0) {
                int nextIndex;
                int currentPointStateIndex = nextIndex = queue[--pointsInQueue];
                int pz = nextIndex / (width * height);
                int currentSliceIndex = nextIndex % (width * height);
                int py = currentSliceIndex / width;
                int px = currentSliceIndex % width;
                pointState[currentPointStateIndex] = 2;
                sliceDataBytes[pz][currentSliceIndex] = 0;
                ++pointsInThisRegion;
                int x_unchecked_min = px - 1;
                int y_unchecked_min = py - 1;
                int z_unchecked_min = pz - 1;
                int x_unchecked_max = px + 1;
                int y_unchecked_max = py + 1;
                int z_unchecked_max = pz + 1;
                int x_min = x_unchecked_min < 0 ? 0 : x_unchecked_min;
                int y_min = y_unchecked_min < 0 ? 0 : y_unchecked_min;
                int z_min = z_unchecked_min < 0 ? 0 : z_unchecked_min;
                int x_max = x_unchecked_max >= width ? width - 1 : x_unchecked_max;
                int y_max = y_unchecked_max >= height ? height - 1 : y_unchecked_max;
                int z_max = z_unchecked_max >= depth ? depth - 1 : z_unchecked_max;
                for (int z = z_min; z <= z_max; ++z) {
                    for (int y = y_min; y <= y_max; ++y) {
                        for (int x = x_min; x <= x_max; ++x) {
                            int newPointStateIndex;
                            int newSliceIndex;
                            int neighbourValue;
                            if (!(x != x_unchecked_min && x != x_unchecked_max || y != y_unchecked_min && y != y_unchecked_max) && (z == z_unchecked_min || z == z_unchecked_max) || (float)(neighbourValue = sliceDataBytes[z][newSliceIndex = y * width + x] & 0xFF) < aMinThreshold || 0 != pointState[newPointStateIndex = z * width * height + newSliceIndex]) continue;
                            pointState[newPointStateIndex] = 1;
                            if (pointsInQueue == queueArrayLength) {
                                int newArrayLength = queueArrayLength * 2;
                                int[] newArray = new int[newArrayLength];
                                System.arraycopy(queue, 0, newArray, 0, queueArrayLength);
                                queue = newArray;
                                queueArrayLength = newArrayLength;
                            }
                            queue[pointsInQueue++] = newPointStateIndex;
                        }
                    }
                }
            }
            pixelsCount += pointsInThisRegion;
            if (pointsInThisRegion < aMinimumPointsInRegion || pointsInThisRegion > aMaximumPointsInRegion) continue;
            ++tag;
            ArrayList<Pix> pixels = new ArrayList<Pix>(pointsInThisRegion);
            for (int z = 0; z < depth; ++z) {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        byte status = pointState[width * (z * height + y) + x];
                        if (status == 2) {
                            pixels.add(new Pix(z, x, y));
                            continue;
                        }
                        if (status != 1) continue;
                        IJ.log((String)("BUG: point " + x + "," + y + "," + z + " is still marked as IN_QUEUE"));
                    }
                }
            }
            Region region = new Region(tag, pixels);
            boolean regionAdded = false;
            if (exclude_z_edges && depth != 1) {
                int scale = oversampling2ndstep * interpolation;
                region.calculateRegionCenter(scale, scale);
                if (region.getcz() >= 1.0 && region.getcz() <= (double)(depth - 2)) {
                    this.iFoundRegions.add(region);
                    regionAdded = true;
                }
            } else {
                this.iFoundRegions.add(region);
                regionAdded = true;
            }
            if (!regionAdded) continue;
            for (Pix p : region.iPixels) {
                this.iLabeledRegions[p.pz][p.px][p.py] = (short)tag;
            }
        }
        Collections.sort(this.iFoundRegions, Collections.reverseOrder());
    }

    short[][][] getLabeledRegions() {
        return this.iLabeledRegions;
    }

    ArrayList<Region> getFoundRegions() {
        return this.iFoundRegions;
    }
}

