/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.segmentation;

import mosaic.utils.ArrayOps;

class RegionStatisticsSolver {
    private final double[][][] Z;
    private final double[][][] W;
    private final double[][][] mu;
    private final int iMaxIter;
    private final int ni;
    private final int nj;
    private final int nz;
    private final double iDefaultBetaMleOut;
    private final double iDefaultBetaMleIn;
    private final double[][][] iWeights;
    double betaMLEin;
    double betaMLEout;

    RegionStatisticsSolver(double[][][] temp1, double[][][] temp2, double[][][] image, double[][][] weights, int max_iter, double aDefaultBetaMleOut, double aDefaultBetaMleIn) {
        this.Z = image;
        this.W = temp1;
        this.mu = temp2;
        this.iMaxIter = max_iter;
        this.ni = image[0].length;
        this.nj = image[0][0].length;
        this.nz = image.length;
        this.iDefaultBetaMleOut = aDefaultBetaMleOut;
        this.iDefaultBetaMleIn = aDefaultBetaMleIn;
        if (weights == null) {
            this.iWeights = new double[this.nz][this.ni][this.nj];
            ArrayOps.fill(this.iWeights, 1.0);
        } else {
            this.iWeights = weights;
        }
    }

    void eval(double[][][] KMask) {
        this.betaMLEout = 0.0;
        this.betaMLEin = 0.0;
        for (int z = 0; z < this.nz; ++z) {
            for (int i = 0; i < this.ni; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    this.W[z][i][j] = this.Z[z][i][j] != 0.0 ? this.iWeights[z][i][j] / this.Z[z][i][j] : 4.50359962737E15;
                }
            }
        }
        int iter = 0;
        while (iter++ < this.iMaxIter) {
            int j;
            int z;
            double K11 = 0.0;
            double K12 = 0.0;
            double K22 = 0.0;
            double U1 = 0.0;
            double U2 = 0.0;
            for (int z2 = 0; z2 < this.nz; ++z2) {
                for (int i = 0; i < this.ni; ++i) {
                    for (int j2 = 0; j2 < this.nj; ++j2) {
                        double maskVal = KMask[z2][i][j2];
                        K11 += this.W[z2][i][j2] * Math.pow(1.0 - maskVal, 2.0);
                        K12 += this.W[z2][i][j2] * (1.0 - maskVal) * maskVal;
                        K22 += this.W[z2][i][j2] * maskVal * maskVal;
                        U1 += this.W[z2][i][j2] * (1.0 - maskVal) * this.Z[z2][i][j2];
                        U2 += this.W[z2][i][j2] * maskVal * this.Z[z2][i][j2];
                    }
                }
            }
            double detK = K11 * K22 - Math.pow(K12, 2.0);
            if (detK != 0.0) {
                this.betaMLEout = (K22 * U1 - K12 * U2) / detK;
                this.betaMLEin = (-K12 * U1 + K11 * U2) / detK;
            } else {
                this.betaMLEout = this.iDefaultBetaMleOut;
                this.betaMLEin = this.iDefaultBetaMleIn;
            }
            for (z = 0; z < this.nz; ++z) {
                for (int i = 0; i < this.ni; ++i) {
                    for (j = 0; j < this.nj; ++j) {
                        this.mu[z][i][j] = (this.betaMLEin - this.betaMLEout) * KMask[z][i][j] + this.betaMLEout;
                    }
                }
            }
            for (z = 0; z < this.nz; ++z) {
                for (int i = 0; i < this.ni; ++i) {
                    for (j = 0; j < this.nj; ++j) {
                        this.W[z][i][j] = this.mu[z][i][j] != 0.0 ? this.iWeights[z][i][j] / this.mu[z][i][j] : 4.50359962737E15;
                    }
                }
            }
        }
    }
}

