/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.solver;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import mosaic.bregman.solver.ASplitBregmanSolver2D;
import mosaic.bregman.solver.ASplitBregmanSolver3D;
import mosaic.bregman.solver.SolverParameters;
import mosaic.bregman.solver.SolverTools;
import mosaic.core.psf.psf;
import net.imglib2.type.numeric.real.DoubleType;
import org.apache.log4j.Logger;

public abstract class ASplitBregmanSolver {
    private static final Logger logger = Logger.getLogger(ASplitBregmanSolver.class);
    protected final SolverParameters iParameters;
    protected final double[][][] iImage;
    protected double iBetaMleOut;
    protected double iBetaMleIn;
    final double iRegularization;
    protected final psf<DoubleType> iPsf;
    protected final int ni;
    protected final int nj;
    protected final int nz;
    protected final SolverTools iLocalTools;
    protected final ExecutorService executor;
    protected final double[] iEnergies;
    public final double[] betaMle = new double[2];
    public final double[][][] w3k;
    public final double[][][] w3kbest;
    protected final SolverParameters.NoiseModel iNoiseModel;
    protected final double[][][] w1k;
    protected final double[][][] w2xk;
    protected final double[][][] w2yk;
    protected final double[][][] b2xk;
    protected final double[][][] b2yk;
    protected final double[][][] b1k;
    protected final double[][][] b3k;
    protected double[][][] temp1;
    protected double[][][] temp2;
    protected double[][][] temp3;
    protected double[][][] temp4;
    private int iIterNum = 0;
    private int iBestIterationNum = 0;
    private double iBestEnergy = Double.MAX_VALUE;
    private double iLastEnergy = 0.0;

    public static ASplitBregmanSolver create(SolverParameters aParameters, double[][][] aImage, double[][][] aMask, psf<DoubleType> aPsf) {
        return aImage.length > 1 ? new ASplitBregmanSolver3D(aParameters, aImage, aMask, aPsf) : new ASplitBregmanSolver2D(aParameters, aImage, aMask, aPsf);
    }

    ASplitBregmanSolver(SolverParameters aParameters, double[][][] aImage, double[][][] aMask, psf<DoubleType> aPsf) {
        this.iParameters = aParameters;
        this.iImage = aImage;
        this.iBetaMleOut = this.iParameters.betaMleOut;
        this.iBetaMleIn = this.iParameters.betaMleIn;
        this.iRegularization = this.iParameters.lambdaRegularization;
        this.iPsf = aPsf;
        this.ni = aImage[0].length;
        this.nj = aImage[0][0].length;
        this.nz = aImage.length;
        this.w3k = new double[this.nz][this.ni][this.nj];
        SolverTools.copytab(this.w3k, aMask);
        this.w3kbest = new double[this.nz][this.ni][this.nj];
        this.iLocalTools = new SolverTools(this.ni, this.nj, this.nz);
        this.executor = Executors.newFixedThreadPool(this.iParameters.numOfThreads);
        this.iEnergies = new double[this.iParameters.numOfThreads];
        this.betaMle[0] = this.iBetaMleOut;
        this.betaMle[1] = this.iBetaMleIn;
        this.iNoiseModel = this.iParameters.noiseModel;
        this.w1k = new double[this.nz][this.ni][this.nj];
        this.b2xk = new double[this.nz][this.ni][this.nj];
        this.b2yk = new double[this.nz][this.ni][this.nj];
        this.b1k = new double[this.nz][this.ni][this.nj];
        this.b3k = new double[this.nz][this.ni][this.nj];
        this.w2xk = new double[this.nz][this.ni][this.nj];
        this.w2yk = new double[this.nz][this.ni][this.nj];
        this.temp1 = new double[this.nz][this.ni][this.nj];
        this.temp2 = new double[this.nz][this.ni][this.nj];
        this.temp3 = new double[this.nz][this.ni][this.nj];
        this.temp4 = new double[this.nz][this.ni][this.nj];
    }

    public final double getBetaMleIn() {
        return this.betaMle[1];
    }

    public final boolean performIteration(boolean aLastIteration) {
        boolean energyEvaluation = this.iIterNum % this.iParameters.energyEvaluationModulo == 0 || aLastIteration;
        boolean stopFlag = false;
        try {
            this.step(energyEvaluation);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (energyEvaluation) {
            double currentEnergy = 0.0;
            for (int nt = 0; nt < this.iParameters.numOfThreads; ++nt) {
                currentEnergy += this.iEnergies[nt];
            }
            if (currentEnergy < this.iBestEnergy) {
                SolverTools.copytab(this.w3kbest, this.w3k);
                this.iBestIterationNum = this.iIterNum;
                this.iBestEnergy = currentEnergy;
            }
            if (this.iIterNum != 0 && Math.abs((currentEnergy - this.iLastEnergy) / this.iLastEnergy) < this.iParameters.energySearchThreshold) {
                stopFlag = true;
            }
            this.iLastEnergy = currentEnergy;
            this.iParameters.getClass();
        }
        ++this.iIterNum;
        return stopFlag;
    }

    public void postprocess() {
        if (this.iBestIterationNum < 50) {
            SolverTools.copytab(this.w3kbest, this.w3k);
            this.iBestIterationNum = this.iIterNum - 1;
            this.iBestEnergy = this.iLastEnergy;
            logger.debug((Object)("Warning : increasing energy. Last computed mask is then used for first phase object segmentation. Iter: " + this.iBestIterationNum));
        }
        this.iParameters.getClass();
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected abstract void step(boolean var1) throws InterruptedException;

    public abstract void init();
}

