/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.solver;

import edu.emory.mathcs.jtransforms.dct.DoubleDCT_3D;
import java.util.concurrent.CountDownLatch;
import mosaic.bregman.solver.ASplitBregmanSolver;
import mosaic.bregman.solver.SolverParameters;
import mosaic.bregman.solver.SolverTools;
import mosaic.bregman.solver.ZoneTask3D;
import mosaic.core.psf.psf;
import mosaic.utils.ArrayOps;
import net.imglib2.type.numeric.real.DoubleType;

class ASplitBregmanSolver3D
extends ASplitBregmanSolver {
    final double[][][] w2zk;
    final double[][][] b2zk;
    final double[][][] ukz;
    private final double[][][] eigenPsf3D;
    private final double[][][] eigenLaplacian3D;
    private final DoubleDCT_3D dct3d;

    ASplitBregmanSolver3D(SolverParameters aParameters, double[][][] image, double[][][] mask, psf<DoubleType> aPsf) {
        super(aParameters, image, mask, aPsf);
        this.w2zk = new double[this.nz][this.ni][this.nj];
        this.b2zk = new double[this.nz][this.ni][this.nj];
        this.ukz = new double[this.nz][this.ni][this.nj];
        int[] sz = this.iPsf.getSuggestedImageSize();
        this.temp4 = new double[Math.max(sz[2], this.nz)][Math.max(sz[0], this.ni)][Math.max(sz[1], this.nj)];
        this.temp3 = new double[Math.max(sz[2], this.nz)][Math.max(sz[0], this.ni)][Math.max(sz[1], this.nj)];
        this.temp2 = new double[Math.max(sz[2], this.nz)][Math.max(sz[0], this.ni)][Math.max(sz[1], this.nj)];
        this.temp1 = new double[Math.max(sz[2], this.nz)][Math.max(sz[0], this.ni)][Math.max(sz[1], this.nj)];
        this.dct3d = new DoubleDCT_3D(this.nz, this.ni, this.nj);
        this.eigenLaplacian3D = new double[this.nz][this.ni][this.nj];
        for (int z = 0; z < this.nz; ++z) {
            for (int i = 0; i < this.ni; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    this.eigenLaplacian3D[z][i][j] = 2.0 - 2.0 * Math.cos((double)j * Math.PI / (double)this.nj) + (2.0 - 2.0 * Math.cos((double)i * Math.PI / (double)this.ni)) + (2.0 - 2.0 * Math.cos((double)z * Math.PI / (double)this.nz));
                }
            }
        }
        this.eigenPsf3D = new double[Math.max(sz[2], this.nz)][Math.max(sz[0], this.ni)][Math.max(sz[1], this.nj)];
        this.compute_eigenPSF3D();
        this.convolveAndScale(mask);
        this.calculateGradients(mask);
    }

    @Override
    public void init() {
        this.convolveAndScale(this.w3k);
        this.calculateGradients(this.w3k);
    }

    private void calculateGradients(double[][][] aValues) {
        this.iLocalTools.fgradx2D(this.w2xk, aValues);
        this.iLocalTools.fgrady2D(this.w2yk, aValues);
        this.iLocalTools.fgradz2D(this.w2zk, aValues);
    }

    private void convolveAndScale(double[][][] aValues) {
        SolverTools.convolve3Dseparable(this.temp3, aValues, this.ni, this.nj, this.nz, this.iPsf, this.temp4);
        for (int z = 0; z < this.nz; ++z) {
            for (int i = 0; i < this.ni; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    this.w1k[z][i][j] = (this.iBetaMleIn - this.iBetaMleOut) * this.temp3[z][i][j] + this.iBetaMleOut;
                }
            }
        }
    }

    @Override
    protected void step(boolean aEvaluateEnergy) throws InterruptedException {
        CountDownLatch ZoneDoneSignal = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync1 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync2 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync3 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync4 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync5 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync6 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync7 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync8 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync9 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync10 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync11 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync12 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync13 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Dct = new CountDownLatch(1);
        int iStart = 0;
        int jStart = 0;
        int ichunk = this.ni / this.iParameters.numOfThreads;
        int ilastchunk = this.ni - ichunk * (this.iParameters.numOfThreads - 1);
        int jchunk = this.nj / this.iParameters.numOfThreads;
        int jlastchunk = this.nj - jchunk * (this.iParameters.numOfThreads - 1);
        for (int nt = 0; nt < this.iParameters.numOfThreads - 1; ++nt) {
            ZoneTask3D task = new ZoneTask3D(ZoneDoneSignal, Sync1, Sync2, Sync3, Sync4, Sync5, Sync6, Sync7, Sync8, Sync9, Sync10, Sync11, Sync12, Sync13, Dct, iStart, iStart + ichunk, jStart, jStart + jchunk, nt, this, this.iLocalTools, aEvaluateEnergy);
            this.executor.execute(task);
            iStart += ichunk;
            jStart += jchunk;
        }
        ZoneTask3D task = new ZoneTask3D(ZoneDoneSignal, Sync1, Sync2, Sync3, Sync4, Sync5, Sync6, Sync7, Sync8, Sync9, Sync10, Sync11, Sync12, Sync13, Dct, iStart, iStart + ilastchunk, jStart, jStart + jlastchunk, this.iParameters.numOfThreads - 1, this, this.iLocalTools, aEvaluateEnergy);
        this.executor.execute(task);
        Sync4.await();
        this.dct3d.forward(this.temp1, true);
        for (int z = 0; z < this.nz; ++z) {
            for (int i = 0; i < this.ni; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    double denominator = 1.0 + this.eigenLaplacian3D[z][i][j] + this.eigenPsf3D[z][i][j];
                    if (denominator == 0.0) continue;
                    this.temp1[z][i][j] = this.temp1[z][i][j] / denominator;
                }
            }
        }
        this.dct3d.inverse(this.temp1, true);
        Dct.countDown();
        ZoneDoneSignal.await();
    }

    private void compute_eigenPSF3D() {
        int[] sz = this.iPsf.getSuggestedImageSize();
        int xmin = Math.min(sz[0], this.eigenPsf3D[0].length);
        int ymin = Math.min(sz[1], this.eigenPsf3D[0][0].length);
        int zmin = Math.min(sz[2], this.eigenPsf3D.length);
        SolverTools.convolve3Dseparable(this.eigenPsf3D, this.iPsf.getImage3DAsDoubleArray(), xmin, ymin, zmin, this.iPsf, this.temp4);
        ArrayOps.fill(this.temp1, 0.0);
        for (int z = 0; z < zmin; ++z) {
            for (int i = 0; i < xmin; ++i) {
                for (int j = 0; j < ymin; ++j) {
                    this.temp1[z][i][j] = this.eigenPsf3D[z][i][j];
                }
            }
        }
        int cr = sz[0] / 2 + 1;
        int cc = sz[1] / 2 + 1;
        int cs = sz[2] / 2 + 1;
        this.iLocalTools.dctshift3D(this.temp3, this.temp1, cr, cc, cs);
        this.dct3d.forward(this.temp3, true);
        ArrayOps.fill(this.temp2, 0.0);
        this.temp2[0][0][0] = 1.0;
        this.dct3d.forward(this.temp2, true);
        for (int z = 0; z < this.nz; ++z) {
            for (int i = 0; i < this.ni; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    this.eigenPsf3D[z][i][j] = Math.pow(this.iBetaMleIn - this.iBetaMleOut, 2.0) * this.temp3[z][i][j] / this.temp2[z][i][j];
                }
            }
        }
    }
}

