/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.solver;

import java.util.concurrent.CountDownLatch;
import mosaic.bregman.solver.SolverParameters;
import mosaic.core.psf.psf;
import mosaic.utils.ArrayOps;
import net.imglib2.type.numeric.real.DoubleType;

class SolverTools {
    private final int ni;
    private final int nj;
    private final int nz;

    SolverTools(int nni, int nnj, int nnz) {
        this.ni = nni;
        this.nj = nnj;
        this.nz = nnz;
    }

    static void convolve2D(double[][] out, double[][] in, int icols, int irows, psf<DoubleType> psf2) {
        int[] sz = psf2.getSuggestedImageSize();
        int kCenterX = sz[0] / 2;
        int kCenterY = sz[1] / 2;
        double[][] kernel = psf2.getImage2DAsDoubleArray();
        for (int i = 0; i < icols; ++i) {
            for (int j = 0; j < irows; ++j) {
                double sum = 0.0;
                for (int m = 0; m < sz[0]; ++m) {
                    int mm = sz[0] - 1 - m;
                    for (int n = 0; n < sz[1]; ++n) {
                        int nn = sz[1] - 1 - n;
                        int colIndex = i + m - kCenterX;
                        int rowIndex = j + n - kCenterY;
                        if (rowIndex >= 0 && rowIndex < irows && colIndex >= 0 && colIndex < icols) {
                            sum += in[colIndex][rowIndex] * kernel[mm][nn];
                            continue;
                        }
                        do {
                            if (rowIndex < 0) {
                                rowIndex = -rowIndex - 1;
                            }
                            if (rowIndex > irows - 1) {
                                rowIndex = irows - (rowIndex - irows) - 1;
                            }
                            if (colIndex < 0) {
                                colIndex = -colIndex - 1;
                            }
                            if (colIndex <= icols - 1) continue;
                            colIndex = icols - (colIndex - icols) - 1;
                        } while (rowIndex < 0 || rowIndex >= irows || colIndex < 0 || colIndex >= icols);
                        sum += in[colIndex][rowIndex] * kernel[mm][nn];
                    }
                }
                out[i][j] = sum;
            }
        }
    }

    static void convolve2Dseparable(double[][] out, double[][] in, int icols, int irows, psf<DoubleType> psf2, double[][] temp, int iStart, int iEnd) {
        int rowIndex;
        int colIndex;
        double sum;
        int j;
        int i;
        int[] sz = psf2.getSuggestedImageSize();
        int kCenterX = sz[0] / 2;
        int kCenterY = sz[1] / 2;
        double[] kernelx = psf2.getSeparableImageAsDoubleArray(0);
        double[] kernely = psf2.getSeparableImageAsDoubleArray(1);
        for (i = iStart; i < iEnd; ++i) {
            for (j = 0; j < irows; ++j) {
                sum = 0.0;
                for (int m = 0; m < sz[0]; ++m) {
                    int mm = sz[0] - 1 - m;
                    colIndex = i + m - kCenterX;
                    rowIndex = j;
                    if (colIndex >= 0 && colIndex < icols) {
                        sum += in[colIndex][rowIndex] * kernelx[mm];
                        continue;
                    }
                    do {
                        if (colIndex < 0) {
                            colIndex = -colIndex - 1;
                        }
                        if (colIndex <= icols - 1) continue;
                        colIndex = icols - (colIndex - icols) - 1;
                    } while (colIndex < 0 || colIndex >= icols);
                    sum += in[colIndex][rowIndex] * kernelx[mm];
                }
                temp[i][j] = sum;
            }
        }
        for (i = iStart; i < iEnd; ++i) {
            for (j = 0; j < irows; ++j) {
                sum = 0.0;
                for (int n = 0; n < sz[1]; ++n) {
                    int nn = sz[1] - 1 - n;
                    colIndex = i;
                    rowIndex = j + n - kCenterY;
                    if (rowIndex >= 0 && rowIndex < irows) {
                        sum += temp[colIndex][rowIndex] * kernely[nn];
                        continue;
                    }
                    do {
                        if (rowIndex < 0) {
                            rowIndex = -rowIndex - 1;
                        }
                        if (rowIndex <= irows - 1) continue;
                        rowIndex = irows - (rowIndex - irows) - 1;
                    } while (rowIndex < 0 || rowIndex >= irows);
                    sum += temp[colIndex][rowIndex] * kernely[nn];
                }
                out[i][j] = sum;
            }
        }
    }

    static void convolve3Dseparable(double[][][] out, double[][][] in, int icols, int irows, int islices, psf<DoubleType> psf2, double[][][] temp) {
        SolverTools.convolve3Dseparable(out, in, icols, irows, islices, psf2, temp, 0, icols);
    }

    static void convolve3Dseparable(double[][][] out, double[][][] in, int icols, int irows, int islices, psf<DoubleType> psf2, double[][][] temp, int iStart, int iEnd) {
        int rowIndex;
        int colIndex;
        double sum;
        int j;
        int i;
        int k;
        int[] sz = psf2.getSuggestedImageSize();
        double[] kernelx = psf2.getSeparableImageAsDoubleArray(0);
        double[] kernely = psf2.getSeparableImageAsDoubleArray(1);
        double[] kernelz = psf2.getSeparableImageAsDoubleArray(2);
        int kCenterX = sz[0] / 2;
        int kCenterY = sz[1] / 2;
        int kCenterZ = sz[2] / 2;
        for (k = 0; k < islices; ++k) {
            for (i = iStart; i < iEnd; ++i) {
                for (j = 0; j < irows; ++j) {
                    sum = 0.0;
                    for (int m = 0; m < sz[0]; ++m) {
                        int mm = sz[0] - 1 - m;
                        colIndex = i + m - kCenterX;
                        rowIndex = j;
                        if (colIndex >= 0 && colIndex < icols) {
                            sum += in[k][colIndex][rowIndex] * kernelx[mm];
                            continue;
                        }
                        if (colIndex < 0) {
                            colIndex = -colIndex - 1;
                        }
                        if (colIndex > icols - 1) {
                            colIndex = icols - (colIndex - icols) - 1;
                        }
                        sum += in[k][colIndex][rowIndex] * kernelx[mm];
                    }
                    out[k][i][j] = sum;
                }
            }
        }
        for (k = 0; k < islices; ++k) {
            for (i = iStart; i < iEnd; ++i) {
                for (j = 0; j < irows; ++j) {
                    sum = 0.0;
                    for (int n = 0; n < sz[1]; ++n) {
                        int nn = sz[1] - 1 - n;
                        colIndex = i;
                        rowIndex = j + n - kCenterY;
                        if (rowIndex >= 0 && rowIndex < irows) {
                            sum += out[k][colIndex][rowIndex] * kernely[nn];
                            continue;
                        }
                        if (rowIndex < 0) {
                            rowIndex = -rowIndex - 1;
                        }
                        if (rowIndex > irows - 1) {
                            rowIndex = irows - (rowIndex - irows) - 1;
                        }
                        sum += out[k][colIndex][rowIndex] * kernely[nn];
                    }
                    temp[k][i][j] = sum;
                }
            }
        }
        for (k = 0; k < islices; ++k) {
            for (i = iStart; i < iEnd; ++i) {
                for (j = 0; j < irows; ++j) {
                    sum = 0.0;
                    for (int l = 0; l < sz[2]; ++l) {
                        int ll = sz[2] - 1 - l;
                        colIndex = i;
                        rowIndex = j;
                        int sliceIndex = k + l - kCenterZ;
                        if (sliceIndex >= 0 && sliceIndex < islices) {
                            sum += temp[sliceIndex][colIndex][rowIndex] * kernelz[ll];
                            continue;
                        }
                        if (sliceIndex < 0) {
                            sliceIndex = Math.min(islices - 1, -sliceIndex - 1);
                        }
                        if (sliceIndex > islices - 1) {
                            sliceIndex = Math.max(0, islices - (sliceIndex - islices) - 1);
                        }
                        sum += temp[sliceIndex][colIndex][rowIndex] * kernelz[ll];
                    }
                    out[k][i][j] = sum;
                }
            }
        }
    }

    void dctshift(double[][] result, double[][] PSF, int cc, int cr) {
        int cols = PSF.length;
        int rows = PSF[0].length;
        int k = Math.min(cr - 1, Math.min(cc - 1, Math.min(rows - cr, cols - cc)));
        ArrayOps.fill(result, 0.0);
        for (int rowShift = 0; rowShift <= 1; ++rowShift) {
            for (int colShift = 0; colShift <= 1; ++colShift) {
                for (int i = 0; i < 1 + k - colShift; ++i) {
                    for (int j = 0; j < 1 + k - rowShift; ++j) {
                        double[] dArray = result[i];
                        int n = j;
                        dArray[n] = dArray[n] + PSF[k + i + colShift][k + j + rowShift];
                    }
                }
            }
        }
        for (int i = 2 * k + 1; i < cols; ++i) {
            for (int j = 2 * k + 1; j < rows; ++j) {
                result[i][j] = 0.0;
            }
        }
    }

    void dctshift3D(double[][][] result, double[][][] PSF, int cr, int cc, int cs) {
        int slices = PSF.length;
        int cols = PSF[0].length;
        int rows = PSF[0][0].length;
        int k = Math.min(cr - 1, Math.min(cc - 1, Math.min(rows - cr, Math.min(cols - cc, Math.min(cs - 1, slices - cs)))));
        ArrayOps.fill(result, 0.0);
        for (int sliShift = 0; sliShift <= 1; ++sliShift) {
            for (int rowShift = 0; rowShift <= 1; ++rowShift) {
                for (int colShift = 0; colShift <= 1; ++colShift) {
                    for (int z = 0; z < 1 + k - sliShift; ++z) {
                        for (int i = 0; i < 1 + k - colShift; ++i) {
                            for (int j = 0; j < 1 + k - rowShift; ++j) {
                                double[] dArray = result[z][i];
                                int n = j;
                                dArray[n] = dArray[n] + PSF[k + z + sliShift][k + i + colShift][k + j + rowShift];
                            }
                        }
                    }
                }
            }
        }
        for (int z = 2 * k + 1; z < slices; ++z) {
            for (int i = 2 * k + 1; i < cols; ++i) {
                for (int j = 2 * k + 1; j < rows; ++j) {
                    result[z][i][j] = 0.0;
                }
            }
        }
    }

    void addtab(double[][][] res, double[][][] m1, double[][][] m2, int iStart, int iEnd) {
        for (int z = 0; z < this.nz; ++z) {
            for (int i = iStart; i < iEnd; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    res[z][i][j] = m1[z][i][j] + m2[z][i][j];
                }
            }
        }
    }

    void subtab(double[][][] res, double[][][] m1, double[][][] m2, int iStart, int iEnd) {
        for (int z = 0; z < this.nz; ++z) {
            for (int i = iStart; i < iEnd; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    res[z][i][j] = m1[z][i][j] - m2[z][i][j];
                }
            }
        }
    }

    static void copytab(double[][][] res, double[][][] m1) {
        int nz = res.length;
        int ni = res[0].length;
        int nj = res[0][0].length;
        for (int z = 0; z < nz; ++z) {
            for (int i = 0; i < ni; ++i) {
                for (int j = 0; j < nj; ++j) {
                    res[z][i][j] = m1[z][i][j];
                }
            }
        }
    }

    private void nllMean(double[][][] res, double[][][] image, double[][][] mu, int iStart, int iEnd, SolverParameters.NoiseModel aNoiseModel) {
        for (int z = 0; z < this.nz; ++z) {
            for (int i = iStart; i < iEnd; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    res[z][i][j] = this.noise(image[z][i][j], mu[z][i][j], aNoiseModel);
                }
            }
        }
    }

    private double noise(double im, double mu, SolverParameters.NoiseModel aNoiseModel) {
        double res;
        if (mu < 0.0) {
            mu = 1.0E-4;
        }
        if (aNoiseModel == SolverParameters.NoiseModel.POISSON) {
            res = im != 0.0 ? im * Math.log(im / mu) + mu - im : mu;
            if (mu == 0.0) {
                res = im;
            }
        } else {
            res = (im - mu) * (im - mu);
        }
        return res;
    }

    void fgradz2D(double[][][] res, double[][][] im) {
        this.fgradz2D(res, im, 0, this.ni);
    }

    void fgradz2D(double[][][] res, double[][][] im, int tStart, int tEnd) {
        for (int z = 0; z < this.nz - 1; ++z) {
            for (int i = tStart; i < tEnd; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    res[z][i][j] = im[z + 1][i][j] - im[z][i][j];
                }
            }
        }
        for (int i = tStart; i < tEnd; ++i) {
            for (int j = 0; j < this.nj; ++j) {
                res[this.nz - 1][i][j] = 0.0;
            }
        }
    }

    void fgradx2D(double[][][] res, double[][][] im) {
        this.fgradx2D(res, im, 0, this.nj);
    }

    void fgradx2D(double[][][] res, double[][][] im, int tStart, int tEnd) {
        for (int z = 0; z < this.nz; ++z) {
            for (int i = 0; i < this.ni - 1; ++i) {
                for (int j = tStart; j < tEnd; ++j) {
                    res[z][i][j] = im[z][i + 1][j] - im[z][i][j];
                }
            }
            for (int j = tStart; j < tEnd; ++j) {
                res[z][this.ni - 1][j] = 0.0;
            }
        }
    }

    void fgrady2D(double[][][] res, double[][][] im) {
        this.fgrady2D(res, im, 0, this.ni);
    }

    void fgrady2D(double[][][] res, double[][][] im, int tStart, int tEnd) {
        for (int z = 0; z < this.nz; ++z) {
            int i;
            for (i = tStart; i < tEnd; ++i) {
                for (int j = 0; j < this.nj - 1; ++j) {
                    res[z][i][j] = im[z][i][j + 1] - im[z][i][j];
                }
            }
            for (i = tStart; i < tEnd; ++i) {
                res[z][i][this.nj - 1] = 0.0;
            }
        }
    }

    private void bgradxdbc2D(double[][][] res, double[][][] im, int tStart, int tEnd) {
        for (int z = 0; z < this.nz; ++z) {
            for (int i = 1; i < this.ni - 1; ++i) {
                for (int j = tStart; j < tEnd; ++j) {
                    res[z][i][j] = -im[z][i - 1][j] + im[z][i][j];
                }
            }
            for (int j = tStart; j < tEnd; ++j) {
                res[z][this.ni - 1][j] = -im[z][this.ni - 2][j];
                res[z][0][j] = im[z][0][j];
            }
        }
    }

    private void bgradzdbc2D(double[][][] res, double[][][] im, int tStart, int tEnd) {
        int j;
        int i;
        for (int z = 1; z < this.nz - 1; ++z) {
            for (int i2 = tStart; i2 < tEnd; ++i2) {
                for (int j2 = 0; j2 < this.nj; ++j2) {
                    res[z][i2][j2] = -im[z - 1][i2][j2] + im[z][i2][j2];
                }
            }
        }
        for (i = tStart; i < tEnd; ++i) {
            for (j = 0; j < this.nj; ++j) {
                res[0][i][j] = im[0][i][j];
            }
        }
        for (i = tStart; i < tEnd; ++i) {
            for (j = 0; j < this.nj; ++j) {
                res[this.nz - 1][i][j] = -im[this.nz - 2][i][j];
            }
        }
    }

    private void bgradydbc2D(double[][][] res, double[][][] im, int tStart, int tEnd) {
        for (int z = 0; z < this.nz; ++z) {
            int i;
            for (i = tStart; i < tEnd; ++i) {
                for (int j = 1; j < this.nj - 1; ++j) {
                    res[z][i][j] = -im[z][i][j - 1] + im[z][i][j];
                }
            }
            for (i = tStart; i < tEnd; ++i) {
                res[z][i][this.nj - 1] = 0.0;
                res[z][i][this.nj - 1] = -im[z][i][this.nj - 2];
                res[z][i][0] = im[z][i][0];
            }
        }
    }

    void shrink2D(double[][][] res1, double[][][] res2, double[][][] u1, double[][][] u2, double t, int iStart, int iEnd) {
        for (int z = 0; z < this.nz; ++z) {
            for (int i = iStart; i < iEnd; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    double u1tmp = u1[z][i][j];
                    double u2tmp = u2[z][i][j];
                    double norm = Math.sqrt(u1tmp * u1tmp + u2tmp * u2tmp);
                    if (norm >= t) {
                        res1[z][i][j] = u1tmp - t * u1tmp / norm;
                        res2[z][i][j] = u2tmp - t * u2tmp / norm;
                        continue;
                    }
                    res1[z][i][j] = 0.0;
                    res2[z][i][j] = 0.0;
                }
            }
        }
    }

    void shrink3D(double[][][] res1, double[][][] res2, double[][][] res3, double[][][] u1, double[][][] u2, double[][][] u3, double t, int iStart, int iEnd) {
        for (int z = 0; z < this.nz; ++z) {
            for (int i = iStart; i < iEnd; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    double u1tmp = u1[z][i][j];
                    double u2tmp = u2[z][i][j];
                    double u3tmp = u3[z][i][j];
                    double norm = Math.sqrt(u1tmp * u1tmp + u2tmp * u2tmp + u3tmp * u3tmp);
                    if (norm >= t) {
                        res1[z][i][j] = u1tmp - t * u1tmp / norm;
                        res2[z][i][j] = u2tmp - t * u2tmp / norm;
                        res3[z][i][j] = u3tmp - t * u3tmp / norm;
                        continue;
                    }
                    res1[z][i][j] = 0.0;
                    res2[z][i][j] = 0.0;
                    res3[z][i][j] = 0.0;
                }
            }
        }
    }

    double computeEnergyPSF(double[][][] speedData, double[][][] mask, double[][][] maskx, double[][][] masky, double ldata, double lreg, psf<DoubleType> aPsf, double c0, double c1, double[][][] image, int iStart, int iEnd, int jStart, int jEnd, CountDownLatch Sync8, CountDownLatch Sync9, SolverParameters.NoiseModel aNoiseModel) throws InterruptedException {
        SolverTools.convolve2Dseparable(speedData[0], mask[0], this.ni, this.nj, aPsf, maskx[0], iStart, iEnd);
        for (int i = iStart; i < iEnd; ++i) {
            for (int j = 0; j < this.nj; ++j) {
                speedData[0][i][j] = (c1 - c0) * speedData[0][i][j] + c0;
            }
        }
        this.nllMean(speedData, image, speedData, iStart, iEnd, aNoiseModel);
        double energyData = 0.0;
        for (int i = iStart; i < iEnd; ++i) {
            for (int j = 0; j < this.nj; ++j) {
                energyData += speedData[0][i][j];
            }
        }
        SolverTools.synchronizedWait(Sync8);
        this.fgradx2D(maskx, mask, jStart, jEnd);
        this.fgrady2D(masky, mask, iStart, iEnd);
        SolverTools.synchronizedWait(Sync9);
        double energyPrior = 0.0;
        for (int z = 0; z < this.nz; ++z) {
            for (int i = iStart; i < iEnd; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    double mkx = maskx[z][i][j];
                    double mky = masky[z][i][j];
                    energyPrior += Math.sqrt(mkx * mkx + mky * mky);
                }
            }
        }
        double energy = ldata * energyData + lreg * energyPrior;
        return energy;
    }

    double computeEnergyPSF3D(double[][][] speedData, double[][][] mask, double[][][] temp, double[][][] temp2, double ldata, double lreg, psf<DoubleType> aPsf, double c0, double c1, double[][][] image, int iStart, int iEnd, int jStart, int jEnd, CountDownLatch Sync8, CountDownLatch Sync9, CountDownLatch Sync10, SolverParameters.NoiseModel aNoiseModel) throws InterruptedException {
        int j;
        int i;
        int z;
        SolverTools.convolve3Dseparable(speedData, mask, this.ni, this.nj, this.nz, aPsf, temp, iStart, iEnd);
        for (int z2 = 0; z2 < this.nz; ++z2) {
            for (int i2 = iStart; i2 < iEnd; ++i2) {
                for (int j2 = 0; j2 < this.nj; ++j2) {
                    speedData[z2][i2][j2] = (c1 - c0) * speedData[z2][i2][j2] + c0;
                }
            }
        }
        this.nllMean(speedData, image, speedData, iStart, iEnd, aNoiseModel);
        double energyData = 0.0;
        for (int z3 = 0; z3 < this.nz; ++z3) {
            for (int i3 = iStart; i3 < iEnd; ++i3) {
                for (int j3 = 0; j3 < this.nj; ++j3) {
                    energyData += speedData[z3][i3][j3];
                }
            }
        }
        SolverTools.synchronizedWait(Sync8);
        this.fgradx2D(temp, mask, jStart, jEnd);
        for (z = 0; z < this.nz; ++z) {
            for (i = 0; i < this.ni; ++i) {
                for (j = jStart; j < jEnd; ++j) {
                    double tmp = temp[z][i][j];
                    temp2[z][i][j] = tmp * tmp;
                }
            }
        }
        SolverTools.synchronizedWait(Sync10);
        this.fgrady2D(temp, mask, iStart, iEnd);
        for (z = 0; z < this.nz; ++z) {
            for (i = iStart; i < iEnd; ++i) {
                j = 0;
                while (j < this.nj) {
                    double tmp = temp[z][i][j];
                    double[] dArray = temp2[z][i];
                    int n = j++;
                    dArray[n] = dArray[n] + tmp * tmp;
                }
            }
        }
        this.fgradz2D(temp, mask, iStart, iEnd);
        for (z = 0; z < this.nz; ++z) {
            for (i = iStart; i < iEnd; ++i) {
                j = 0;
                while (j < this.nj) {
                    double tmp = temp[z][i][j];
                    double[] dArray = temp2[z][i];
                    int n = j++;
                    dArray[n] = dArray[n] + tmp * tmp;
                }
            }
        }
        SolverTools.synchronizedWait(Sync9);
        double energyPrior = 0.0;
        for (int z4 = 0; z4 < this.nz; ++z4) {
            for (int i4 = iStart; i4 < iEnd; ++i4) {
                for (int j4 = 0; j4 < this.nj; ++j4) {
                    energyPrior += Math.sqrt(temp2[z4][i4][j4]);
                }
            }
        }
        double energy = ldata * energyData + lreg * energyPrior;
        return energy;
    }

    void mydivergence(double[][][] res, double[][][] m1, double[][][] m2, double[][][] temp, CountDownLatch Sync2, int iStart, int iEnd, int jStart, int jEnd) throws InterruptedException {
        this.bgradxdbc2D(res, m1, jStart, jEnd);
        this.bgradydbc2D(temp, m2, iStart, iEnd);
        SolverTools.synchronizedWait(Sync2);
        this.addtab(res, res, temp, iStart, iEnd);
    }

    void mydivergence3D(double[][][] res, double[][][] m1, double[][][] m2, double[][][] m3, double[][][] temp, CountDownLatch Sync2, int iStart, int iEnd, int jStart, int jEnd) throws InterruptedException {
        this.bgradxdbc2D(res, m1, jStart, jEnd);
        this.bgradydbc2D(temp, m2, iStart, iEnd);
        SolverTools.synchronizedWait(Sync2);
        this.addtab(res, res, temp, iStart, iEnd);
        this.bgradzdbc2D(m1, m3, iStart, iEnd);
        this.addtab(res, res, m1, iStart, iEnd);
    }

    static void synchronizedWait(CountDownLatch aSyncLatch) throws InterruptedException {
        if (aSyncLatch != null) {
            aSyncLatch.countDown();
            aSyncLatch.await();
        }
    }

    static double round(double y, int z) {
        double factor = Math.pow(10.0, z);
        y *= factor;
        y = (int)y;
        return y /= factor;
    }
}

